require 'spec_helper'
require 'integration/automatic_validation/spec_helper'

describe "A model with an Integer property" do
  before :all do
    SailBoat.auto_migrate!

    @model = SailBoat.new
  end

  # success case
  describe "assigned to an integer" do
    before :all do
      @model.id = 1
    end

    it_should_behave_like "valid model"
  end

  describe "assigned a value coercible into an integer" do
    before :all do
      @model.id = 1.0
    end

    it_should_behave_like "valid model"
  end

  describe "assigned a value not coercible into an integer" do
    before :all do
      @model.id = "foo"
    end

    it "is invalid" do
      @model.should_not be_valid
    end

    it "has a meaningful default error message" do
      @model.errors.on(:id).should == [ 'Id must be an integer' ]
    end
  end

  describe "assigned to a too-small integer" do
    before :all do
      @model.id = 0
    end

    it "is invalid" do
      @model.should_not be_valid
    end

    it "has a meaningful default error message" do
      @model.errors.on(:id).should == [ 'Id must be greater than or equal to 1' ]
    end
  end

  describe "assigned to a too-large integer" do
    before :all do
      @model.id = 11
    end

    it "is invalid" do
      @model.should_not be_valid
    end

    it "has a meaningful default error message" do
      @model.errors.on(:id).should == [ 'Id must be less than or equal to 10' ]
    end
  end

end
