/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.wiztools.commons.ExpiryCollection;

public abstract class AbstractExpiryCollection<T>
implements ExpiryCollection<T> {
    private final Lock lock = new ReentrantLock();
    private final Thread t;

    public abstract Collection<Encp> getData();

    public AbstractExpiryCollection(final long cleanerThreadIntervalInMilliSecond) {
        this.t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(cleanerThreadIntervalInMilliSecond);
                }
                catch (InterruptedException ex) {
                    return;
                }
                if (this.isInterrupted()) {
                    return;
                }
                AbstractExpiryCollection.this.lock.lock();
                long currentTime = System.currentTimeMillis();
                HashSet<Encp> toRemove = new HashSet<Encp>();
                for (Encp e : AbstractExpiryCollection.this.getData()) {
                    if (currentTime <= e.expiryTime) continue;
                    toRemove.add(e);
                }
                AbstractExpiryCollection.this.getData().removeAll(toRemove);
                AbstractExpiryCollection.this.lock.unlock();
            }
        };
        this.t.setDaemon(true);
        this.t.start();
    }

    @Override
    public boolean add(T t, long expiryTime) {
        return this.getData().add(new Encp(t, expiryTime));
    }

    @Override
    public void clear() {
        this.getData().clear();
    }

    @Override
    public boolean contains(T t) {
        return this.getData().contains(new Encp(t, 0L));
    }

    @Override
    public boolean isEmpty() {
        return this.getData().isEmpty();
    }

    @Override
    public int size() {
        return this.getData().size();
    }

    @Override
    public void acquire() {
        this.lock.lock();
    }

    @Override
    public void release() {
        this.lock.unlock();
    }

    @Override
    public void shutdown() {
        this.t.interrupt();
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Encp> itr = this.getData().iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public T next() {
                return ((Encp)itr.next()).t;
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    protected class Encp {
        T t;
        long expiryTime;

        Encp(T t, long expiryTime) {
            this.t = t;
            this.expiryTime = expiryTime;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Encp other = (Encp)obj;
            return this.t == other.t || this.t != null && this.t.equals(other.t);
        }

        public int hashCode() {
            int hash = 3;
            hash = 71 * hash + (this.t != null ? this.t.hashCode() : 0);
            return hash;
        }
    }
}

