/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VCursor;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.ClosedShape;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangleNR;
import com.xerox.VTM.glyphs.Translucent;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRectangleOr;
import com.xerox.VTM.glyphs.VRectangleST;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.svg.Metadata;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import net.claribole.zgrviewer.AppletUtils;
import net.claribole.zgrviewer.BaseEventHandler;
import net.claribole.zgrviewer.BroughtElement;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.DistanceComparator;
import net.claribole.zgrviewer.LEdge;
import net.claribole.zgrviewer.LElem;
import net.claribole.zgrviewer.LNode;
import net.claribole.zgrviewer.LogicalStructure;
import net.claribole.zgrviewer.PeriodicActionManager;
import net.claribole.zgrviewer.RadarEvtHdlr;
import net.claribole.zgrviewer.Ring;
import net.claribole.zgrviewer.RingManager;
import net.claribole.zgrviewer.ToolPalette;
import net.claribole.zgrviewer.Utils;
import net.claribole.zgrviewer.ZGRApplication;
import net.claribole.zgrviewer.ZGRGlassPane;
import net.claribole.zgrviewer.ZP2LensAction;
import net.claribole.zvtm.engine.AnimationListener;
import net.claribole.zvtm.engine.DraggableCameraPortal;
import net.claribole.zvtm.engine.Java2DPainter;
import net.claribole.zvtm.engine.Location;
import net.claribole.zvtm.engine.SelectionListener;
import net.claribole.zvtm.engine.TransitionManager;
import net.claribole.zvtm.engine.ViewEventHandler;
import net.claribole.zvtm.fonts.FontDialog;
import net.claribole.zvtm.glyphs.DPath;
import net.claribole.zvtm.glyphs.DPathST;
import net.claribole.zvtm.lens.FSGaussianLens;
import net.claribole.zvtm.lens.FixedSizeLens;
import net.claribole.zvtm.lens.LInfTFadingLens;
import net.claribole.zvtm.lens.Lens;
import net.claribole.zvtm.lens.TFadingLens;
import net.claribole.zvtm.lens.TGaussianLens;

public class GraphicsManager
implements ComponentListener,
AnimationListener,
Java2DPainter,
SelectionListener {
    static final Color FADE_COLOR = Color.WHITE;
    public VirtualSpaceManager vsm;
    VirtualSpace mSpace;
    VirtualSpace mnSpace;
    VirtualSpace rSpace;
    static final String mainSpace = "graphSpace";
    static final String menuSpace = "menuSpace";
    static final String rdRegionVirtualSpace = "radarSpace";
    VRectangle observedRegion;
    public View mainView;
    View rView;
    static final String RADAR_VIEW_NAME = "Overview";
    Camera mainCamera;
    JPanel mainViewPanel;
    PeriodicActionManager paMngr;
    int panelWidth;
    int panelHeight;
    Lens lens;
    TFadingLens fLens;
    static int LENS_R1 = 100;
    static int LENS_R2 = 50;
    static final int WHEEL_ANIM_TIME = 50;
    static final int LENS_ANIM_TIME = 300;
    static final double DEFAULT_MAG_FACTOR = 4.0;
    static double MAG_FACTOR = 4.0;
    static double INV_MAG_FACTOR = 1.0 / MAG_FACTOR;
    static final float WHEEL_MM_STEP = 1.0f;
    static final float MAX_MAG_FACTOR = 12.0f;
    static final int DM_PORTAL_WIDTH = 200;
    static final int DM_PORTAL_HEIGHT = 200;
    static final int DM_PORTAL_INITIAL_X_OFFSET = 150;
    static final int DM_PORTAL_INITIAL_Y_OFFSET = 150;
    static final int DM_PORTAL_ANIM_TIME = 150;
    static final Color DM_COLOR = Color.RED;
    Camera dmCamera;
    DraggableCameraPortal dmPortal;
    VRectangle magWindow;
    int magWindowW;
    int magWindowN;
    int magWindowE;
    int magWindowS;
    boolean paintLinks = false;
    static final float FLOOR_ALTITUDE = -90.0f;
    static final short MOVE_UP = 0;
    static final short MOVE_DOWN = 1;
    static final short MOVE_LEFT = 2;
    static final short MOVE_RIGHT = 3;
    static final short MOVE_UP_LEFT = 4;
    static final short MOVE_UP_RIGHT = 5;
    static final short MOVE_DOWN_LEFT = 6;
    static final short MOVE_DOWN_RIGHT = 7;
    ToolPalette tp;
    BaseEventHandler meh;
    RadarEvtHdlr reh;
    ConfigManager cfgMngr;
    static final int MAX_PREV_LOC = 10;
    Vector previousLocations;
    static final int NO_LENS = 0;
    static final int ZOOMIN_LENS = 1;
    static final int ZOOMOUT_LENS = -1;
    int lensType = 0;
    int searchIndex = 0;
    String lastSearchedString = "";
    Vector matchingList = new Vector();
    VRectangleOr boundingBox;
    ZGRGlassPane gp;
    ZGRApplication zapp;
    LogicalStructure lstruct = null;
    long[] dmwnes = new long[4];
    Glyph highlightedLabel;
    Color originalHighlightedLabelColor;
    static final BasicStroke HIGHLIGHT_STROKE = new BasicStroke(2.0f);
    Vector highlightedEdges = new Vector();
    Vector originalEdgeColor = new Vector();
    Vector originalEdgeStroke = new Vector();
    Vector highlightedNodes = new Vector();
    Vector originalNodeBorderColor = new Vector();
    Vector originalNodeFillColor = new Vector();
    Vector originalNodeStroke = new Vector();
    static final int BRING_ANIM_DURATION = 300;
    static final double BRING_DISTANCE_FACTOR = 1.5;
    static final float FADED_ELEMENTS_TRANSLUCENCY = 0.1f;
    static final float[] FADE_IN_ANIM = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.9f};
    static final float[] FADE_OUT_ANIM = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.9f};
    static final float SECOND_STEP_TRANSLUCENCY = 0.4f;
    boolean isBringingAndGoing = false;
    Vector broughtElements = new Vector();
    Vector allElements;
    float[] allElementsAlpha;

    GraphicsManager(ZGRApplication za) {
        this.zapp = za;
    }

    Vector createZVTMelements(boolean applet) {
        this.vsm = new VirtualSpaceManager(applet);
        this.vsm.setMainFont(ConfigManager.defaultFont);
        this.vsm.setZoomLimit(-90);
        this.vsm.setMouseInsideGlyphColor(ConfigManager.HIGHLIGHT_COLOR);
        this.mSpace = this.vsm.addVirtualSpace(mainSpace);
        this.mainCamera = this.vsm.addCamera(mainSpace);
        this.vsm.addCamera(mainSpace);
        this.mnSpace = this.vsm.addVirtualSpace(menuSpace);
        this.vsm.addCamera(menuSpace).setAltitude(10.0f);
        this.rSpace = this.vsm.addVirtualSpace(rdRegionVirtualSpace);
        this.vsm.addCamera(rdRegionVirtualSpace);
        this.dmCamera = this.vsm.addCamera(mainSpace);
        this.observedRegion = new VRectangleST(0L, 0L, 0, 10L, 10L, ConfigManager.OBSERVED_REGION_COLOR);
        this.observedRegion.setBorderColor(ConfigManager.OBSERVED_REGION_BORDER_COLOR);
        RectangleNR seg1 = new RectangleNR(0L, 0L, 0, 0L, 500L, ConfigManager.OBSERVED_REGION_CROSSHAIR_COLOR);
        RectangleNR seg2 = new RectangleNR(0L, 0L, 0, 500L, 0L, ConfigManager.OBSERVED_REGION_CROSSHAIR_COLOR);
        if (!Utils.osIsWindows() && !Utils.osIsMacOS()) {
            this.observedRegion.setFilled(false);
        }
        this.vsm.addGlyph((Glyph)this.observedRegion, rdRegionVirtualSpace);
        this.vsm.addGlyph((Glyph)seg1, rdRegionVirtualSpace);
        this.vsm.addGlyph((Glyph)seg2, rdRegionVirtualSpace);
        this.vsm.stickToGlyph(seg1, this.observedRegion);
        this.vsm.stickToGlyph(seg2, this.observedRegion);
        this.observedRegion.setSensitivity(false);
        this.tp = new ToolPalette(this);
        Vector<Camera> cameras = new Vector<Camera>();
        cameras.add(this.vsm.getVirtualSpace(mainSpace).getCamera(0));
        cameras.add(this.vsm.getVirtualSpace(menuSpace).getCamera(0));
        cameras.add(this.tp.getPaletteCamera());
        return cameras;
    }

    void createFrameView(Vector cameras, int acc, JMenuBar jmb) {
        this.mainView = acc == 1 ? this.vsm.addExternalView(cameras, "ZGRViewer", (short)1, ConfigManager.mainViewW, ConfigManager.mainViewH, true, false, jmb) : (acc == 2 ? this.vsm.addExternalView(cameras, "ZGRViewer", (short)2, ConfigManager.mainViewW, ConfigManager.mainViewH, true, false, jmb) : this.vsm.addExternalView(cameras, "ZGRViewer", (short)0, ConfigManager.mainViewW, ConfigManager.mainViewH, true, false, jmb));
        this.mainView.setLocation(ConfigManager.mainViewX, ConfigManager.mainViewY);
        this.mainView.getFrame().addComponentListener(this);
        this.gp = new ZGRGlassPane(this);
        ((JFrame)this.mainView.getFrame()).setGlassPane(this.gp);
    }

    JPanel createPanelView(Vector cameras, int w, int h) {
        this.vsm.addPanelView(cameras, "ZGRViewer", w, h);
        this.mainView = this.vsm.getView("ZGRViewer");
        return this.mainView.getPanel();
    }

    void parameterizeView(BaseEventHandler eh) {
        this.paMngr = new PeriodicActionManager(this);
        this.mainView.setBackgroundColor(this.cfgMngr.backgroundColor);
        this.meh = eh;
        this.mainView.setEventHandler((ViewEventHandler)((Object)eh), 0);
        this.mainView.setEventHandler((ViewEventHandler)((Object)eh), 1);
        this.mainView.setEventHandler((ViewEventHandler)((Object)eh), 2);
        this.mainView.setNotifyMouseMoved(true);
        this.vsm.animator.setAnimationListener(this);
        this.mainView.setVisible(true);
        this.mainView.getPanel().addMouseMotionListener(this.paMngr);
        this.paMngr.start();
        this.mainView.setJava2DPainter(this.paMngr, (short)3);
        this.mainView.setJava2DPainter(this, (short)1);
        this.activateDynaSpot(ConfigManager.DYNASPOT, false);
        this.mainView.getCursor().setDynaSpotColor(Color.RED);
        this.mainView.getCursor().setSelectionListener(this);
        this.mainViewPanel = this.mainView.getPanel();
        this.setAntialiasing(ConfigManager.ANTIALIASING);
        this.initDM();
        this.updatePanelSize();
        this.previousLocations = new Vector();
    }

    void activateDynaSpot(boolean b, boolean updatePrefs) {
        if (updatePrefs) {
            ConfigManager.DYNASPOT = b;
        }
        this.mainView.getCursor().activateDynaSpot(b);
    }

    void setConfigManager(ConfigManager cm) {
        this.cfgMngr = cm;
    }

    void reset() {
        this.vsm.removeGlyphsFromSpace(mainSpace);
        this.vsm.addGlyph((Glyph)this.magWindow, this.mSpace);
        this.mSpace.hide(this.magWindow);
        this.previousLocations.removeAllElements();
        this.highlightedEdges.removeAllElements();
        this.highlightedNodes.removeAllElements();
        this.originalEdgeColor.removeAllElements();
        this.originalNodeFillColor.removeAllElements();
        this.originalNodeBorderColor.removeAllElements();
    }

    void initDM() {
        this.magWindow = new VRectangle(0L, 0L, 0, 1L, 1L, DM_COLOR);
        this.magWindow.setFilled(false);
        this.magWindow.setBorderColor(DM_COLOR);
        this.vsm.addGlyph((Glyph)this.magWindow, this.mSpace);
        this.mSpace.hide(this.magWindow);
    }

    void seekBoundingBox() {
        int i;
        Vector v = this.mSpace.getAllGlyphs();
        VRectangleOr largestRectangle = null;
        int lri = -1;
        for (i = 0; i < v.size(); ++i) {
            if (!(v.elementAt(i) instanceof VRectangleOr)) continue;
            VRectangleOr r = (VRectangleOr)v.elementAt(i);
            if (largestRectangle != null && !this.bigger(r, largestRectangle)) continue;
            largestRectangle = r;
            lri = i;
        }
        if (lri == -1) {
            return;
        }
        for (i = lri + 1; i < v.size(); ++i) {
            if (this.containedIn((Glyph)v.elementAt(i), largestRectangle)) continue;
            return;
        }
        this.boundingBox = largestRectangle;
        this.boundingBox.setVisible(false);
        this.boundingBox.setSensitivity(false);
    }

    boolean bigger(VRectangleOr r1, VRectangleOr r2) {
        return r1.getWidth() * r1.getHeight() > r2.getWidth() * r2.getHeight();
    }

    boolean containedIn(Glyph g, VRectangle r) {
        if (g instanceof DPath || g instanceof VText) {
            return true;
        }
        return g.vx > r.vx - r.getWidth() && g.vx < r.vx + r.getWidth() && g.vy > r.vy - r.getHeight() && g.vy < r.vy + r.getHeight();
    }

    void setAntialiasing(boolean b) {
        ConfigManager.ANTIALIASING = b;
        this.mainView.setAntialiasing(ConfigManager.ANTIALIASING);
    }

    void updatePanelSize() {
        this.tp.displayPalette(false);
        try {
            this.panelWidth = this.mainViewPanel.getWidth();
            this.panelHeight = this.mainViewPanel.getHeight();
            this.paMngr.requestToolPaletteRelocation();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void reveal() {
        Camera c = this.mSpace.getCamera(0);
        Location l = this.vsm.getGlobalView(c);
        c.posx = l.vx;
        c.posy = l.vy;
        c.updatePrecisePosition();
        c.setAltitude(l.alt - c.getFocal());
        this.rememberLocation(this.mSpace.getCamera(0).getLocation());
        TransitionManager.fadeIn(this.mainView, 500, this.vsm);
        this.getGlobalView();
    }

    void getGlobalView() {
        Location l = this.vsm.getGlobalView(this.mSpace.getCamera(0), ConfigManager.ANIM_MOVE_LENGTH);
        this.rememberLocation(this.mSpace.getCamera(0).getLocation());
    }

    void getHigherView() {
        Camera c = this.mainView.getCameraNumber(0);
        this.rememberLocation(c.getLocation());
        Float alt = new Float(c.getAltitude() + c.getFocal());
        this.vsm.animator.createCameraAnimation(ConfigManager.ANIM_MOVE_LENGTH, (short)5, alt, c.getID());
    }

    void getLowerView() {
        Camera c = this.mainView.getCameraNumber(0);
        this.rememberLocation(c.getLocation());
        Float alt = new Float(-(c.getAltitude() + c.getFocal()) / 2.0f);
        this.vsm.animator.createCameraAnimation(ConfigManager.ANIM_MOVE_LENGTH, (short)5, alt, c.getID());
    }

    void translateView(short direction) {
        LongPoint trans;
        Camera c = this.mainView.getCameraNumber(0);
        this.rememberLocation(c.getLocation());
        long[] rb = this.mainView.getVisibleRegion(c);
        if (direction == 0) {
            long qt = Math.round((double)(rb[1] - rb[3]) / 2.4);
            trans = new LongPoint(0L, qt);
        } else if (direction == 1) {
            long qt = Math.round((double)(rb[3] - rb[1]) / 2.4);
            trans = new LongPoint(0L, qt);
        } else if (direction == 3) {
            long qt = Math.round((double)(rb[2] - rb[0]) / 2.4);
            trans = new LongPoint(qt, 0L);
        } else if (direction == 2) {
            long qt = Math.round((double)(rb[0] - rb[2]) / 2.4);
            trans = new LongPoint(qt, 0L);
        } else if (direction == 4) {
            long qt = Math.round((double)(rb[3] - rb[1]) / 2.4);
            long qt2 = Math.round((double)(rb[2] - rb[0]) / 2.4);
            trans = new LongPoint(qt, qt2);
        } else if (direction == 5) {
            long qt = Math.round((double)(rb[1] - rb[3]) / 2.4);
            long qt2 = Math.round((double)(rb[2] - rb[0]) / 2.4);
            trans = new LongPoint(qt, qt2);
        } else if (direction == 7) {
            long qt = Math.round((double)(rb[1] - rb[3]) / 2.4);
            long qt2 = Math.round((double)(rb[0] - rb[2]) / 2.4);
            trans = new LongPoint(qt, qt2);
        } else {
            long qt = Math.round((double)(rb[3] - rb[1]) / 2.4);
            long qt2 = Math.round((double)(rb[0] - rb[2]) / 2.4);
            trans = new LongPoint(qt, qt2);
        }
        this.vsm.animator.createCameraAnimation(ConfigManager.ANIM_MOVE_LENGTH, (short)2, trans, c.getID());
    }

    void rememberLocation(Location l) {
        if (this.previousLocations.size() >= 10) {
            this.previousLocations.removeElementAt(0);
        }
        if (this.previousLocations.size() > 0) {
            if (!Location.equals((Location)this.previousLocations.lastElement(), l)) {
                this.previousLocations.add(l);
            }
        } else {
            this.previousLocations.add(l);
        }
    }

    void moveBack() {
        if (this.previousLocations.size() > 0) {
            Location newlc = (Location)this.previousLocations.lastElement();
            Location currentlc = this.mSpace.getCamera(0).getLocation();
            Vector animParams = Location.getDifference(currentlc, newlc);
            this.vsm.animator.createCameraAnimation(ConfigManager.ANIM_MOVE_LENGTH, (short)6, animParams, this.mSpace.getCamera(0).getID());
            this.previousLocations.removeElementAt(this.previousLocations.size() - 1);
        }
    }

    void showRadarView(boolean b) {
        if (b) {
            if (this.rView == null) {
                Vector<Camera> cameras = new Vector<Camera>();
                cameras.add(this.mSpace.getCamera(1));
                cameras.add(this.rSpace.getCamera(0));
                this.vsm.addExternalView(cameras, RADAR_VIEW_NAME, (short)0, ConfigManager.rdW, ConfigManager.rdH, false, true);
                this.reh = new RadarEvtHdlr(this);
                this.rView = this.vsm.getView(RADAR_VIEW_NAME);
                this.rView.setBackgroundColor(this.cfgMngr.backgroundColor);
                this.rView.setEventHandler(this.reh, 0);
                this.rView.setEventHandler(this.reh, 1);
                this.rView.setResizable(false);
                this.rView.setActiveLayer(1);
                this.rView.setCursorIcon(13);
                this.vsm.getGlobalView(this.mSpace.getCamera(1), 100);
                this.cameraMoved();
            } else {
                this.rView.toFront();
            }
        }
    }

    public void cameraMoved() {
        if (this.rView != null) {
            Camera c0 = this.mSpace.getCamera(1);
            Camera c1 = this.rSpace.getCamera(0);
            c1.posx = c0.posx;
            c1.posy = c0.posy;
            c1.focal = c0.focal;
            c1.altitude = c0.altitude;
            c1.updatePrecisePosition();
            long[] wnes = this.mainView.getVisibleRegion(this.mSpace.getCamera(0));
            this.observedRegion.moveTo((wnes[0] + wnes[2]) / 2L, (wnes[3] + wnes[1]) / 2L);
            this.observedRegion.setWidth((wnes[2] - wnes[0]) / 2L);
            this.observedRegion.setHeight((wnes[1] - wnes[3]) / 2L);
        }
        this.vsm.repaintNow();
    }

    void updateMainViewFromRadar() {
        Camera c0 = this.mSpace.getCamera(0);
        c0.posx = this.observedRegion.vx;
        c0.posy = this.observedRegion.vy;
        this.vsm.repaintNow();
    }

    void centerRADAR_VIEW_NAME() {
        if (this.rView != null) {
            this.vsm.getGlobalView(this.mSpace.getCamera(1), ConfigManager.ANIM_MOVE_LENGTH);
            this.cameraMoved();
        }
    }

    void setLens(int t) {
        this.lensType = t;
    }

    void moveLens(int x, int y, long absTime) {
        if (this.fLens != null) {
            this.fLens.setAbsolutePosition(x, y, absTime);
        } else {
            this.lens.setAbsolutePosition(x, y);
        }
        this.vsm.repaintNow();
    }

    void zoomInPhase1(int x, int y) {
        if (this.lens == null) {
            this.lens = this.mainView.setLens(this.getLensDefinition(x, y));
            this.lens.setBufferThreshold(1.5f);
        }
        this.vsm.animator.createLensAnimation(300L, (short)3, (Object)new Float(MAG_FACTOR - 1.0), this.lens.getID(), null);
        this.setLens(1);
    }

    void zoomInPhase2(long mx, long my) {
        float cameraAbsAlt = this.mainCamera.getAltitude() + this.mainCamera.getFocal();
        long c2x = Math.round((double)mx - INV_MAG_FACTOR * (double)(mx - this.mainCamera.posx));
        long c2y = Math.round((double)my - INV_MAG_FACTOR * (double)(my - this.mainCamera.posy));
        Vector<Object> cadata = new Vector<Object>();
        Float deltAlt = new Float((double)cameraAbsAlt * (1.0 - MAG_FACTOR) / MAG_FACTOR);
        if (cameraAbsAlt + deltAlt.floatValue() > -90.0f) {
            cadata.add(deltAlt);
            cadata.add(new LongPoint(c2x - this.mainCamera.posx, c2y - this.mainCamera.posy));
            this.vsm.animator.createLensAnimation(300L, (short)3, (Object)new Float(-MAG_FACTOR + 1.0), this.lens.getID(), new ZP2LensAction(this));
            this.vsm.animator.createCameraAnimation(300L, (short)7, cadata, this.mainCamera.getID(), null);
        } else {
            Float actualDeltAlt = new Float(-90.0f - cameraAbsAlt);
            double ratio = actualDeltAlt.floatValue() / deltAlt.floatValue();
            cadata.add(actualDeltAlt);
            cadata.add(new LongPoint(Math.round((double)(c2x - this.mainCamera.posx) * ratio), Math.round((double)(c2y - this.mainCamera.posy) * ratio)));
            this.vsm.animator.createLensAnimation(300L, (short)3, (Object)new Float(-MAG_FACTOR + 1.0), this.lens.getID(), new ZP2LensAction(this));
            this.vsm.animator.createCameraAnimation(300L, (short)7, cadata, this.mainCamera.getID(), null);
        }
    }

    void zoomOutPhase1(int x, int y, long mx, long my) {
        float cameraAbsAlt = this.mainCamera.getAltitude() + this.mainCamera.getFocal();
        long c2x = Math.round((double)mx - MAG_FACTOR * (double)(mx - this.mainCamera.posx));
        long c2y = Math.round((double)my - MAG_FACTOR * (double)(my - this.mainCamera.posy));
        Vector<Object> cadata = new Vector<Object>();
        cadata.add(new Float((double)cameraAbsAlt * (MAG_FACTOR - 1.0)));
        cadata.add(new LongPoint(c2x - this.mainCamera.posx, c2y - this.mainCamera.posy));
        if (this.lens == null) {
            this.lens = this.mainView.setLens(this.getLensDefinition(x, y));
            this.lens.setBufferThreshold(1.5f);
        }
        this.vsm.animator.createLensAnimation(300L, (short)3, (Object)new Float(MAG_FACTOR - 1.0), this.lens.getID(), null);
        this.vsm.animator.createCameraAnimation(300L, (short)7, cadata, this.mainCamera.getID(), null);
        this.setLens(-1);
    }

    void zoomOutPhase2() {
        this.vsm.animator.createLensAnimation(300L, (short)3, (Object)new Float(-MAG_FACTOR + 1.0), this.lens.getID(), new ZP2LensAction(this));
    }

    void setMagFactor(double m) {
        MAG_FACTOR = m;
        INV_MAG_FACTOR = 1.0 / MAG_FACTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void magnifyFocus(double magOffset, int zooming, Camera ca) {
        Lens lens = this.lens;
        synchronized (lens) {
            double nmf = MAG_FACTOR + magOffset;
            if (nmf <= 12.0 && nmf > 1.0) {
                this.setMagFactor(nmf);
                if (zooming == -1) {
                    float a1 = this.mainCamera.getAltitude();
                    this.lens.setMaximumMagnification((float)nmf, true);
                    this.mainCamera.altitudeOffset((float)((double)(a1 + this.mainCamera.getFocal()) * magOffset / (MAG_FACTOR - magOffset)));
                    this.mainCamera.move(Math.round((a1 - this.mainCamera.getAltitude()) / this.mainCamera.getFocal() * (float)this.lens.lx), -Math.round((a1 - this.mainCamera.getAltitude()) / this.mainCamera.getFocal() * (float)this.lens.ly));
                } else {
                    this.vsm.animator.createLensAnimation(50L, (short)3, (Object)new Float(magOffset), this.lens.getID(), null);
                }
            }
        }
    }

    Lens getLensDefinition(int x, int y) {
        FixedSizeLens res;
        if (this.tp.isFadingLensNavMode()) {
            this.fLens = new LInfTFadingLens(1.0f, 0.0f, 0.95f, 100, x - this.panelWidth / 2, y - this.panelHeight / 2);
            res = this.fLens;
        } else if (this.tp.isMeltingLensNavMode()) {
            res = new TGaussianLens(1.0f, 0.0f, 0.9f, 150, 50, x - this.panelWidth / 2, y - this.panelHeight / 2);
            this.fLens = null;
        } else {
            res = new FSGaussianLens(1.0f, 100, 50, x - this.panelWidth / 2, y - this.panelHeight / 2);
            this.fLens = null;
        }
        return res;
    }

    void triggerDM(int x, int y) {
        if (this.dmPortal != null) {
            this.killDM();
        } else {
            this.createDM(x, y);
        }
    }

    void createDM(int x, int y) {
        this.dmPortal = new DraggableCameraPortal(x, y, 200, 200, this.dmCamera);
        this.dmPortal.setPortalEventHandler(this.meh);
        this.dmPortal.setBackgroundColor(this.mainView.getBackgroundColor());
        this.vsm.addPortal(this.dmPortal, this.mainView);
        this.dmPortal.setBorder(DM_COLOR);
        Location l = this.dmPortal.getSeamlessView(this.mainCamera);
        this.dmCamera.moveTo(l.vx, l.vy);
        this.dmCamera.setAltitude((float)((double)(this.mainCamera.getAltitude() + this.mainCamera.getFocal()) / 4.0 - (double)this.mainCamera.getFocal()));
        this.updateMagWindow();
        int w = Math.round((float)(this.magWindow.getWidth() * 2L) * this.mainCamera.getFocal() / (this.mainCamera.getFocal() + this.mainCamera.getAltitude()));
        int h = Math.round((float)(this.magWindow.getHeight() * 2L) * this.mainCamera.getFocal() / (this.mainCamera.getFocal() + this.mainCamera.getAltitude()));
        this.dmPortal.sizeTo(w, h);
        this.mSpace.onTop(this.magWindow);
        this.mSpace.show(this.magWindow);
        this.paintLinks = true;
        Point[] data = new Point[]{new Point(200 - w, 200 - h), new Point(150 - w / 2, 150 - h / 2)};
        this.vsm.animator.createPortalAnimation(150L, (short)7, data, this.dmPortal.getID(), null);
    }

    void killDM() {
        if (this.dmPortal != null) {
            this.vsm.destroyPortal(this.dmPortal);
            this.dmPortal = null;
            this.mSpace.hide(this.magWindow);
            this.paintLinks = false;
        }
        this.meh.resetDragMagInteraction();
    }

    void updateMagWindow() {
        if (this.dmPortal == null) {
            return;
        }
        this.dmPortal.getVisibleRegion(this.dmwnes);
        this.magWindow.moveTo(this.dmCamera.posx, this.dmCamera.posy);
        this.magWindow.setWidth((this.dmwnes[2] - this.dmwnes[0]) / 2L + 1L);
        this.magWindow.setHeight((this.dmwnes[1] - this.dmwnes[3]) / 2L + 1L);
    }

    void updateZoomWindow() {
        this.dmCamera.moveTo(this.magWindow.vx, this.magWindow.vy);
    }

    public void paint(Graphics2D g2d, int viewWidth, int viewHeight) {
        if (this.paintLinks) {
            float coef = this.mainCamera.focal / (this.mainCamera.focal + this.mainCamera.altitude);
            int magWindowX = viewWidth / 2 + Math.round((float)(this.magWindow.vx - this.mainCamera.posx) * coef);
            int magWindowY = viewHeight / 2 - Math.round((float)(this.magWindow.vy - this.mainCamera.posy) * coef);
            int magWindowW = Math.round((float)this.magWindow.getWidth() * coef);
            int magWindowH = Math.round((float)this.magWindow.getHeight() * coef);
            g2d.setColor(DM_COLOR);
            g2d.drawLine(magWindowX - magWindowW, magWindowY - magWindowH, this.dmPortal.x, this.dmPortal.y);
            g2d.drawLine(magWindowX + magWindowW, magWindowY - magWindowH, this.dmPortal.x + this.dmPortal.w, this.dmPortal.y);
            g2d.drawLine(magWindowX - magWindowW, magWindowY + magWindowH, this.dmPortal.x, this.dmPortal.y + this.dmPortal.h);
            g2d.drawLine(magWindowX + magWindowW, magWindowY + magWindowH, this.dmPortal.x + this.dmPortal.w, this.dmPortal.y + this.dmPortal.h);
        }
    }

    void search(String s, int direction) {
        if (s.length() > 0) {
            int matchSize;
            if (!s.toLowerCase().equals(this.lastSearchedString)) {
                this.resetSearch(s);
                Glyph[] gl = this.mSpace.getVisibleGlyphList();
                for (int i = 0; i < gl.length; ++i) {
                    if (!(gl[i] instanceof VText) || ((VText)gl[i]).getText() == null || ((VText)gl[i]).getText().toLowerCase().indexOf(this.lastSearchedString) == -1) continue;
                    this.matchingList.add(gl[i]);
                }
            }
            if ((matchSize = this.matchingList.size()) > 0) {
                this.searchIndex += direction;
                if (this.searchIndex < 0) {
                    this.searchIndex = matchSize - 1;
                } else if (this.searchIndex >= matchSize) {
                    this.searchIndex = 0;
                }
                if (matchSize > 1) {
                    this.zapp.setStatusBarText(AppletUtils.rankString(this.searchIndex + 1) + " of " + matchSize + " matches");
                } else {
                    this.zapp.setStatusBarText("1 match");
                }
                Glyph g = (Glyph)this.matchingList.elementAt(this.searchIndex);
                this.vsm.centerOnGlyph(g, this.mSpace.getCamera(0), ConfigManager.ANIM_MOVE_LENGTH, true, ConfigManager.MAG_FACTOR * 1.5f);
                this.highlight(g);
                this.vsm.repaintNow();
            } else {
                this.zapp.setStatusBarText("No match");
            }
        }
    }

    void resetSearch(String s) {
        this.searchIndex = -1;
        this.lastSearchedString = s.toLowerCase();
        this.matchingList.removeAllElements();
        if (this.highlightedLabel != null) {
            this.highlightedLabel.setColor(this.originalHighlightedLabelColor);
            this.highlightedLabel = null;
        }
    }

    void highlight(Glyph g) {
        if (this.highlightedLabel != null) {
            this.highlightedLabel.setColor(this.originalHighlightedLabelColor);
        }
        this.highlightedLabel = g;
        this.originalHighlightedLabelColor = this.highlightedLabel.getColor();
        this.highlightedLabel.setColor(ConfigManager.HIGHLIGHT_COLOR);
    }

    void assignFontToGraph() {
        Font f = FontDialog.getFontDialog((JFrame)this.mainView.getFrame(), ConfigManager.defaultFont);
        if (f != null) {
            ConfigManager.defaultFont = f;
            Vector glyphs = this.mSpace.getAllGlyphs();
            for (int i = 0; i < glyphs.size(); ++i) {
                Object g = glyphs.elementAt(i);
                if (!(g instanceof VText)) continue;
                ((VText)g).setSpecialFont(null);
            }
            this.vsm.setMainFont(ConfigManager.defaultFont);
        }
    }

    public void componentResized(ComponentEvent e) {
        if (e.getSource() == this.mainView.getFrame()) {
            this.updatePanelSize();
            this.cameraMoved();
            Dimension sz = this.mainView.getFrame().getSize();
            this.cfgMngr.setSDZoomThreshold(0.3 * Math.sqrt(Math.pow(sz.width, 2.0) + Math.pow(sz.height, 2.0)));
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    void buildLogicalStructure() {
        Vector glyphs = (Vector)this.mSpace.getAllGlyphs().clone();
        glyphs.remove(this.magWindow);
        glyphs.remove(this.boundingBox);
        this.lstruct = LogicalStructure.build(glyphs);
        if (this.lstruct == null) {
            this.tp.hideLogicalTools();
            this.mainView.setStatusBarText("Failed to build logical structure. Some tools are disabled.");
        } else {
            this.tp.showLogicalTools();
        }
        glyphs = this.mSpace.getAllGlyphs();
        for (int i = 0; i < glyphs.size(); ++i) {
            Glyph g = (Glyph)glyphs.elementAt(i);
            if (g.getOwner() == null || !(g.getOwner() instanceof Metadata)) continue;
            g.setOwner(new LElem((Metadata)g.getOwner()));
        }
    }

    void highlightElement(Glyph g, Camera cam, VCursor cursor, boolean highlight) {
        Object o = null;
        if (g != null && g != this.boundingBox) {
            o = g.getOwner();
        } else {
            Vector otherGlyphs = cursor.getIntersectingTexts(cam);
            if (otherGlyphs != null && otherGlyphs.size() > 0) {
                g = (Glyph)otherGlyphs.firstElement();
                if (g.getOwner() != null) {
                    o = g.getOwner();
                }
            } else {
                otherGlyphs = cursor.getIntersectingPaths(cam);
                if (otherGlyphs != null && otherGlyphs.size() > 0) {
                    g = (Glyph)otherGlyphs.firstElement();
                    if (g.getOwner() != null) {
                        o = g.getOwner();
                    }
                } else {
                    this.unhighlightAll();
                }
            }
        }
        if (o != null) {
            if (o instanceof LNode) {
                this.highlightNode((LNode)o, highlight);
            } else if (o instanceof LEdge) {
                this.highlightEdge((LEdge)o, highlight);
            }
        }
    }

    synchronized void highlightNode(LNode n, boolean highlight) {
        if (highlight) {
            Glyph g;
            int i;
            for (i = 0; i < n.glyphs.length; ++i) {
                g = n.glyphs[i];
                if (this.highlightedNodes.contains(g)) continue;
                this.highlightedNodes.add(g);
                this.highlightNodeGlyph(g);
            }
            for (i = 0; i < n.edges.length; ++i) {
                int j;
                for (j = 0; j < n.edges[i].glyphs.length; ++j) {
                    g = n.edges[i].glyphs[j];
                    if (this.highlightedEdges.contains(g)) continue;
                    this.highlightedEdges.add(g);
                    this.highlightEdgeGlyph(g);
                }
                Glyph[] gs = n.edges[i].tail == n ? n.edges[i].head.glyphs : n.edges[i].tail.glyphs;
                for (j = 0; j < gs.length; ++j) {
                    g = gs[j];
                    if (this.highlightedNodes.contains(g)) continue;
                    this.highlightedNodes.add(g);
                    this.highlightNodeGlyph(g);
                }
            }
        } else {
            this.unhighlightAll();
        }
    }

    synchronized void highlightEdge(LEdge e, boolean highlight) {
        if (highlight) {
            Glyph g;
            int i;
            for (i = 0; i < e.glyphs.length; ++i) {
                g = e.glyphs[i];
                if (this.highlightedEdges.contains(g)) continue;
                this.highlightedEdges.add(g);
                this.highlightEdgeGlyph(g);
            }
            for (i = 0; i < e.tail.glyphs.length; ++i) {
                g = e.tail.glyphs[i];
                if (this.highlightedNodes.contains(g)) continue;
                this.highlightedNodes.add(g);
                this.highlightNodeGlyph(g);
            }
            for (i = 0; i < e.head.glyphs.length; ++i) {
                g = e.head.glyphs[i];
                if (this.highlightedNodes.contains(g)) continue;
                this.highlightedNodes.add(g);
                this.highlightNodeGlyph(g);
            }
        } else {
            this.unhighlightAll();
        }
    }

    void highlightNodeGlyph(Glyph g) {
        this.originalNodeStroke.add(g.getStroke());
        if (g instanceof ClosedShape) {
            this.originalNodeFillColor.add(null);
            this.originalNodeBorderColor.add(((ClosedShape)g).getDefaultBorderColor());
            if (g.isBorderDrawn()) {
                g.setBorderColor(ConfigManager.HIGHLIGHT_COLOR);
            }
        } else {
            this.originalNodeFillColor.add(null);
            this.originalNodeBorderColor.add(g.getDefaultColor());
            g.setColor(ConfigManager.HIGHLIGHT_COLOR);
        }
        g.setStroke(HIGHLIGHT_STROKE);
    }

    void highlightEdgeGlyph(Glyph g) {
        this.originalEdgeColor.add(g.getDefaultColor());
        this.originalEdgeStroke.add(g.getStroke());
        if (g instanceof ClosedShape) {
            if (g.isFilled()) {
                g.setColor(ConfigManager.HIGHLIGHT_COLOR);
            }
            if (g.isBorderDrawn()) {
                g.setBorderColor(ConfigManager.HIGHLIGHT_COLOR);
            }
        } else {
            g.setColor(ConfigManager.HIGHLIGHT_COLOR);
        }
        g.setStroke(HIGHLIGHT_STROKE);
    }

    void unhighlightAll() {
        this.unhighlightAllEdges();
        this.unhighlightAllNodes();
    }

    void unhighlightAllNodes() {
        for (int i = 0; i < this.highlightedNodes.size(); ++i) {
            Glyph g = (Glyph)this.highlightedNodes.elementAt(i);
            if (g instanceof ClosedShape) {
                if (g.isBorderDrawn()) {
                    g.setBorderColor((Color)this.originalNodeBorderColor.elementAt(i));
                }
            } else {
                g.setColor((Color)this.originalNodeBorderColor.elementAt(i));
            }
            g.setStroke((BasicStroke)this.originalNodeStroke.elementAt(i));
        }
        this.highlightedNodes.removeAllElements();
        this.originalNodeBorderColor.removeAllElements();
        this.originalNodeFillColor.removeAllElements();
        this.originalNodeStroke.removeAllElements();
    }

    void unhighlightAllEdges() {
        for (int i = 0; i < this.highlightedEdges.size(); ++i) {
            Glyph g = (Glyph)this.highlightedEdges.elementAt(i);
            if (g instanceof ClosedShape) {
                if (g.isFilled()) {
                    g.setColor((Color)this.originalEdgeColor.elementAt(i));
                }
                if (g.isBorderDrawn()) {
                    g.setBorderColor((Color)this.originalEdgeColor.elementAt(i));
                }
            } else {
                g.setColor((Color)this.originalEdgeColor.elementAt(i));
            }
            g.setStroke((BasicStroke)this.originalEdgeStroke.elementAt(i));
        }
        this.highlightedEdges.removeAllElements();
        this.originalEdgeColor.removeAllElements();
        this.originalEdgeStroke.removeAllElements();
    }

    void enterBringAndGoMode() {
        System.out.println("Entering BG mode");
    }

    void exitBringAndGoMode() {
        System.out.println("Exiting BG mode");
    }

    void startBringAndGo(Glyph g) {
        ClosedShape otherEndShape;
        LNode otherEnd;
        int i;
        this.isBringingAndGoing = true;
        LNode n = LogicalStructure.getNode(g);
        if (n == null) {
            return;
        }
        this.allElements = (Vector)this.mSpace.getAllGlyphs().clone();
        this.allElements.remove(this.magWindow);
        ClosedShape thisEndShape = n.getShape();
        Glyph[] glyphs = n.getGlyphs();
        for (int i2 = 0; i2 < glyphs.length; ++i2) {
            this.allElements.remove(glyphs[i2]);
        }
        double thisEndBoundingCircleRadius = thisEndShape.getSize();
        double RING_STEP = 4.0 * thisEndBoundingCircleRadius;
        LEdge[] arcs = n.getAllArcs();
        Arrays.sort(arcs, new DistanceComparator(n));
        Hashtable<LNode, LongPoint> node2bposition = new Hashtable<LNode, LongPoint>();
        RingManager rm = new RingManager();
        for (i = 0; i < arcs.length; ++i) {
            if (arcs[i].isLoop()) continue;
            otherEnd = arcs[i].getOtherEnd(n);
            otherEndShape = otherEnd.getShape();
            double d = Math.sqrt(Math.pow(otherEndShape.vx - thisEndShape.vx, 2.0) + Math.pow(otherEndShape.vy - thisEndShape.vy, 2.0));
            Ring ring = rm.getRing(Math.atan2(otherEndShape.vy - thisEndShape.vy, otherEndShape.vx - thisEndShape.vx), otherEndShape.getSize(), RING_STEP);
            double bd = (double)ring.rank * RING_STEP;
            double ratio = bd / d;
            long bx = thisEndShape.vx + Math.round(ratio * (double)(otherEndShape.vx - thisEndShape.vx));
            long by = thisEndShape.vy + Math.round(ratio * (double)(otherEndShape.vy - thisEndShape.vy));
            node2bposition.put(otherEnd, new LongPoint(bx, by));
        }
        for (i = 0; i < arcs.length; ++i) {
            if (arcs[i].isLoop()) continue;
            otherEnd = arcs[i].getOtherEnd(n);
            otherEndShape = otherEnd.getShape();
            this.bring(arcs[i], otherEnd, thisEndShape.vx, thisEndShape.vy, otherEndShape.vx, otherEndShape.vy, node2bposition);
        }
        this.allElementsAlpha = new float[this.allElements.size()];
        for (int i3 = 0; i3 < this.allElements.size(); ++i3) {
            try {
                Translucent t = (Translucent)this.allElements.elementAt(i3);
                this.allElementsAlpha[i3] = t.getTranslucencyValue();
                this.vsm.animator.createGlyphAnimation(300L, (short)9, FADE_OUT_ANIM, ((Glyph)((Object)t)).getID());
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
    }

    void endBringAndGo(Glyph g) {
        int i;
        System.out.println("Ending bring and go");
        this.isBringingAndGoing = false;
        if (!this.broughtElements.isEmpty()) {
            for (i = this.broughtElements.size() - 1; i >= 0; --i) {
                this.sendBack((BroughtElement)this.broughtElements.elementAt(i));
            }
        }
        for (i = 0; i < this.allElements.size(); ++i) {
            try {
                this.vsm.animator.createGlyphAnimation(300L, (short)9, FADE_IN_ANIM, ((Glyph)this.allElements.elementAt(i)).getID());
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.allElements.clear();
    }

    void attemptToBringMore(Glyph g) {
        System.out.println("Attempting to bring more for " + g);
    }

    void attemptToBringLess(Glyph g) {
        System.out.println("Attempting to send back for " + g);
    }

    void bring(LEdge arc, LNode node, long sx, long sy, long ex, long ey, Hashtable node2bposition) {
        LongPoint ep;
        LongPoint sp;
        this.broughtElements.add(BroughtElement.rememberPreviousState(node));
        this.broughtElements.add(BroughtElement.rememberPreviousState(arc));
        ClosedShape nodeShape = node.getShape();
        this.allElements.remove(nodeShape);
        LongPoint bposition = (LongPoint)node2bposition.get(node);
        LongPoint translation = new LongPoint(bposition.x - nodeShape.vx, bposition.y - nodeShape.vy);
        Glyph[] glyphs = node.getGlyphs();
        for (int i = 0; i < glyphs.length; ++i) {
            this.allElements.remove(glyphs[i]);
            this.vsm.animator.createGlyphAnimation(300L, (short)2, translation, glyphs[i].getID());
        }
        DPathST spline = arc.getSpline();
        this.allElements.remove(spline);
        LongPoint asp = spline.getStartPoint();
        LongPoint aep = spline.getEndPoint();
        if (Math.sqrt(Math.pow(asp.x - ex, 2.0) + Math.pow(asp.y - ey, 2.0)) < Math.sqrt(Math.pow(asp.x - sx, 2.0) + Math.pow(asp.y - sy, 2.0))) {
            sp = new LongPoint(bposition.x, bposition.y);
            ep = new LongPoint(sx, sy);
        } else {
            sp = new LongPoint(sx, sy);
            ep = new LongPoint(bposition.x, bposition.y);
        }
        this.mSpace.above(spline, this.boundingBox);
        LongPoint[] flatCoords = DPath.getFlattenedCoordinates(spline, sp, ep, true);
        this.vsm.animator.createPathAnimation(300L, (short)5, flatCoords, spline.getID(), null);
        glyphs = arc.getGlyphs();
        for (int i = 0; i < glyphs.length; ++i) {
            if (glyphs[i] == spline) continue;
            this.allElements.remove(glyphs[i]);
            if (glyphs[i] instanceof VText) {
                this.vsm.animator.createGlyphAnimation(300L, (short)2, new LongPoint(bposition.x - sx, bposition.y - sy), glyphs[i].getID());
                continue;
            }
            glyphs[i].setVisible(false);
        }
        LEdge[] otherArcs = node.getOtherArcs(arc);
        for (int i = 0; i < otherArcs.length; ++i) {
            this.broughtElements.add(BroughtElement.rememberPreviousState(otherArcs[i]));
            spline = otherArcs[i].getSpline();
            this.allElements.remove(spline);
            asp = spline.getStartPoint();
            aep = spline.getEndPoint();
            if (node2bposition.containsKey(otherArcs[i].getTail()) && node2bposition.containsKey(otherArcs[i].getHead())) {
                sp = (LongPoint)node2bposition.get(otherArcs[i].getTail());
                ep = (LongPoint)node2bposition.get(otherArcs[i].getHead());
            } else {
                ClosedShape oe = otherArcs[i].getOtherEnd(node).getShape();
                if (Math.sqrt(Math.pow(asp.x - ex, 2.0) + Math.pow(asp.y - ey, 2.0)) <= Math.sqrt(Math.pow(aep.x - ex, 2.0) + Math.pow(aep.y - ey, 2.0))) {
                    sp = new LongPoint(bposition.x, bposition.y);
                    ep = oe.getLocation();
                } else {
                    sp = oe.getLocation();
                    ep = new LongPoint(bposition.x, bposition.y);
                }
            }
            flatCoords = DPath.getFlattenedCoordinates(spline, sp, ep, true);
            this.mSpace.above(spline, this.boundingBox);
            this.vsm.animator.createPathAnimation(300L, (short)5, flatCoords, spline.getID(), null);
            spline.setTranslucencyValue(0.4f);
            glyphs = otherArcs[i].getGlyphs();
            for (int j = 0; j < glyphs.length; ++j) {
                if (glyphs[j] == spline) continue;
                this.allElements.remove(glyphs[j]);
                if (glyphs[j] instanceof VText) continue;
                glyphs[j].setVisible(false);
            }
        }
    }

    void sendBack(BroughtElement be) {
        be.restorePreviousState(this.vsm.animator, 300);
        this.broughtElements.remove(be);
    }

    public void glyphSelected(Glyph g, boolean b) {
        Object o = g.getOwner();
        if (o instanceof LEdge) {
            this.highlightEdge((LEdge)o, b);
        }
    }
}

