/*
 * Decompiled with CFR 0.152.
 */
package free.jin.event;

import free.chess.Player;
import free.jin.Connection;
import free.jin.Game;
import free.jin.event.GameEvent;

public class OfferEvent
extends GameEvent {
    public static final int DRAW_OFFER = 1;
    public static final int ADJOURN_OFFER = 2;
    public static final int ABORT_OFFER = 3;
    public static final int TAKEBACK_OFFER = 4;
    private final int offerId;
    private final boolean isOffered;
    private final Player player;
    private final int takebackCount;

    public OfferEvent(Connection connection, Game game, int n, boolean bl, Player player) {
        super(connection, game);
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad offer id: " + n);
            }
        }
        if (player == null) {
            throw new IllegalArgumentException("player may not be null");
        }
        this.offerId = n;
        this.isOffered = bl;
        this.player = player;
        this.takebackCount = -1;
    }

    public OfferEvent(Connection connection, Game game, boolean bl, Player player, int n) {
        super(connection, game);
        if (n <= 0) {
            throw new IllegalArgumentException("takebackCount must be positive");
        }
        this.offerId = 4;
        this.isOffered = bl;
        this.player = player;
        this.takebackCount = n;
    }

    public int getOfferId() {
        return this.offerId;
    }

    public boolean isOffered() {
        return this.isOffered;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getTakebackCount() {
        if (this.offerId != 4) {
            throw new IllegalStateException("The offer is not takeback");
        }
        return this.takebackCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("OfferEvent[");
        switch (this.getOfferId()) {
            case 1: {
                stringBuffer.append("DRAW_OFFER,");
                break;
            }
            case 3: {
                stringBuffer.append("ABORT_OFFER,");
                break;
            }
            case 2: {
                stringBuffer.append("ADJOURN_OFFER,");
                break;
            }
            case 4: {
                stringBuffer.append("TAKEBACK_OFFER(" + this.getTakebackCount() + "), ");
            }
        }
        stringBuffer.append(this.getPlayer() + ", ");
        if (this.isOffered()) {
            stringBuffer.append("offered]");
        } else {
            stringBuffer.append("not offered]");
        }
        return stringBuffer.toString();
    }
}

