/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpstatistics;

import java.awt.Color;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.sf.gogui.gtpstatistics.Plot;
import net.sf.gogui.gtpstatistics.PositionStatistics;
import net.sf.gogui.utils.Histogram;
import net.sf.gogui.utils.Table;
import net.sf.gogui.utils.TableUtils;

public final class CommandStatistics {
    public final boolean m_isBeginCommand;
    public final int m_maxMove;
    public final DecimalFormat m_format;
    public final PositionStatistics m_statisticsAll;
    public final PositionStatistics m_statisticsFinal;
    public final ArrayList m_statisticsAtMove;
    public final Table m_tableAtMove;

    public CommandStatistics(String string, Table table, Table table2, File file, File file2, Color color, int n) throws Exception {
        Object object;
        this.m_statisticsAll = new PositionStatistics(string, table, false, 0.0, 0.0);
        double d = this.m_statisticsAll.getMin();
        double d2 = this.m_statisticsAll.getMax();
        this.m_statisticsFinal = new PositionStatistics(string, table2, true, d, d2);
        this.m_statisticsAtMove = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Move");
        arrayList.add("Mean");
        arrayList.add("Error");
        this.m_tableAtMove = new Table(arrayList);
        this.m_maxMove = (int)(TableUtils.getMax(table, "Move") + 1.0);
        boolean bl = true;
        for (int i = 1; i <= this.m_maxMove; ++i) {
            Table table3 = TableUtils.selectIntRange(table, "Move", i, i);
            object = new PositionStatistics(string, table3, true, d, d2);
            this.m_statisticsAtMove.add(object);
            int n2 = ((PositionStatistics)object).getCount();
            if (n2 <= 0) continue;
            if (i > 1) {
                bl = false;
            }
            this.m_tableAtMove.startRow();
            this.m_tableAtMove.set("Move", i);
            this.m_tableAtMove.set("Mean", ((PositionStatistics)object).getMean());
            this.m_tableAtMove.set("Error", ((PositionStatistics)object).getError());
        }
        this.m_isBeginCommand = bl;
        this.m_format = CommandStatistics.getFormat(n, d, d2);
        if (this.getCount() > 0) {
            Histogram histogram = this.m_statisticsAll.m_histogram;
            object = TableUtils.fromHistogram(histogram, string);
            Plot plot = new Plot(200, 150, color, n);
            this.setHistogramProperties(plot);
            plot.plot(file, (Table)object, string, "Count", null);
            histogram = this.m_statisticsFinal.m_histogram;
            if (this.m_statisticsFinal.getCount() > 0) {
                object = TableUtils.fromHistogram(histogram, string);
                plot = new Plot(200, 150, color, n);
                this.setHistogramProperties(plot);
                plot.plot(file2, (Table)object, string, "Count", null);
            }
        }
    }

    public int getCount() {
        return this.m_statisticsAll.getCount();
    }

    public PositionStatistics getStatistics(int n) {
        return (PositionStatistics)this.m_statisticsAtMove.get(n);
    }

    public boolean onlyBoolValues() {
        return this.m_statisticsAll.m_onlyBoolValues;
    }

    public void setHistogramProperties(Plot plot) {
        Histogram histogram = this.m_statisticsAll.m_histogram;
        double d = histogram.getStep();
        plot.setPlotStyleBars(d);
        plot.setYMin(0.0);
        plot.setNoPlotYZero();
        if (this.onlyBoolValues()) {
            plot.setXLabelsBool();
        } else {
            plot.setXMin(histogram.getMin() - d / 2.0);
            plot.setXMax(histogram.getMax() + d / 2.0);
            plot.setFormatX(this.m_format);
        }
    }

    private static DecimalFormat getFormat(int n, double d, double d2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        double d3 = Math.max(Math.abs(d), Math.abs(d2));
        if (d3 < 10000.0) {
            decimalFormat.setMaximumFractionDigits(n);
            decimalFormat.setGroupingUsed(false);
            return decimalFormat;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0.");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('#');
        }
        stringBuffer.append("E0");
        decimalFormat.applyPattern(stringBuffer.toString());
        return decimalFormat;
    }
}

