/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.utils.MessageQueue;
import net.sf.gogui.utils.ProcessUtils;
import net.sf.gogui.utils.StringUtils;

public final class GtpClient {
    private boolean m_autoNumber;
    private InvalidResponseCallback m_invalidResponseCallback;
    private boolean m_exitInProgress;
    private boolean m_isInterruptCommentSupported;
    private boolean m_isProgramDead;
    private boolean m_log;
    private int m_protocolVersion = 2;
    private int m_commandNumber;
    private IOCallback m_callback;
    private PrintWriter m_out;
    private Process m_process;
    private String m_fullResponse;
    private String m_response;
    private String m_logPrefix;
    private String m_pid;
    private String m_program;
    private String[] m_supportedCommands;
    private MessageQueue m_queue;
    private TimeoutCallback m_timeoutCallback;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GtpClient(String string, boolean bl, IOCallback iOCallback) throws GtpError {
        this.m_log = bl;
        this.m_callback = iOCallback;
        this.m_program = string;
        if (this.m_program.indexOf("%SRAND") >= 0) {
            int n = Short.MAX_VALUE;
            int n2 = (int)(Math.random() * (double)(n + 1));
            this.m_program = this.m_program.replaceAll("%SRAND", Integer.toString(n2));
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            this.m_process = runtime.exec(StringUtils.splitArguments(string));
        }
        catch (IOException iOException) {
            throw new GtpError("Could not execute " + string + ":\n" + iOException.getMessage());
        }
        this.init(this.m_process.getInputStream(), this.m_process.getOutputStream(), this.m_process.getErrorStream());
    }

    public GtpClient(InputStream inputStream, OutputStream outputStream, boolean bl, IOCallback iOCallback) throws GtpError {
        this.m_log = bl;
        this.m_callback = iOCallback;
        this.m_program = "-";
        this.m_process = null;
        this.init(inputStream, outputStream, null);
    }

    public void close() {
        this.m_out.close();
    }

    public void destroyProcess() {
        if (this.m_process != null) {
            this.m_process.destroy();
        }
    }

    public String getResponse() {
        return this.m_response;
    }

    public String getCommandBoardsize(int n) {
        if (this.m_protocolVersion == 2) {
            return "boardsize " + n;
        }
        return null;
    }

    public String getCommandClearBoard(int n) {
        if (this.m_protocolVersion == 1) {
            return "boardsize " + n;
        }
        return "clear_board";
    }

    public String getCommandGenmove(GoColor goColor) {
        if (!$assertionsDisabled && goColor != GoColor.BLACK && goColor != GoColor.WHITE) {
            throw new AssertionError();
        }
        if (this.m_protocolVersion == 1) {
            if (goColor == GoColor.BLACK) {
                return "genmove_black";
            }
            return "genmove_white";
        }
        if (goColor == GoColor.BLACK) {
            return "genmove b";
        }
        return "genmove w";
    }

    public String getCommandPlay(Move move) {
        String string = GoPoint.toString(move.getPoint());
        GoColor goColor = move.getColor();
        if (this.m_protocolVersion == 1) {
            if (goColor == GoColor.BLACK) {
                return "black " + string;
            }
            if (goColor == GoColor.WHITE) {
                return "white " + string;
            }
            if (!$assertionsDisabled && goColor != GoColor.EMPTY) {
                throw new AssertionError();
            }
            return "empty " + string;
        }
        if (goColor == GoColor.BLACK) {
            return "play b " + string;
        }
        if (goColor == GoColor.WHITE) {
            return "play w " + string;
        }
        if (!$assertionsDisabled && goColor != GoColor.EMPTY) {
            throw new AssertionError();
        }
        return "play empty " + string;
    }

    public double getCpuTime() throws GtpError {
        try {
            return Double.parseDouble(this.send("cputime"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new GtpError("Invalid response to cputime command");
        }
    }

    public String getFullResponse() {
        return this.m_fullResponse;
    }

    public String getProgramCommand() {
        return this.m_program;
    }

    public int getProtocolVersion() {
        return this.m_protocolVersion;
    }

    public ArrayList getSupportedCommands() {
        ArrayList<String> arrayList = new ArrayList<String>(128);
        if (this.m_supportedCommands != null) {
            for (int i = 0; i < this.m_supportedCommands.length; ++i) {
                arrayList.add(this.m_supportedCommands[i]);
            }
        }
        return arrayList;
    }

    public boolean isCommandSupported(String string) {
        if (this.m_supportedCommands == null) {
            return false;
        }
        for (int i = 0; i < this.m_supportedCommands.length; ++i) {
            if (!this.m_supportedCommands[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isCpuTimeSupported() {
        return this.isCommandSupported("cputime");
    }

    public boolean isInterruptSupported() {
        return this.m_isInterruptCommentSupported || this.m_pid != null;
    }

    public boolean isProgramDead() {
        return this.m_isProgramDead;
    }

    public void queryInterruptSupport() {
        try {
            if (this.isCommandSupported("gogui_interrupt")) {
                this.send("gogui_interrupt");
                this.m_isInterruptCommentSupported = true;
            } else if (this.isCommandSupported("gogui_sigint")) {
                this.m_pid = this.send("gogui_sigint").trim();
            }
        }
        catch (GtpError gtpError) {
            // empty catch block
        }
    }

    public String queryName() {
        try {
            return this.send("name");
        }
        catch (GtpError gtpError) {
            return "Unknown Program";
        }
    }

    public void queryProtocolVersion() throws GtpError {
        try {
            String string;
            try {
                string = this.send("protocol_version");
            }
            catch (GtpError gtpError) {
                this.m_protocolVersion = 2;
                return;
            }
            int n = Integer.parseInt(string);
            if (n < 1 || n > 2) {
                throw new GtpError("Unknown protocol version: " + n);
            }
            this.m_protocolVersion = n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new GtpError("Invalid protocol version");
        }
    }

    public void querySupportedCommands() throws GtpError {
        String string = this.m_protocolVersion == 1 ? "help" : "list_commands";
        String string2 = this.send(string);
        this.m_supportedCommands = StringUtils.splitArguments(string2);
        for (int i = 0; i < this.m_supportedCommands.length; ++i) {
            this.m_supportedCommands[i] = this.m_supportedCommands[i].trim();
        }
    }

    public String queryVersion() {
        try {
            return this.send("version");
        }
        catch (GtpError gtpError) {
            return "";
        }
    }

    public String send(String string) throws GtpError {
        return this.send(string, -1L, null);
    }

    public String send(String string, long l, TimeoutCallback timeoutCallback) throws GtpError {
        if (!$assertionsDisabled && string.trim().equals("")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string.trim().startsWith("#")) {
            throw new AssertionError();
        }
        this.m_timeoutCallback = timeoutCallback;
        this.m_fullResponse = "";
        this.m_response = "";
        ++this.m_commandNumber;
        if (this.m_autoNumber) {
            string = Integer.toString(this.m_commandNumber) + " " + string;
        }
        this.log(">> " + string);
        this.m_out.println(string);
        this.m_out.flush();
        if (this.m_out.checkError()) {
            this.readRemainingErrorMessages();
            this.throwProgramDied();
        }
        if (this.m_callback != null) {
            this.m_callback.sentCommand(string);
        }
        this.readResponse(l);
        return this.m_response;
    }

    public void sendBoardsize(int n) throws GtpError {
        String string = this.getCommandBoardsize(n);
        if (string != null) {
            this.send(string);
        }
    }

    public void sendClearBoard(int n) throws GtpError {
        this.send(this.getCommandClearBoard(n));
    }

    public void sendPlay(Move move) throws GtpError {
        this.send(this.getCommandPlay(move));
    }

    public void sendPlay(Move move, long l, TimeoutCallback timeoutCallback) throws GtpError {
        this.send(this.getCommandPlay(move), l, timeoutCallback);
    }

    public void sendComment(String string) {
        if (!$assertionsDisabled && !string.trim().startsWith("#")) {
            throw new AssertionError();
        }
        this.log(">> " + string);
        if (this.m_callback != null) {
            this.m_callback.sentCommand(string);
        }
        this.m_out.println(string);
        this.m_out.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendInterrupt() throws GtpError {
        if (this.m_isInterruptCommentSupported) {
            this.sendComment("# interrupt");
            return;
        }
        if (this.m_pid == null) throw new GtpError("Interrupt not supported");
        String string = "kill -INT " + this.m_pid;
        this.log(" " + string);
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(string);
            int n = process.waitFor();
            if (n == 0) return;
            throw new GtpError("Command \"" + string + "\" returned " + n);
        }
        catch (IOException iOException) {
            throw new GtpError("Could not run command " + string + ":\n" + iOException);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void setAutoNumber(boolean bl) {
        this.m_autoNumber = bl;
    }

    public void setInvalidResponseCallback(InvalidResponseCallback invalidResponseCallback) {
        this.m_invalidResponseCallback = invalidResponseCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogPrefix(String string) {
        GtpClient gtpClient = this;
        synchronized (gtpClient) {
            this.m_logPrefix = string;
        }
    }

    public void waitForExit() {
        if (this.m_process == null) {
            return;
        }
        try {
            this.m_process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Interrupted");
        }
    }

    public void waitForExit(int n, TimeoutCallback timeoutCallback) {
        this.setExitInProgress(true);
        if (this.m_process == null) {
            return;
        }
        while (!ProcessUtils.waitForExit(this.m_process, n)) {
            if (timeoutCallback.askContinue()) continue;
            this.m_process.destroy();
            return;
        }
    }

    private synchronized boolean getExitInProgress() {
        return this.m_exitInProgress;
    }

    private void handleErrorStream(String string) {
        if (string == null) {
            return;
        }
        if (this.m_callback != null) {
            this.m_callback.receivedStdErr(string);
        }
    }

    private void init(InputStream inputStream, OutputStream outputStream, InputStream inputStream2) {
        this.m_out = new PrintWriter(outputStream);
        this.m_isProgramDead = false;
        this.m_queue = new MessageQueue();
        InputThread inputThread = new InputThread(inputStream, this.m_queue);
        if (inputStream2 != null) {
            ErrorThread errorThread = new ErrorThread(inputStream2, this.m_queue);
            errorThread.start();
        }
        inputThread.start();
    }

    private synchronized void log(String string) {
        if (this.m_log) {
            if (this.m_logPrefix != null) {
                System.err.print(this.m_logPrefix);
            }
            System.err.println(string);
        }
    }

    private synchronized void logError(String string) {
        if (this.m_log) {
            System.err.print(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeErrorMessages(Message message) {
        if (!$assertionsDisabled && message.m_type != 2) {
            throw new AssertionError();
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        while (message != null) {
            if (message.m_text != null) {
                stringBuffer.append(message.m_text);
            }
            Object object = this.m_queue.getMutex();
            synchronized (object) {
                message = (Message)this.m_queue.unsynchronizedPeek();
                if (message != null && message.m_type != 2) {
                    message = null;
                }
            }
            if (message == null) continue;
            message = (Message)this.m_queue.getIfAvaliable();
        }
        this.handleErrorStream(stringBuffer.toString());
    }

    private void readRemainingErrorMessages() {
        while (!this.m_queue.isEmpty()) {
            Message message = (Message)this.m_queue.waitFor();
            if (message.m_type != 2 || message.m_text == null) continue;
            this.handleErrorStream(message.m_text);
        }
    }

    private String readResponse(long l) throws GtpError {
        Message message;
        while (true) {
            message = this.waitForMessage(l);
            if (message.m_type == 2) {
                this.mergeErrorMessages(message);
                continue;
            }
            if (message.m_type != 1) break;
            this.m_fullResponse = message.m_text;
            if (this.m_callback != null) {
                this.m_callback.receivedInvalidResponse(this.m_fullResponse);
            }
            if (this.m_invalidResponseCallback == null) continue;
            this.m_invalidResponseCallback.show(this.m_fullResponse);
        }
        if (!$assertionsDisabled && message.m_type != 0) {
            throw new AssertionError();
        }
        String string = message.m_text;
        if (string == null) {
            this.m_isProgramDead = true;
            this.readRemainingErrorMessages();
            this.throwProgramDied();
        }
        boolean bl = string.charAt(0) != '=';
        this.m_fullResponse = string;
        if (this.m_callback != null) {
            this.m_callback.receivedResponse(bl, this.m_fullResponse);
        }
        if (!$assertionsDisabled && string.length() < 3) {
            throw new AssertionError();
        }
        int n = string.indexOf(32);
        int n2 = string.length();
        this.m_response = n < 0 ? string.substring(1, n2 - 2) : string.substring(n + 1, n2 - 2);
        if (bl) {
            if (this.m_response.trim().equals("")) {
                throw new GtpError("GTP command failed");
            }
            throw new GtpError(this.m_response);
        }
        return this.m_response;
    }

    private synchronized void setExitInProgress(boolean bl) {
        this.m_exitInProgress = bl;
    }

    private void throwProgramDied() throws GtpError {
        this.m_isProgramDead = true;
        throw new GtpError("Go program died");
    }

    private Message waitForMessage(long l) throws GtpError {
        Message message;
        if (l < 0L) {
            message = (Message)this.m_queue.waitFor();
        } else {
            message = null;
            while (message == null) {
                message = (Message)this.m_queue.waitFor(l);
                if (message != null) continue;
                if (!$assertionsDisabled && this.m_timeoutCallback == null) {
                    throw new AssertionError();
                }
                if (this.m_timeoutCallback.askContinue()) continue;
                this.destroyProcess();
                this.throwProgramDied();
            }
        }
        return message;
    }

    static {
        $assertionsDisabled = !GtpClient.class.desiredAssertionStatus();
    }

    private class ErrorThread
    extends Thread {
        private final Reader m_in;
        private final MessageQueue m_queue;

        public ErrorThread(InputStream inputStream, MessageQueue messageQueue) {
            this.m_in = new InputStreamReader(inputStream);
            this.m_queue = messageQueue;
        }

        public void run() {
            try {
                this.mainLoop();
            }
            catch (Throwable throwable) {
                StringUtils.printException(throwable);
            }
        }

        private void mainLoop() throws InterruptedException {
            int n = 1024;
            char[] cArray = new char[n];
            while (true) {
                int n2;
                try {
                    n2 = this.m_in.read(cArray, 0, n);
                }
                catch (IOException iOException) {
                    n2 = -1;
                }
                String string = null;
                if (n2 > 0) {
                    string = new String(cArray, 0, n2);
                }
                this.m_queue.put(new Message(2, string));
                if (string == null) {
                    return;
                }
                GtpClient.this.logError(string);
                if (!GtpClient.this.getExitInProgress()) continue;
                Thread.sleep(this.m_queue.getSize() / 10);
            }
        }
    }

    private class InputThread
    extends Thread {
        private final BufferedReader m_in;
        private final MessageQueue m_queue;
        private final StringBuffer m_buffer = new StringBuffer(1024);

        InputThread(InputStream inputStream, MessageQueue messageQueue) {
            this.m_in = new BufferedReader(new InputStreamReader(inputStream));
            this.m_queue = messageQueue;
        }

        public void run() {
            try {
                this.mainLoop();
            }
            catch (Throwable throwable) {
                StringUtils.printException(throwable);
            }
        }

        private void appendBuffer(String string) {
            this.m_buffer.append(string);
            this.m_buffer.append('\n');
        }

        private boolean isResponseStart(String string) {
            if (string.length() < 1) {
                return false;
            }
            char c = string.charAt(0);
            return c == '=' || c == '?';
        }

        private void mainLoop() throws InterruptedException {
            while (true) {
                String string;
                if ((string = this.readLine()) == null) {
                    this.putMessage(0, null);
                    return;
                }
                this.appendBuffer(string);
                if (!this.isResponseStart(string)) {
                    this.putMessage(1);
                    continue;
                }
                do {
                    string = this.readLine();
                    this.appendBuffer(string);
                    if (string != null) continue;
                    this.putMessage(0, null);
                    return;
                } while (!string.equals(""));
                Thread.yield();
                this.putMessage(0);
                if (!GtpClient.this.getExitInProgress()) continue;
                Thread.sleep(this.m_queue.getSize() / 10);
            }
        }

        private void putMessage(int n) {
            this.putMessage(n, this.m_buffer.toString());
            this.m_buffer.setLength(0);
        }

        private void putMessage(int n, String string) {
            this.m_queue.put(new Message(n, string));
        }

        private String readLine() {
            try {
                String string = this.m_in.readLine();
                if (string != null) {
                    GtpClient.this.log("<< " + string);
                }
                return string;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    private static final class Message {
        public static final int RESPONSE = 0;
        public static final int INVALID = 1;
        public static final int ERROR = 2;
        public int m_type;
        public String m_text;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Message(int n, String string) {
            if (!$assertionsDisabled && n != 0 && n != 1 && n != 2) {
                throw new AssertionError();
            }
            this.m_type = n;
            this.m_text = string;
        }

        static {
            $assertionsDisabled = !(class$net$sf$gogui$gtp$GtpClient == null ? (class$net$sf$gogui$gtp$GtpClient = GtpClient.class$("net.sf.gogui.gtp.GtpClient")) : class$net$sf$gogui$gtp$GtpClient).desiredAssertionStatus();
        }
    }

    public static interface IOCallback {
        public void receivedInvalidResponse(String var1);

        public void receivedResponse(boolean var1, String var2);

        public void receivedStdErr(String var1);

        public void sentCommand(String var1);
    }

    public static interface InvalidResponseCallback {
        public void show(String var1);
    }

    public static interface TimeoutCallback {
        public boolean askContinue();
    }
}

