/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.twogtp;

import java.io.File;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.twogtp.Analyze;
import net.sf.gogui.twogtp.Compare;
import net.sf.gogui.twogtp.Openings;
import net.sf.gogui.twogtp.TwoGtp;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class Main {
    public static void main(String[] stringArray) {
        try {
            boolean bl;
            boolean bl2;
            String[] stringArray2 = new String[]{"alternate", "analyze:", "auto", "black:", "compare", "config:", "force", "games:", "help", "loadsgf", "komi:", "observer:", "openings:", "referee:", "sgffile:", "size:", "time:", "verbose", "version", "white:"};
            Options options = Options.parse(stringArray, stringArray2);
            if (options.isSet("help")) {
                String string = "Usage: java -jar twogtp.jar [options]\n\n-alternate      alternate colors\n-analyze file   analyze result file\n-auto           autoplay games\n-black          command for black program\n-compare        compare list of sgf files\n-config         config file\n-force          overwrite existing files\n-games          number of games (0=unlimited)\n-help           display this help and exit\n-komi           komi\n-loadsgf        use loadsgf command for openings\n-observer       command for observer program\n-openings       directory with opening sgf files\n-referee        command for referee program\n-sgffile        filename prefix\n-size           board size for autoplay (default 19)\n-time spec      set time limits (min[+min/moves])\n-verbose        log GTP streams to stderr\n-version        print version and exit\n-white          command for white program\n";
                System.out.print(string);
                System.exit(0);
            }
            if (bl2 = options.isSet("compare")) {
                Compare.compare(options.getArguments());
                System.exit(0);
            }
            boolean bl3 = options.isSet("force");
            if (options.isSet("version")) {
                System.out.println("TwoGtp " + Version.get());
                System.exit(0);
            }
            if (options.contains("analyze")) {
                String string = options.getString("analyze");
                new Analyze(string, bl3);
                return;
            }
            boolean bl4 = options.isSet("alternate");
            boolean bl5 = options.isSet("auto");
            boolean bl6 = options.isSet("verbose");
            String string = options.getString("black", "");
            String string2 = options.getString("white", "");
            String string3 = options.getString("referee", "");
            String string4 = options.getString("observer", "");
            int n = options.getInteger("size", 19, 1, 25);
            double d = 6.5;
            boolean bl7 = options.isSet("komi");
            if (bl7) {
                d = options.getDouble("komi");
            }
            TimeSettings timeSettings = null;
            if (options.isSet("time")) {
                timeSettings = TimeSettings.parse(options.getString("time"));
            }
            int n2 = bl5 ? 1 : 0;
            int n3 = options.getInteger("games", n2, 0);
            String string5 = options.getString("sgffile", "");
            if (options.isSet("games") && string5.equals("")) {
                throw new ErrorMessage("Use option -sgffile with -games");
            }
            Openings openings = null;
            if (options.isSet("openings")) {
                openings = new Openings(new File(options.getString("openings")));
            }
            if ((bl = options.isSet("loadsgf")) && openings == null) {
                throw new ErrorMessage("Use option -loadsgf with -openings");
            }
            if (bl && !bl5) {
                throw new ErrorMessage("Option -loadsgf can only be used with -auto");
            }
            TwoGtp twoGtp = new TwoGtp(string, string2, string3, string4, n, d, bl7, n3, bl4, string5, bl3, bl6, openings, bl, timeSettings);
            if (bl5) {
                if (twoGtp.gamesLeft() == 0) {
                    System.err.println("Already " + n3 + " games played");
                }
                twoGtp.autoPlay();
            } else {
                twoGtp.mainLoop(System.in, System.out);
            }
            twoGtp.close();
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            System.exit(-1);
        }
    }

    private Main() {
    }
}

