/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.util.Localizer;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class OutputHandler
extends DefaultHandler {
    private final ErrorHandler eh;
    private int lineNumber = -1;
    private String systemId = null;
    private final StringBuffer message = new StringBuffer();
    private boolean inMessage = false;
    private final String lineSeparator;
    private static final String indent = "  ";
    private final Localizer localizer = new Localizer(OutputHandler.class);

    OutputHandler(ErrorHandler eh) {
        this.eh = eh;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inMessage) {
            block3: for (int i = 0; i < length; ++i) {
                char c = ch[start + i];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (this.message.length() != 0 && this.message.charAt(this.message.length() - 1) == ' ') continue block3;
                        this.message.append(' ');
                        continue block3;
                    }
                    default: {
                        this.message.append(c);
                    }
                }
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("failed-assertion") || localName.equals("report")) {
            String value = attributes.getValue("", "line-number");
            if (value == null) {
                this.lineNumber = -1;
            } else {
                try {
                    this.lineNumber = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    this.lineNumber = -1;
                }
            }
            value = attributes.getValue("", "system-id");
            if (value != null && value.equals("")) {
                value = null;
            }
            this.systemId = value;
            this.message.append(this.localizer.message(localName.equals("failed-assertion") ? "failed_assertion" : "report"));
        } else if (localName.equals("statement") || localName.equals("diagnostic")) {
            this.inMessage = true;
            this.message.append(this.lineSeparator);
            this.message.append(indent);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("statement") || localName.equals("diagnostic")) {
            if (this.message.length() > 0 && this.message.charAt(this.message.length() - 1) == ' ') {
                this.message.setLength(this.message.length() - 1);
            }
            this.inMessage = false;
        } else if (localName.equals("failed-assertion") || localName.equals("report")) {
            this.eh.error(new SAXParseException(this.message.toString(), null, this.systemId, this.lineNumber, -1));
            this.message.setLength(0);
        }
    }
}

