/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DeregisterImage
extends BaseCmd {
    public DeregisterImage(String[] args) {
        super("ec2dereg", "ec2-deregister");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"ami");
        OptionBuilder.hasArgs();
        result.addOption(OptionBuilder.create((String)"a"));
        return result;
    }

    protected String getOptionString() {
        return "IMAGE";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Deregister a previously registered IMAGE. The IMAGE parameter is the");
        System.out.println("     ID of the Amazon Image to deregister. An Amazon Image may be:");
        System.out.println("     \t- an Amazon Machine Image (AMI) or");
        System.out.println("     \t- an Amazon Kernel  Image (AKI) or");
        System.out.println("     \t- an Amazon Ramdisk Image (ARI).");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("AMI");
        this.warnIfTooManyNonOptions();
        jec2.deregisterImage(this.getNonOptions()[0]);
        out.outputImageId(System.out, this.getNonOptions()[0]);
        return true;
    }

    public static void main(String[] args) {
        new DeregisterImage(args).invoke();
    }
}

