/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.util.concurrent.AbstractFuture;
import java.util.List;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.NodePair;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SyncStat;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.MerkleTrees;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncTask
extends AbstractFuture<SyncStat>
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(SyncTask.class);
    protected final RepairJobDesc desc;
    protected final TreeResponse r1;
    protected final TreeResponse r2;
    protected volatile SyncStat stat;

    public SyncTask(RepairJobDesc desc, TreeResponse r1, TreeResponse r2) {
        this.desc = desc;
        this.r1 = r1;
        this.r2 = r2;
    }

    @Override
    public void run() {
        List<Range<Token>> differences = MerkleTrees.difference(this.r1.trees, this.r2.trees);
        this.stat = new SyncStat(new NodePair(this.r1.endpoint, this.r2.endpoint), differences.size());
        String format = String.format("[repair #%s] Endpoints %s and %s %%s for %s", this.desc.sessionId, this.r1.endpoint, this.r2.endpoint, this.desc.columnFamily);
        if (differences.isEmpty()) {
            logger.info(String.format(format, "are consistent"));
            Tracing.traceRepair("Endpoint {} is consistent with {} for {}", this.r1.endpoint, this.r2.endpoint, this.desc.columnFamily);
            this.set(this.stat);
            return;
        }
        logger.info(String.format(format, "have " + differences.size() + " range(s) out of sync"));
        Tracing.traceRepair("Endpoint {} has {} range(s) out of sync with {} for {}", this.r1.endpoint, differences.size(), this.r2.endpoint, this.desc.columnFamily);
        this.startSync(differences);
    }

    public SyncStat getCurrentStat() {
        return this.stat;
    }

    protected abstract void startSync(List<Range<Token>> var1);
}

