/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.UUIDSerializer;

final class EncodedHintMessage {
    private static final IVersionedSerializer<EncodedHintMessage> serializer = new Serializer();
    private final UUID hostId;
    private final ByteBuffer hint;
    private final int version;

    EncodedHintMessage(UUID hostId, ByteBuffer hint, int version) {
        this.hostId = hostId;
        this.hint = hint;
        this.version = version;
    }

    MessageOut<EncodedHintMessage> createMessageOut() {
        return new MessageOut<EncodedHintMessage>(MessagingService.Verb.HINT, this, serializer);
    }

    private static class Serializer
    implements IVersionedSerializer<EncodedHintMessage> {
        private Serializer() {
        }

        @Override
        public long serializedSize(EncodedHintMessage message, int version) {
            if (version != message.version) {
                throw new IllegalArgumentException("serializedSize() called with non-matching version " + version);
            }
            long size = UUIDSerializer.serializer.serializedSize(message.hostId, version);
            size += (long)TypeSizes.sizeofUnsignedVInt(message.hint.remaining());
            return size += (long)message.hint.remaining();
        }

        @Override
        public void serialize(EncodedHintMessage message, DataOutputPlus out, int version) throws IOException {
            if (version != message.version) {
                throw new IllegalArgumentException("serialize() called with non-matching version " + version);
            }
            UUIDSerializer.serializer.serialize(message.hostId, out, version);
            out.writeUnsignedVInt(message.hint.remaining());
            out.write(message.hint);
        }

        @Override
        public EncodedHintMessage deserialize(DataInputPlus in, int version) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

