/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.ExecutorLocals;
import org.apache.cassandra.concurrent.LocalAwareExecutorService;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggableThreadPoolExecutor
extends ThreadPoolExecutor
implements LocalAwareExecutorService {
    protected static final Logger logger = LoggerFactory.getLogger(DebuggableThreadPoolExecutor.class);
    public static final RejectedExecutionHandler blockingExecutionHandler = new RejectedExecutionHandler(){

        /*
         * Exception decompiling
         */
        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };

    public DebuggableThreadPoolExecutor(String threadPoolName, int priority) {
        this(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadPoolName, priority));
    }

    public DebuggableThreadPoolExecutor(int corePoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> queue, ThreadFactory factory) {
        this(corePoolSize, corePoolSize, keepAliveTime, unit, queue, factory);
    }

    public DebuggableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.allowCoreThreadTimeOut(true);
        this.setRejectedExecutionHandler(blockingExecutionHandler);
    }

    public static DebuggableThreadPoolExecutor createCachedThreadpoolWithMaxSize(String threadPoolName) {
        return new DebuggableThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory(threadPoolName));
    }

    public static DebuggableThreadPoolExecutor createWithFixedPoolSize(String threadPoolName, int size) {
        return DebuggableThreadPoolExecutor.createWithMaximumPoolSize(threadPoolName, size, Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    public static DebuggableThreadPoolExecutor createWithMaximumPoolSize(String threadPoolName, int size, int keepAliveTime, TimeUnit unit) {
        return new DebuggableThreadPoolExecutor(size, Integer.MAX_VALUE, (long)keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadPoolName));
    }

    protected void onInitialRejection(Runnable task) {
    }

    protected void onFinalAccept(Runnable task) {
    }

    protected void onFinalRejection(Runnable task) {
    }

    @Override
    public void execute(Runnable command, ExecutorLocals locals) {
        super.execute(locals == null || command instanceof LocalSessionWrapper ? command : new LocalSessionWrapper(command, locals));
    }

    @Override
    public void maybeExecuteImmediately(Runnable command) {
        this.execute(command);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(Tracing.isTracing() && !(command instanceof LocalSessionWrapper) ? new LocalSessionWrapper<Object>(Executors.callable(command, null)) : command);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T result) {
        if (Tracing.isTracing() && !(runnable instanceof LocalSessionWrapper)) {
            return new LocalSessionWrapper<T>(Executors.callable(runnable, result));
        }
        return super.newTaskFor(runnable, result);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (Tracing.isTracing() && !(callable instanceof LocalSessionWrapper)) {
            return new LocalSessionWrapper<T>(callable);
        }
        return super.newTaskFor(callable);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        DebuggableThreadPoolExecutor.maybeResetTraceSessionWrapper(r);
        DebuggableThreadPoolExecutor.logExceptionsAfterExecute(r, t);
    }

    protected static void maybeResetTraceSessionWrapper(Runnable r) {
        if (r instanceof LocalSessionWrapper) {
            LocalSessionWrapper tsw = (LocalSessionWrapper)r;
            tsw.reset();
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (r instanceof LocalSessionWrapper) {
            ((LocalSessionWrapper)r).setupContext();
        }
        super.beforeExecute(t, r);
    }

    public static void logExceptionsAfterExecute(Runnable r, Throwable t) {
        Throwable hiddenThrowable = DebuggableThreadPoolExecutor.extractThrowable(r);
        if (hiddenThrowable != null) {
            DebuggableThreadPoolExecutor.handleOrLog(hiddenThrowable);
        }
        if (t != null && Thread.getDefaultUncaughtExceptionHandler() == null) {
            DebuggableThreadPoolExecutor.handleOrLog(t);
        }
    }

    public static void handleOrLog(Throwable t) {
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            logger.error("Error in ThreadPoolExecutor", t);
        } else {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), t);
        }
    }

    public static Throwable extractThrowable(Runnable runnable) {
        if (runnable instanceof Future && ((Future)((Object)runnable)).isDone()) {
            try {
                ((Future)((Object)runnable)).get();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            catch (CancellationException e) {
                logger.trace("Task cancelled", (Throwable)e);
            }
            catch (ExecutionException e) {
                return e.getCause();
            }
        }
        return null;
    }

    private static class LocalSessionWrapper<T>
    extends FutureTask<T> {
        private final ExecutorLocals locals;

        public LocalSessionWrapper(Callable<T> callable) {
            super(callable);
            this.locals = ExecutorLocals.create();
        }

        public LocalSessionWrapper(Runnable command, ExecutorLocals locals) {
            super(command, null);
            this.locals = locals;
        }

        private void setupContext() {
            ExecutorLocals.set(this.locals);
        }

        private void reset() {
            ExecutorLocals.set(null);
        }
    }
}

