/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.CachedHashDecoratedKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.ComparableObjectToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;

public class LocalPartitioner
implements IPartitioner {
    private static final long EMPTY_SIZE;
    final AbstractType<?> comparator;

    public LocalPartitioner(AbstractType<?> comparator) {
        this.comparator = comparator;
    }

    @Override
    public DecoratedKey decorateKey(ByteBuffer key) {
        return new CachedHashDecoratedKey(this.getToken(key), key);
    }

    @Override
    public Token midpoint(Token left, Token right) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalToken getMinimumToken() {
        return new LocalToken(ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    @Override
    public LocalToken getToken(ByteBuffer key) {
        return new LocalToken(key);
    }

    @Override
    public LocalToken getRandomToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Token.TokenFactory getTokenFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        return Collections.singletonMap(this.getMinimumToken(), new Float(1.0));
    }

    @Override
    public AbstractType<?> getTokenValidator() {
        return this.comparator;
    }

    static {
        LocalPartitioner localPartitioner = new LocalPartitioner(null);
        localPartitioner.getClass();
        EMPTY_SIZE = ObjectSizes.measure(localPartitioner.new LocalToken(null));
    }

    public class LocalToken
    extends ComparableObjectToken<ByteBuffer> {
        static final long serialVersionUID = 8437543776403014875L;

        public LocalToken(ByteBuffer token) {
            super(token);
        }

        @Override
        public String toString() {
            return LocalPartitioner.this.comparator.getString((ByteBuffer)this.token);
        }

        @Override
        public int compareTo(Token o) {
            assert (this.getPartitioner() == o.getPartitioner());
            return LocalPartitioner.this.comparator.compare(this.token, ((LocalToken)o).token);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            return 31 + ((ByteBuffer)this.token).hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LocalToken)) {
                return false;
            }
            LocalToken other = (LocalToken)obj;
            return ((ByteBuffer)this.token).equals(other.token);
        }

        @Override
        public IPartitioner getPartitioner() {
            return LocalPartitioner.this;
        }

        @Override
        public long getHeapSize() {
            return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf((ByteBuffer)this.token);
        }
    }
}

