/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.JarPathname;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.URLPathname;
import org.armedbear.lisp.util.HttpHead;

public class ZipCache {
    static HashMap<JarPathname, Archive> cache = new HashMap();
    static boolean cacheEnabled = true;
    private static final Primitive DISABLE_ZIP_CACHE = new disable_zip_cache();
    private static final Primitive CLEAR_ZIP_CACHE = new clear_zip_cache();
    private static final Primitive REMOVE_ZIP_CACHE_ENTRY = new remove_zip_cache_entry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean checkZipFile(Pathname name) {
        boolean bl;
        InputStream input = name.getInputStream();
        try {
            byte[] bytes = new byte[4];
            int bytesRead = input.read(bytes);
            bl = bytesRead == 4 && bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 3 && bytes[3] == 4;
            if (input == null) return bl;
        }
        catch (Throwable t) {
            try {
                boolean bl3 = false;
                return bl3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            input.close();
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    static InputStream getInputStream(ZipFile jarFile, String entryPath) {
        ZipEntry entry = jarFile.getEntry(entryPath);
        if (entry == null) {
            Debug.trace("Failed to find entry '" + entryPath + "' in '" + jarFile.getName() + "'");
            return null;
        }
        InputStream result = null;
        try {
            result = jarFile.getInputStream(entry);
        }
        catch (IOException e) {
            Debug.trace("Failed to open InputStream for '" + entryPath + "' in '" + jarFile.getName() + "'");
            return null;
        }
        return result;
    }

    public static ZipInputStream getZipInputStream(ZipFile zipfile, String entryName) {
        return ZipCache.getZipInputStream(zipfile, entryName, false);
    }

    public static ZipInputStream getZipInputStream(ZipFile zipfile, String entryName, boolean errorOnFailure) {
        ZipEntry zipEntry = zipfile.getEntry(entryName);
        ZipInputStream stream = null;
        try {
            stream = new ZipInputStream(zipfile.getInputStream(zipEntry));
        }
        catch (IOException e) {
            if (errorOnFailure) {
                Lisp.simple_error("Failed to open '" + entryName + "' in zipfile '" + zipfile + "': " + e.getMessage(), new Object[0]);
            }
            return null;
        }
        return stream;
    }

    public static ByteArrayOutputStream readEntry(ZipInputStream stream) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int count;
            while ((count = stream.read(buf, 0, buf.length)) != -1) {
                result.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            Debug.trace("Failed to read entry from " + stream + ": " + e);
            return null;
        }
        return result;
    }

    public static ZipEntry getEntry(ZipInputStream zipInputStream, String entryName) {
        return ZipCache.getEntry(zipInputStream, entryName, false);
    }

    public static ZipEntry getEntry(ZipInputStream zipInputStream, String entryName, boolean errorOnFailure) {
        ZipEntry entry = null;
        do {
            try {
                entry = zipInputStream.getNextEntry();
            }
            catch (IOException e) {
                if (errorOnFailure) {
                    Lisp.error(new FileError("Failed to seek for '" + entryName + "' in " + zipInputStream.toString()));
                }
                return null;
            }
        } while (entry != null && !entry.getName().equals(entryName));
        if (entry != null) {
            return entry;
        }
        if (errorOnFailure) {
            Lisp.error(new FileError("Failed to find '" + entryName + "' in " + zipInputStream.toString()));
        }
        return null;
    }

    public static InputStream getEntryAsInputStream(ZipInputStream zipInputStream, String entryName) {
        ZipEntry entry = ZipCache.getEntry(zipInputStream, entryName);
        ByteArrayOutputStream bytes = ZipCache.readEntry(zipInputStream);
        return new ByteArrayInputStream(bytes.toByteArray());
    }

    public static InputStream getEntryAsInputStream(JarPathname archiveEntry) {
        JarPathname archiveJar = archiveEntry.getArchive();
        Archive archive = ZipCache.getArchive(archiveJar);
        InputStream result = archive.getEntryAsInputStream(archiveEntry);
        if (result == null) {
            Lisp.simple_error("Failed to get InputStream for ~a", archiveEntry);
        }
        return result;
    }

    public static synchronized void disable() {
        cacheEnabled = false;
        cache.clear();
    }

    public static synchronized LinkedHashMap<JarPathname, ZipEntry> getEntries(JarPathname jar) {
        Archive archive = ZipCache.getArchive(jar);
        archive.populateAllEntries();
        return archive.entries;
    }

    public static synchronized Iterator<Map.Entry<JarPathname, ZipEntry>> getEntriesIterator(JarPathname jar) {
        LinkedHashMap<JarPathname, ZipEntry> entries = ZipCache.getEntries(jar);
        Set<Map.Entry<JarPathname, ZipEntry>> set = entries.entrySet();
        return set.iterator();
    }

    static ZipEntry getZipEntry(JarPathname archiveEntry) {
        JarPathname archiveJar = archiveEntry.getArchive();
        Archive zip2 = ZipCache.getArchive(archiveJar);
        ZipEntry entry = zip2.getEntry(archiveEntry);
        return entry;
    }

    public static synchronized Archive getArchive(JarPathname jar) {
        jar.setVersion(Keyword.NEWEST);
        Archive result = cache.get(jar);
        if (result != null) {
            long time = result.getLastModified();
            if (time != result.lastModified) {
                cache.remove(jar);
                return ZipCache.getArchive(jar);
            }
            return result;
        }
        Pathname rootJar = (Pathname)jar.getRootJar();
        LispObject innerJars = jar.getJars().cdr();
        if (!rootJar.isLocalFile()) {
            return ZipCache.getArchiveURL(jar);
        }
        if (innerJars.equals(Lisp.NIL)) {
            return ZipCache.getArchiveFile(jar);
        }
        result = ZipCache.getArchiveStreamFromFile(jar);
        cache.put(result.root, result);
        JarPathname nextArchive = new JarPathname();
        nextArchive.setDevice(new Cons(rootJar, (LispObject)new Cons(innerJars.car(), (LispObject)Lisp.NIL))).setDirectory(Lisp.NIL).setName(Lisp.NIL).setType(Lisp.NIL).setVersion(Keyword.NEWEST);
        innerJars = innerJars.cdr();
        while (innerJars.car() != Lisp.NIL) {
            Pathname nextJarArchive = (Pathname)innerJars.car();
            JarPathname nextAsEntry = new JarPathname();
            nextAsEntry.setDevice(nextArchive.getDevice()).setDirectory(nextJarArchive.getDirectory()).setName(nextJarArchive.getName()).setType(nextJarArchive.getType()).setVersion(Keyword.NEWEST);
            LispObject directories = nextAsEntry.getDirectory();
            if (!directories.equals(Lisp.NIL) && directories.car().equals(Keyword.RELATIVE)) {
                directories = directories.cdr().push(Keyword.ABSOLUTE);
                nextAsEntry.setDirectory(directories);
            }
            nextArchive.setDevice(nextArchive.getDevice().reverse().push(nextJarArchive).reverse());
            ArchiveStream stream = (ArchiveStream)result;
            ZipEntry entry = stream.getEntry(nextAsEntry);
            if (entry == null) {
                return null;
            }
            InputStream inputStream = stream.getEntryAsInputStream(nextAsEntry);
            if (inputStream == null) {
                return null;
            }
            stream = new ArchiveStream(inputStream, nextArchive, entry);
            result = stream;
            cache.put(nextArchive, result);
            if (!(innerJars = innerJars.cdr()).cdr().equals(Lisp.NIL) || jar.getDirectory().equals(Lisp.NIL) || !jar.getName().equals(Lisp.NIL) || !jar.getType().equals(Lisp.NIL)) continue;
            Lisp.simple_error("Currently unimplemented retrieval of an entry in a nested pathnames", new Object[0]);
            return (Archive)Lisp.UNREACHED;
        }
        return result;
    }

    static ArchiveStream getArchiveStreamFromFile(JarPathname p) {
        JarPathname innerArchiveAsEntry = JarPathname.archiveAsEntry(p);
        JarPathname root = new JarPathname();
        root = (JarPathname)root.copyFrom(innerArchiveAsEntry);
        root.setDirectory(Lisp.NIL).setName(Lisp.NIL).setType(Lisp.NIL).setVersion(Keyword.NEWEST);
        ArchiveFile rootArchiveFile = (ArchiveFile)ZipCache.getArchiveFile(root);
        ZipEntry entry = rootArchiveFile.getEntry(innerArchiveAsEntry);
        if (entry == null) {
            return null;
        }
        InputStream inputStream = rootArchiveFile.getEntryAsInputStream(innerArchiveAsEntry);
        if (inputStream == null) {
            return null;
        }
        ArchiveStream result = new ArchiveStream(inputStream, p, entry);
        return result;
    }

    public static Archive getArchiveURL(JarPathname jar) {
        Pathname rootJar = (Pathname)jar.getRootJar();
        jar.setVersion(Keyword.NEWEST);
        Object rootJarURL = null;
        try {
            ArchiveURL result = new ArchiveURL(jar);
            cache.put(jar, result);
            return result;
        }
        catch (MalformedURLException e) {
            Lisp.simple_error("Failed to form root URL for ~a", jar);
            return (Archive)Lisp.UNREACHED;
        }
        catch (IOException e) {
            Lisp.simple_error("Failed to fetch ~a: ~a", jar, e);
            return (Archive)Lisp.UNREACHED;
        }
    }

    public static Archive getArchiveFile(JarPathname jar) {
        jar.setVersion(Keyword.NEWEST);
        try {
            ArchiveFile result = new ArchiveFile(jar);
            cache.put(jar, result);
            return result;
        }
        catch (ZipException e) {
            Lisp.error(new FileError("Failed to open local zip archive because " + e, jar));
            return (Archive)Lisp.UNREACHED;
        }
        catch (IOException e) {
            Lisp.error(new FileError("Failed to open local zip archive because " + e, jar));
            return (Archive)Lisp.UNREACHED;
        }
    }

    static void checkRemoteLastModified(ArchiveURL archive) {
        String dateString = null;
        String url = archive.root.getRootJarAsURLString();
        try {
            dateString = HttpHead.get(url, "Last-Modified");
        }
        catch (IOException ex) {
            Debug.trace(ex);
        }
        Date date = null;
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat ASCTIME = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
        SimpleDateFormat RFC_1036 = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
        SimpleDateFormat RFC_1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        if (dateString != null && (date = RFC_1123.parse(dateString, pos)) == null && (date = RFC_1036.parse(dateString, pos)) == null) {
            date = ASCTIME.parse(dateString, pos);
        }
        if (date == null || date.getTime() > archive.lastModified) {
            JarPathname root = archive.root;
            Archive entry = ZipCache.getArchiveURL(root);
            cache.put(root, entry);
        }
        if (date == null) {
            if (dateString == null) {
                Debug.trace("Failed to retrieve request header: " + url.toString());
            } else {
                Debug.trace("Failed to parse Last-Modified date: " + dateString);
            }
        }
    }

    public static synchronized boolean remove(Pathname pathname) {
        JarPathname p = JarPathname.createFromPathname(pathname);
        return ZipCache.remove(p);
    }

    public static synchronized boolean remove(JarPathname p) {
        p.setVersion(Keyword.NEWEST);
        Archive archive = cache.get(p);
        if (archive != null) {
            archive.close();
            cache.remove(p);
            return true;
        }
        return false;
    }

    public static abstract class Archive {
        JarPathname root;
        LinkedHashMap<JarPathname, ZipEntry> entries = new LinkedHashMap();
        long lastModified;

        abstract InputStream getEntryAsInputStream(JarPathname var1);

        abstract ZipEntry getEntry(JarPathname var1);

        abstract void populateAllEntries();

        abstract void close();

        abstract long getLastModified();
    }

    public static class ArchiveStream
    extends Archive {
        ZipInputStream source;
        ZipEntry rootEntry;
        LinkedHashMap<JarPathname, ByteArrayOutputStream> contents = new LinkedHashMap();
        boolean populated = false;

        public ArchiveStream(InputStream stream, JarPathname root, ZipEntry rootEntry) {
            this.source = !(stream instanceof ZipInputStream) ? new ZipInputStream(stream) : (ZipInputStream)stream;
            this.root = root;
            this.rootEntry = rootEntry;
            this.lastModified = rootEntry.getTime();
        }

        @Override
        public InputStream getEntryAsInputStream(JarPathname entry) {
            if (!this.populated) {
                this.populateAllEntries();
            }
            entry.setVersion(Keyword.NEWEST);
            ByteArrayOutputStream bytes = this.contents.get(entry);
            if (bytes != null) {
                return new ByteArrayInputStream(bytes.toByteArray());
            }
            return null;
        }

        @Override
        public ZipEntry getEntry(JarPathname entry) {
            if (!this.populated) {
                this.populateAllEntries();
            }
            entry.setVersion(Keyword.NEWEST);
            ZipEntry result = (ZipEntry)this.entries.get(entry);
            return result;
        }

        @Override
        void populateAllEntries() {
            if (this.populated) {
                return;
            }
            try {
                ZipEntry entry;
                while ((entry = this.source.getNextEntry()) != null) {
                    String name = entry.getName();
                    JarPathname entryPathname = JarPathname.createEntryFromJar(this.root, name);
                    this.entries.put(entryPathname, entry);
                    ByteArrayOutputStream bytes = ZipCache.readEntry(this.source);
                    this.contents.put(entryPathname, bytes);
                }
                this.populated = true;
            }
            catch (IOException e) {
                Lisp.simple_error("Failed to read entries from zip archive", this.root);
            }
        }

        @Override
        void close() {
            if (this.source != null) {
                try {
                    this.source.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        long getLastModified() {
            return ((URLPathname)this.root.getRootJar()).getLastModified();
        }
    }

    public static class ArchiveFile
    extends Archive {
        ZipFile file;

        ZipFile get() {
            return this.file;
        }

        ArchiveFile() {
        }

        public ArchiveFile(JarPathname jar) throws ZipException, IOException {
            File f = ((Pathname)jar.getRootJar()).getFile();
            this.root = jar;
            this.file = new ZipFile(f);
            this.lastModified = f.lastModified();
        }

        @Override
        long getLastModified() {
            long result = 0L;
            File f = ((Pathname)this.root.getRootJar()).getFile();
            if (f != null) {
                result = f.lastModified();
            }
            return result;
        }

        @Override
        public ZipEntry getEntry(JarPathname entryPathname) {
            entryPathname.setVersion(Keyword.NEWEST);
            ZipEntry result = (ZipEntry)this.entries.get(entryPathname);
            if (result != null) {
                return result;
            }
            String entryPath = entryPathname.asEntryPath();
            result = this.file.getEntry(entryPath);
            if (result == null) {
                return null;
            }
            if (!(!result.isDirectory() || entryPathname.getName().equals(Lisp.NIL) && entryPathname.getType().equals(Lisp.NIL))) {
                return null;
            }
            this.entries.put(entryPathname, result);
            return result;
        }

        @Override
        void populateAllEntries() {
            ZipFile f = this.file;
            if (f.size() == this.entries.size()) {
                return;
            }
            Enumeration<? extends ZipEntry> e = f.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String name = entry.getName();
                JarPathname entryPathname = JarPathname.createEntryFromJar(this.root, name);
                this.entries.put(entryPathname, entry);
            }
        }

        @Override
        InputStream getEntryAsInputStream(JarPathname entry) {
            InputStream result = null;
            entry.setVersion(Keyword.NEWEST);
            ZipEntry zipEntry = this.getEntry(entry);
            try {
                result = this.file.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }

        @Override
        void close() {
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static class ArchiveURL
    extends ArchiveFile {
        JarURLConnection connection;

        public ArchiveURL(JarPathname jar) throws IOException {
            String rootJarURLString = jar.getRootJarAsURLString();
            URL rootJarURL = new URL(rootJarURLString);
            JarURLConnection jarConnection = (JarURLConnection)rootJarURL.openConnection();
            this.root = jar;
            this.connection = jarConnection;
            this.file = this.connection.getJarFile();
            this.lastModified = this.connection.getLastModified();
        }

        @Override
        void close() {
            super.close();
        }
    }

    static final class disable_zip_cache
    extends Primitive {
        disable_zip_cache() {
            super("disable-zip-cache", Lisp.PACKAGE_SYS, true, "", "Not currently implemented");
        }

        @Override
        public LispObject execute() {
            return Lisp.NIL;
        }
    }

    private static class clear_zip_cache
    extends Primitive {
        clear_zip_cache() {
            super("clear-zip-cache", Lisp.PACKAGE_SYS, true);
        }

        @Override
        public LispObject execute() {
            int size = cache.size();
            cache.clear();
            return size == 0 ? Lisp.NIL : Lisp.T;
        }
    }

    private static class remove_zip_cache_entry
    extends Primitive {
        remove_zip_cache_entry() {
            super("remove-zip-cache-entry", Lisp.PACKAGE_SYS, true, "pathname");
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname p = Lisp.coerceToPathname(arg);
            boolean result = false;
            if (p instanceof JarPathname) {
                result = ZipCache.remove((JarPathname)p);
            }
            return result ? Lisp.T : Lisp.NIL;
        }
    }
}

