% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restore.R
\name{restore}
\alias{restore}
\title{Restore project library from a lockfile}
\usage{
restore(
  project = NULL,
  ...,
  library = NULL,
  lockfile = NULL,
  packages = NULL,
  exclude = NULL,
  rebuild = FALSE,
  repos = NULL,
  clean = FALSE,
  transactional = NULL,
  prompt = interactive()
)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{library}{The library paths to be used during restore.}

\item{lockfile}{Path to a lockfile. When \code{NULL} (the default), the
\code{renv.lock} located in the root of the current project will be used.}

\item{packages}{A subset of packages recorded in the lockfile to restore.
When \code{NULL} (the default), all packages available in the lockfile will be
restored. Any required recursive dependencies of the requested packages
will be restored as well.}

\item{exclude}{A subset of packages to be excluded during restore. This can
be useful for when you'd like to restore all but a subset of packages from
a lockfile. Note that if you attempt to exclude a package which is required
as the recursive dependency of another package, your request will be
ignored.}

\item{rebuild}{Force packages to be rebuilt, thereby bypassing any installed
versions of the package available in the cache? This can either be a
boolean (indicating that all installed packages should be rebuilt), or a
vector of package names indicating which packages should be rebuilt.}

\item{repos}{The repositories to use when restoring packages installed
from CRAN or a CRAN-like repository. By default, the repositories recorded
in the lockfile will be used, ensuring that (e.g.) CRAN packages are
re-installed from the same CRAN mirror.

Use \code{repos = getOption("repos")} to override with the repositories set
in the current session, or see the \code{repos.override} option in \link{config} for
an alternate way override.}

\item{clean}{Boolean; remove packages not recorded in the lockfile from
the target library? Use \code{clean = TRUE} if you'd like the library state
to exactly reflect the lockfile contents after \code{restore()}.}

\item{transactional}{Whether or not to use a 'transactional' restore.
See \strong{Transactional Restore} for more details. When \code{NULL} (the default),
the value of the \code{install.transactional} \code{\link{config}} option will be used.}

\item{prompt}{Boolean; prompt the user before taking any action? For backwards
compatibility, \code{confirm} is accepted as an alias for \code{prompt}.}
}
\value{
A named list of package records which were installed by renv.
}
\description{
Restore a project's dependencies from a lockfile, as previously generated by
\code{\link[=snapshot]{snapshot()}}.
}
\details{
\code{renv::restore()} compares packages recorded in the lockfile to
the packages installed in the project library. Where there are differences
it resolves them by installing the lockfile-recorded package into the
project library. If \code{clean = TRUE}, \code{restore()} will additionally delete any
packages in the project library that don't appear in the lockfile.
}
\section{Transactional Restore}{


By default, \code{renv::restore()} will perform a 'transactional' restore, wherein the
project library is mutated only if all packages within the lockfile are successfully
restored. The intention here is to prevent the private library from entering
an inconsistent state, if some subset of packages were to install successfully
but some other subset of packages did not. \code{renv::restore(transactional = FALSE)}
can be useful if you're attempting to restore packages from a lockfile, but would
like to update or change certain packages piece-meal if they fail to install.

The term 'transactional' here borrows from the parlance of a 'database transaction',
where the failure of any intermediate step implies that the whole transaction
will be rolled back, so that the state of the database before the transaction
was initiated can be preserved. See \url{https://en.wikipedia.org/wiki/Database_transaction}
for more details.
}

\examples{

\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
\seealso{
Other reproducibility: 
\code{\link{lockfiles}},
\code{\link{snapshot}()}
}
\concept{reproducibility}
