/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.sql.SqlCommand;
import org.jetbrains.dekaf.sql.SqlScript;
import org.jetbrains.dekaf.sql.SqlStatement;
import org.jetbrains.dekaf.sql.TextPointer;
import org.jetbrains.dekaf.sql.TextWalker;
import org.jetbrains.dekaf.util.Strings;

public class SqlScriptBuilder {
    private final ArrayList<SqlStatement> myStatements = new ArrayList();
    private static final Pattern SQL_END_MARKER = Pattern.compile("(;|\\n\\s*/)(\\s|\\n|--[^\\n]*?\\n|/\\*.*?\\*/)*?(\\n|$)|$", 32);
    private static final Pattern PL_ESSENTIAL_WORDS_PATTERN = Pattern.compile("^(declare|begin|(create (or replace )?(type|package|procedure|function|trigger))).*");

    public void add(String ... commands) {
        for (String command : commands) {
            SqlCommand cmd = new SqlCommand(command);
            this.myStatements.add(cmd);
        }
    }

    public void add(SqlCommand ... commands) {
        Collections.addAll(this.myStatements, commands);
    }

    public void add(SqlScript ... scripts) {
        for (SqlScript script : scripts) {
            if (!script.hasStatements()) continue;
            for (SqlStatement sqlStatement : script.getStatements()) {
                this.myStatements.add(sqlStatement);
            }
        }
    }

    public void parse(@NotNull String text) {
        TextWalker walker = new TextWalker(text);
        while (!walker.isEOT()) {
            this.skipEmptySpace(walker);
            if (walker.isEOT()) break;
            String essentialWords = SqlScriptBuilder.extractEssentialWords(walker, 6);
            boolean pl = this.determinePL(essentialWords);
            if (pl) {
                this.extractPLBlock(walker);
                continue;
            }
            this.extractSQLCommand(walker);
        }
    }

    static String extractEssentialWords(@NotNull TextWalker walker, int limitWords) {
        TextWalker w = walker.clone();
        StringBuilder b = new StringBuilder(40);
        int wordsCnt = 0;
        boolean inWord = false;
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        while (!w.isEOT()) {
            char c = w.getChar();
            char c2 = w.getNextChar();
            boolean isWordChar = Character.isJavaIdentifierPart(c);
            if (inSingleLineComment) {
                if (c == '\n') {
                    inSingleLineComment = false;
                }
            } else if (inMultiLineComment) {
                if (c == '*' && c2 == '/') {
                    w.next();
                    inMultiLineComment = false;
                }
            } else if (inWord && !isWordChar) {
                if (++wordsCnt >= limitWords) break;
                b.append(' ');
                inWord = false;
            } else if (isWordChar) {
                b.append(Character.toLowerCase(c));
                inWord = true;
            } else if (!isWordChar) {
                if (c == '-' && c2 == '-') {
                    inSingleLineComment = true;
                    w.next();
                }
                if (c == '/' && c2 == '*') {
                    inMultiLineComment = true;
                    w.next();
                }
            }
            w.next();
        }
        return b.toString().trim();
    }

    private void extractPLBlock(@NotNull TextWalker walker) {
        int position;
        String row;
        TextPointer begin = walker.getPointer();
        do {
            position = walker.getOffset();
        } while (!walker.isEOT() && !(row = walker.popRow().trim()).equals("/"));
        String plText = Strings.rtrim(walker.getText().substring(begin.offset, position));
        SqlCommand command = new SqlCommand(plText, begin.row, null);
        this.myStatements.add(command);
    }

    private void extractSQLCommand(@NotNull TextWalker walker) {
        this.skipEmptySpace(walker);
        TextPointer begin = walker.getPointer();
        Matcher matcher = walker.skipToPattern(SQL_END_MARKER);
        String sqlText = Strings.rtrim(walker.getText().substring(begin.offset, walker.getOffset()));
        SqlCommand command = new SqlCommand(sqlText, begin.row, null);
        this.myStatements.add(command);
        if (matcher != null) {
            walker.skipToOffset(matcher.end());
        }
    }

    boolean determinePL(@NotNull String essentialWords) {
        return PL_ESSENTIAL_WORDS_PATTERN.matcher(essentialWords).matches();
    }

    protected void skipEmptySpace(@NotNull TextWalker walker) {
        block0: while (!walker.isEOT()) {
            char c1 = walker.getChar();
            if (Character.isWhitespace(c1)) {
                walker.next();
                continue;
            }
            char c2 = walker.getNextChar();
            if (c1 == '-' && c2 == '-') {
                while (!walker.isEOT()) {
                    walker.next();
                    if (walker.getChar() != '\n') continue;
                    walker.next();
                    break;
                }
            }
            if (c1 != '/' || c2 != '*') break;
            walker.next();
            walker.next();
            while (!walker.isEOT()) {
                if (walker.getChar() == '*' && walker.getNextChar() == '/') {
                    walker.next();
                    walker.next();
                    break block0;
                }
                walker.next();
            }
            break block0;
        }
    }

    @NotNull
    public SqlScript build() {
        return new SqlScript(this.myStatements);
    }
}

