/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.UINumericRange;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

@State(name="GeneralSettings", storages={@Storage(value="ide.general.xml")}, reportStatistic=true)
public class GeneralSettings
implements PersistentStateComponent<GeneralSettings> {
    public static final int OPEN_PROJECT_ASK = -1;
    public static final int OPEN_PROJECT_NEW_WINDOW = 0;
    public static final int OPEN_PROJECT_SAME_WINDOW = 1;
    public static final int OPEN_PROJECT_SAME_WINDOW_ATTACH = 2;
    public static final String PROP_INACTIVE_TIMEOUT = "inactiveTimeout";
    public static final String PROP_SUPPORT_SCREEN_READERS = "supportScreenReaders";
    public static final String SUPPORT_SCREEN_READERS = "ide.support.screenreaders.enabled";
    private static final Boolean SUPPORT_SCREEN_READERS_OVERRIDDEN = GeneralSettings.getSupportScreenReadersOverridden();
    static final UINumericRange SAVE_FILES_AFTER_IDLE_SEC = new UINumericRange(15, 1, 300);
    private String myBrowserPath = BrowserUtil.getDefaultAlternativeBrowserPath();
    private boolean myShowTipsOnStartup = true;
    private boolean myReopenLastProject = true;
    private boolean mySupportScreenReaders = (Boolean)ObjectUtils.chooseNotNull((Object)SUPPORT_SCREEN_READERS_OVERRIDDEN, (Object)Boolean.FALSE);
    private boolean mySyncOnFrameActivation = true;
    private boolean mySaveOnFrameDeactivation = true;
    private boolean myAutoSaveIfInactive = false;
    private int myInactiveTimeout = 15;
    private boolean myUseSafeWrite = true;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private boolean myUseDefaultBrowser = true;
    private boolean mySearchInBackground;
    private boolean myConfirmExit = true;
    private boolean myShowWelcomeScreen = !PlatformUtils.isDataGrip();
    private int myConfirmOpenNewProject = -1;
    private ProcessCloseConfirmation myProcessCloseConfirmation = ProcessCloseConfirmation.ASK;
    private String myDefaultProjectDirectory = "";

    public static GeneralSettings getInstance() {
        return ServiceManager.getService(GeneralSettings.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String getBrowserPath() {
        return this.myBrowserPath;
    }

    public void setBrowserPath(String browserPath) {
        this.myBrowserPath = browserPath;
    }

    public boolean isShowTipsOnStartup() {
        return this.myShowTipsOnStartup;
    }

    public void setShowTipsOnStartup(boolean b) {
        this.myShowTipsOnStartup = b;
    }

    @Transient
    public int getLastTip() {
        return StringUtil.parseInt((String)PropertiesComponent.getInstance().getValue("lastTip"), (int)0);
    }

    public void setLastTip(int i) {
        PropertiesComponent.getInstance().setValue("lastTip", Integer.toString(i), "0");
    }

    public boolean isReopenLastProject() {
        return this.myReopenLastProject;
    }

    public void setReopenLastProject(boolean reopenLastProject) {
        this.myReopenLastProject = reopenLastProject;
    }

    @Nullable
    private static Boolean getSupportScreenReadersOverridden() {
        String prop = System.getProperty(SUPPORT_SCREEN_READERS);
        if (prop != null) {
            return Boolean.parseBoolean(prop);
        }
        return null;
    }

    public static boolean isSupportScreenReadersOverridden() {
        return SUPPORT_SCREEN_READERS_OVERRIDDEN != null;
    }

    public boolean isSupportScreenReaders() {
        return this.mySupportScreenReaders;
    }

    public void setSupportScreenReaders(boolean enabled) {
        boolean oldValue = this.mySupportScreenReaders;
        this.mySupportScreenReaders = enabled;
        this.myPropertyChangeSupport.firePropertyChange(PROP_SUPPORT_SCREEN_READERS, (Object)oldValue, (Object)enabled);
    }

    public ProcessCloseConfirmation getProcessCloseConfirmation() {
        return this.myProcessCloseConfirmation;
    }

    public void setProcessCloseConfirmation(ProcessCloseConfirmation processCloseConfirmation) {
        this.myProcessCloseConfirmation = processCloseConfirmation;
    }

    @OptionTag(value="autoSyncFiles")
    public boolean isSyncOnFrameActivation() {
        return this.mySyncOnFrameActivation;
    }

    public void setSyncOnFrameActivation(boolean syncOnFrameActivation) {
        this.mySyncOnFrameActivation = syncOnFrameActivation;
    }

    @OptionTag(value="autoSaveFiles")
    public boolean isSaveOnFrameDeactivation() {
        return this.mySaveOnFrameDeactivation;
    }

    public void setSaveOnFrameDeactivation(boolean saveOnFrameDeactivation) {
        this.mySaveOnFrameDeactivation = saveOnFrameDeactivation;
    }

    public boolean isAutoSaveIfInactive() {
        return this.myAutoSaveIfInactive;
    }

    public void setAutoSaveIfInactive(boolean autoSaveIfInactive) {
        this.myAutoSaveIfInactive = autoSaveIfInactive;
    }

    public int getInactiveTimeout() {
        return SAVE_FILES_AFTER_IDLE_SEC.fit(this.myInactiveTimeout);
    }

    public void setInactiveTimeout(int inactiveTimeoutSeconds) {
        int oldInactiveTimeout = this.myInactiveTimeout;
        this.myInactiveTimeout = SAVE_FILES_AFTER_IDLE_SEC.fit(inactiveTimeoutSeconds);
        this.myPropertyChangeSupport.firePropertyChange(PROP_INACTIVE_TIMEOUT, (Object)oldInactiveTimeout, (Object)this.myInactiveTimeout);
    }

    public boolean isUseSafeWrite() {
        return this.myUseSafeWrite;
    }

    public void setUseSafeWrite(boolean useSafeWrite) {
        this.myUseSafeWrite = useSafeWrite;
    }

    @Override
    @Nullable
    public GeneralSettings getState() {
        return this;
    }

    @Override
    public void loadState(@NotNull GeneralSettings state) {
        if (state == null) {
            GeneralSettings.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public boolean isUseDefaultBrowser() {
        return this.myUseDefaultBrowser;
    }

    public void setUseDefaultBrowser(boolean value) {
        this.myUseDefaultBrowser = value;
    }

    @Transient
    @Deprecated
    public boolean isConfirmExtractFiles() {
        return true;
    }

    @Deprecated
    public void setConfirmExtractFiles(boolean value) {
    }

    public boolean isConfirmExit() {
        return this.myConfirmExit;
    }

    public void setConfirmExit(boolean confirmExit) {
        this.myConfirmExit = confirmExit;
    }

    public boolean isShowWelcomeScreen() {
        return this.myShowWelcomeScreen;
    }

    public void setShowWelcomeScreen(boolean show) {
        this.myShowWelcomeScreen = show;
    }

    @OptionTag(value="confirmOpenNewProject2")
    @OpenNewProjectOption
    public int getConfirmOpenNewProject() {
        return this.myConfirmOpenNewProject;
    }

    public void setConfirmOpenNewProject(@OpenNewProjectOption int confirmOpenNewProject) {
        this.myConfirmOpenNewProject = confirmOpenNewProject;
    }

    public boolean isSearchInBackground() {
        return this.mySearchInBackground;
    }

    public void setSearchInBackground(boolean searchInBackground) {
        this.mySearchInBackground = searchInBackground;
    }

    public @SystemDependent String getDefaultProjectDirectory() {
        return this.myDefaultProjectDirectory;
    }

    public void setDefaultProjectDirectory(@SystemDependent String defaultProjectDirectory) {
        this.myDefaultProjectDirectory = defaultProjectDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/GeneralSettings", "loadState"));
    }

    static @interface OpenNewProjectOption {
    }

    public static enum ProcessCloseConfirmation {
        ASK,
        TERMINATE,
        DISCONNECT;

    }
}

