/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import org.jetbrains.annotations.NotNull;

public class LineCol {
    public final int line;
    public final int column;

    public LineCol(int line) {
        this(line, 0);
    }

    public LineCol(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineCol col = (LineCol)o;
        if (this.line != col.line) {
            return false;
        }
        return this.column == col.column;
    }

    public int hashCode() {
        int result2 = this.line;
        result2 = 31 * result2 + this.column;
        return result2;
    }

    public String toString() {
        return String.format("{ line: %s, column: %s }", this.line, this.column);
    }

    @NotNull
    public static LineCol fromOffset(@NotNull Document document, int offset) {
        if (document == null) {
            LineCol.$$$reportNull$$$0(0);
        }
        if (offset < document.getTextLength()) {
            int line = document.getLineNumber(offset);
            int column = offset - document.getLineStartOffset(line);
            LineCol lineCol = new LineCol(line, column);
            if (lineCol == null) {
                LineCol.$$$reportNull$$$0(1);
            }
            return lineCol;
        }
        int line = Math.max(0, document.getLineCount() - 1);
        int column = document.getLineEndOffset(line) - document.getLineStartOffset(line);
        LineCol lineCol = new LineCol(line, column);
        if (lineCol == null) {
            LineCol.$$$reportNull$$$0(2);
        }
        return lineCol;
    }

    @NotNull
    public static LineCol fromCaret(@NotNull Editor editor) {
        if (editor == null) {
            LineCol.$$$reportNull$$$0(3);
        }
        LineCol lineCol = LineCol.fromOffset(editor.getDocument(), editor.getCaretModel().getOffset());
        if (lineCol == null) {
            LineCol.$$$reportNull$$$0(4);
        }
        return lineCol;
    }

    public static int toOffset(@NotNull Document document, @NotNull LineCol linecol) {
        if (document == null) {
            LineCol.$$$reportNull$$$0(5);
        }
        if (linecol == null) {
            LineCol.$$$reportNull$$$0(6);
        }
        return linecol.toOffset(document);
    }

    public static int toOffset(@NotNull Document document, int line, int col) {
        if (document == null) {
            LineCol.$$$reportNull$$$0(7);
        }
        return new LineCol(line, col).toOffset(document);
    }

    public int toOffset(@NotNull Document document) {
        if (document == null) {
            LineCol.$$$reportNull$$$0(8);
        }
        if (this.line >= document.getLineCount()) {
            return document.getTextLength();
        }
        return Math.min(document.getLineStartOffset(this.line) + this.column, document.getLineEndOffset(this.line));
    }

    public int toOffset(@NotNull Editor editor) {
        if (editor == null) {
            LineCol.$$$reportNull$$$0(9);
        }
        return this.toOffset(editor.getDocument());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/LineCol";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linecol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/LineCol";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromCaret";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromOffset";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromCaret";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

