/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class XDebuggerActionBase
extends AnAction
implements AnAction.TransparentUpdate {
    private final boolean myHideDisabledInPopup;

    protected XDebuggerActionBase() {
        this(false);
    }

    protected XDebuggerActionBase(boolean hideDisabledInPopup) {
        this.myHideDisabledInPopup = hideDisabledInPopup;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            XDebuggerActionBase.$$$reportNull$$$0(0);
        }
        Presentation presentation = event.getPresentation();
        boolean hidden = this.isHidden(event);
        if (hidden) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        boolean enabled = this.isEnabled(event);
        if (this.myHideDisabledInPopup && ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        } else {
            presentation.setVisible(true);
        }
        presentation.setEnabled(enabled);
    }

    protected boolean isEnabled(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null && !project.isDisposed()) {
            return Arrays.stream(DebuggerSupport.getDebuggerSupports()).anyMatch(support -> this.isEnabled(project, e, (DebuggerSupport)support));
        }
        return false;
    }

    @NotNull
    protected abstract DebuggerActionHandler getHandler(@NotNull DebuggerSupport var1);

    private boolean isEnabled(Project project, AnActionEvent event, DebuggerSupport support) {
        return this.getHandler(support).isEnabled(project, event);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            XDebuggerActionBase.$$$reportNull$$$0(1);
        }
        this.performWithHandler(e);
    }

    protected boolean performWithHandler(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return true;
        }
        for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
            if (!this.isEnabled(project, e, support)) continue;
            this.perform(project, e, support);
            return true;
        }
        return false;
    }

    private void perform(Project project, AnActionEvent e, DebuggerSupport support) {
        this.getHandler(support).perform(project, e);
    }

    protected boolean isHidden(AnActionEvent event) {
        Project project = event.getProject();
        if (project != null && !project.isDisposed()) {
            return Arrays.stream(DebuggerSupport.getDebuggerSupports()).allMatch(support -> this.getHandler((DebuggerSupport)support).isHidden(project, event));
        }
        return true;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/actions/XDebuggerActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

