/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.DimensionService;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupPositionManager {
    private static final Position[] DEFAULT_POSITION_ORDER = new Position[]{Position.RIGHT, Position.LEFT, Position.TOP, Position.BOTTOM};

    private PopupPositionManager() {
    }

    public static void positionPopupInBestPosition(JBPopup hint, @Nullable Editor editor, @Nullable DataContext dataContext) {
        PopupPositionManager.positionPopupInBestPosition(hint, editor, dataContext, DEFAULT_POSITION_ORDER);
    }

    public static void positionPopupInBestPosition(final JBPopup hint, @Nullable Editor editor, @Nullable DataContext dataContext, Position ... relationToExistingPopup) {
        LookupEx lookup;
        if (relationToExistingPopup == null) {
            PopupPositionManager.$$$reportNull$$$0(0);
        }
        if ((lookup = LookupManager.getActiveLookup(editor)) != null && lookup.getCurrentItem() != null && lookup.getComponent().isShowing()) {
            new PositionAdjuster(lookup.getComponent()).adjust(hint, relationToExistingPopup);
            lookup.addLookupListener(new LookupListener(){

                public void lookupCanceled(@NotNull LookupEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (hint.isVisible()) {
                        hint.cancel();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/popup/PopupPositionManager$1", "lookupCanceled"));
                }
            });
            return;
        }
        PositionAdjuster positionAdjuster = PopupPositionManager.createPositionAdjuster(hint);
        if (positionAdjuster != null) {
            positionAdjuster.adjust(hint, relationToExistingPopup);
            return;
        }
        if (editor != null && editor.getComponent().isShowing() && editor instanceof EditorEx) {
            dataContext = ((EditorEx)editor).getDataContext();
        }
        if (dataContext != null) {
            if (hint.canShow()) {
                hint.showInBestPositionFor(dataContext);
            } else {
                hint.setLocation(hint.getBestPositionFor(dataContext));
            }
        }
    }

    private static Component discoverPopup(DataKey<JBPopup> datakey, Component focusOwner) {
        if (focusOwner == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (focusOwner == null) {
            return null;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        JBPopup popup2 = (JBPopup)datakey.getData(dataContext);
        if (popup2 != null && popup2.isVisible()) {
            return popup2.getContent();
        }
        return null;
    }

    @Nullable
    private static PositionAdjuster createPositionAdjuster(JBPopup hint) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return null;
        }
        JBPopup popup2 = PopupUtil.getPopupContainerFor((Component)focusOwner);
        if (popup2 != null && popup2 != hint) {
            return new PositionAdjuster(popup2.getContent());
        }
        Component existing = PopupPositionManager.discoverPopup((DataKey<JBPopup>)LangDataKeys.POSITION_ADJUSTER_POPUP, focusOwner);
        if (existing != null) {
            return new PositionAdjuster2(existing, PopupPositionManager.discoverPopup((DataKey<JBPopup>)LangDataKeys.PARENT_POPUP, focusOwner));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relationToExistingPopup", "com/intellij/ui/popup/PopupPositionManager", "positionPopupInBestPosition"));
    }

    public static class PositionAdjuster {
        protected final int myGap;
        protected final Component myRelativeTo;
        protected final Point myRelativeOnScreen;
        protected final Rectangle myScreenRect;

        public PositionAdjuster(Component relativeTo, int gap) {
            this.myRelativeTo = relativeTo;
            this.myRelativeOnScreen = relativeTo.getLocationOnScreen();
            this.myScreenRect = ScreenUtil.getScreenRectangle((Point)this.myRelativeOnScreen);
            this.myGap = gap;
        }

        public PositionAdjuster(Component relativeTo) {
            this(relativeTo, 5);
        }

        protected Rectangle positionRight(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x + this.myRelativeTo.getWidth() + this.myGap, this.myRelativeOnScreen.y, d.width, d.height);
        }

        protected Rectangle positionLeft(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x - this.myGap - d.width, this.myRelativeOnScreen.y, d.width, d.height);
        }

        protected Rectangle positionAbove(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x, this.getYForTopPositioning() - this.myGap - d.height, d.width, d.height);
        }

        protected Rectangle positionUnder(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x, this.myRelativeOnScreen.y + this.myGap + this.myRelativeTo.getHeight(), d.width, d.height);
        }

        protected int getYForTopPositioning() {
            return this.myRelativeOnScreen.y;
        }

        public void adjust(JBPopup popup2) {
            this.adjust(popup2, DEFAULT_POSITION_ORDER);
        }

        public void adjust(JBPopup popup2, Position ... traversalPolicy) {
            if (traversalPolicy.length == 0) {
                traversalPolicy = DEFAULT_POSITION_ORDER;
            }
            Dimension d = PositionAdjuster.getPopupSize(popup2);
            Rectangle popupRect = null;
            Rectangle r = null;
            ArrayList<Rectangle> boxes = new ArrayList<Rectangle>();
            for (Position position : traversalPolicy) {
                switch (position) {
                    case TOP: {
                        r = this.positionAbove(d);
                        boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myRelativeOnScreen.x, this.myScreenRect.y, this.myScreenRect.width, this.getYForTopPositioning() - this.myScreenRect.y - this.myGap)));
                        break;
                    }
                    case BOTTOM: {
                        r = this.positionUnder(d);
                        boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myRelativeOnScreen.x, this.myRelativeOnScreen.y + this.myRelativeTo.getHeight() + this.myGap, this.myScreenRect.width, this.myScreenRect.height)));
                        break;
                    }
                    case LEFT: {
                        r = this.positionLeft(d);
                        boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myScreenRect.x, this.myRelativeOnScreen.y, this.myRelativeOnScreen.x - this.myScreenRect.x - this.myGap, this.myScreenRect.height)));
                        break;
                    }
                    case RIGHT: {
                        r = this.positionRight(d);
                        boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myRelativeOnScreen.x + this.myRelativeTo.getWidth() + this.myGap, this.myRelativeOnScreen.y, this.myScreenRect.width, this.myScreenRect.height)));
                    }
                }
                if (!this.myScreenRect.contains(r)) continue;
                popupRect = r;
                break;
            }
            if (popupRect != null) {
                if (popup2.isVisible()) {
                    popup2.setLocation(new Point(r.x, r.y));
                } else {
                    Point p = new Point(r.x - this.myRelativeOnScreen.x, r.y - this.myRelativeOnScreen.y);
                    popup2.show(new RelativePoint(this.myRelativeTo, p));
                }
            } else {
                Collections.sort(boxes, Comparator.comparingInt(o -> o.width).thenComparingInt(o -> o.height));
                Rectangle suitableBox = (Rectangle)boxes.get(boxes.size() - 1);
                Rectangle crop = PositionAdjuster.crop(suitableBox, new Rectangle(suitableBox.x < this.myRelativeOnScreen.x ? suitableBox.x + suitableBox.width - d.width : suitableBox.x, suitableBox.y < this.myRelativeOnScreen.y ? suitableBox.y + suitableBox.height - d.height : suitableBox.y, d.width, d.height));
                popup2.setSize(crop.getSize());
                if (popup2.isVisible()) {
                    popup2.setLocation(crop.getLocation());
                } else {
                    popup2.show(new RelativePoint(this.myRelativeTo, new Point(crop.getLocation().x - this.myRelativeOnScreen.x, crop.getLocation().y - this.myRelativeOnScreen.y)));
                }
            }
        }

        protected static Rectangle crop(Rectangle source, Rectangle toCrop) {
            Rectangle result2 = new Rectangle(toCrop);
            if (toCrop.x < source.x) {
                result2.width -= source.x - toCrop.x;
                result2.x = source.x;
            }
            if (toCrop.y < source.y) {
                result2.height -= source.y - toCrop.y;
                result2.y = source.y;
            }
            if (result2.x + result2.width > source.x + source.width) {
                result2.width = source.x + source.width - result2.x;
            }
            if (result2.y + result2.height > source.y + source.height) {
                result2.height = source.y + source.height - result2.y;
            }
            return result2;
        }

        public static Dimension getPopupSize(JBPopup popup2) {
            String dimensionKey;
            Dimension size = null;
            if (popup2 instanceof AbstractPopup && (dimensionKey = ((AbstractPopup)popup2).getDimensionServiceKey()) != null) {
                size = DimensionService.getInstance().getSize(dimensionKey);
            }
            if (size == null) {
                size = popup2.getContent().getPreferredSize();
            }
            return size;
        }
    }

    private static class PositionAdjuster2
    extends PositionAdjuster {
        private final Component myTopComponent;

        private PositionAdjuster2(Component relativeTo, Component topComponent) {
            super(relativeTo);
            this.myTopComponent = topComponent == null ? relativeTo : topComponent;
        }

        @Override
        protected int getYForTopPositioning() {
            return this.myTopComponent.getLocationOnScreen().y;
        }
    }

    public static enum Position {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

