/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

public abstract class HierarchyWatcher
implements ContainerListener {
    @Override
    public final void componentAdded(ContainerEvent e) {
        this.install(e.getChild());
        this.hierarchyChanged(e);
    }

    @Override
    public final void componentRemoved(ContainerEvent e) {
        Component removedChild = e.getChild();
        this.deinstall(removedChild);
        this.hierarchyChanged(e);
    }

    private void install(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                this.install(container.getComponent(i));
            }
            container.addContainerListener(this);
        }
    }

    private void deinstall(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                this.deinstall(container.getComponent(i));
            }
            container.removeContainerListener(this);
        }
    }

    protected abstract void hierarchyChanged(ContainerEvent var1);
}

