/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.DocumentUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PersistentRangeHighlighterImpl
extends RangeHighlighterImpl {
    private int myLine;

    static PersistentRangeHighlighterImpl create(@NotNull MarkupModel model, int offset, int layer, @NotNull HighlighterTargetArea target2, @Nullable TextAttributes textAttributes, boolean normalizeStartOffset) {
        if (model == null) {
            PersistentRangeHighlighterImpl.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            PersistentRangeHighlighterImpl.$$$reportNull$$$0(1);
        }
        int line = model.getDocument().getLineNumber(offset);
        int startOffset = normalizeStartOffset ? model.getDocument().getLineStartOffset(line) : offset;
        return new PersistentRangeHighlighterImpl(model, startOffset, line, layer, target2, textAttributes);
    }

    private PersistentRangeHighlighterImpl(@NotNull MarkupModel model, int startOffset, int line, int layer, @NotNull HighlighterTargetArea target2, @Nullable TextAttributes textAttributes) {
        if (model == null) {
            PersistentRangeHighlighterImpl.$$$reportNull$$$0(2);
        }
        if (target2 == null) {
            PersistentRangeHighlighterImpl.$$$reportNull$$$0(3);
        }
        super(model, startOffset, model.getDocument().getLineEndOffset(line), layer, target2, textAttributes, false, false);
        this.myLine = line;
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        boolean shouldTranslateViaDiff;
        if (e == null) {
            PersistentRangeHighlighterImpl.$$$reportNull$$$0(4);
        }
        DocumentEventImpl event = (DocumentEventImpl)e;
        boolean wasTranslatedViaDiff = shouldTranslateViaDiff = this.isValid() && PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, this.getStartOffset(), this.getEndOffset());
        if (shouldTranslateViaDiff) {
            wasTranslatedViaDiff = this.translatedViaDiff(e, event);
        }
        if (!wasTranslatedViaDiff) {
            super.changedUpdateImpl(e);
            if (this.isValid()) {
                this.myLine = this.getDocument().getLineNumber(this.getStartOffset());
                int endLine = this.getDocument().getLineNumber(this.getEndOffset());
                if (endLine != this.myLine) {
                    this.setIntervalEnd(this.getDocument().getLineEndOffset(this.myLine));
                }
            }
        }
        if (this.isValid() && this.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE) {
            this.setIntervalStart(DocumentUtil.getFirstNonSpaceCharOffset(this.getDocument(), this.myLine));
            this.setIntervalEnd(this.getDocument().getLineEndOffset(this.myLine));
        }
    }

    private boolean translatedViaDiff(DocumentEvent e, DocumentEventImpl event) {
        try {
            this.myLine = event.translateLineViaDiff(this.myLine);
        }
        catch (FilesTooBigForDiffException ignored) {
            return false;
        }
        if (this.myLine < 0 || this.myLine >= this.getDocument().getLineCount()) {
            this.invalidate(e);
        } else {
            DocumentEx document = this.getDocument();
            this.setIntervalStart(document.getLineStartOffset(this.myLine));
            this.setIntervalEnd(document.getLineEndOffset(this.myLine));
        }
        return true;
    }

    @Override
    public String toString() {
        return "PersistentRangeHighlighter" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " - " + this.myLine + (this.isGreedyToRight() ? "]" : ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/PersistentRangeHighlighterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "changedUpdateImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

