/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.impl.MacGestureAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class MouseGestureManager {
    private static final Logger LOG = Logger.getInstance((String)"MouseGestureManager");
    private final Map<IdeFrame, Object> myListeners = new HashMap<IdeFrame, Object>();
    private boolean HAS_TRACKPAD = false;

    public void add(IdeFrame frame) {
        if (!Registry.is((String)"actionSystem.mouseGesturesEnabled")) {
            return;
        }
        if (SystemInfo.isMacOSSnowLeopard) {
            try {
                if (this.myListeners.containsKey(frame)) {
                    this.remove(frame);
                }
                MacGestureAdapter listener2 = new MacGestureAdapter(this, frame);
                this.myListeners.put(frame, (Object)listener2);
            }
            catch (Throwable e) {
                LOG.error("Can't initialize MacGestureAdapter", e);
            }
        }
    }

    protected void activateTrackpad() {
        this.HAS_TRACKPAD = true;
    }

    public boolean hasTrackpad() {
        return this.HAS_TRACKPAD;
    }

    public void remove(IdeFrame frame) {
        if (!Registry.is((String)"actionSystem.mouseGesturesEnabled")) {
            return;
        }
        if (SystemInfo.isMacOSSnowLeopard) {
            try {
                Object listener2 = this.myListeners.get(frame);
                JComponent cmp = frame.getComponent();
                this.myListeners.remove(frame);
                if (listener2 != null && cmp != null && cmp.isShowing()) {
                    ((MacGestureAdapter)((Object)listener2)).remove(cmp);
                }
            }
            catch (Throwable e) {
                LOG.debug(e);
            }
        }
    }

    public static MouseGestureManager getInstance() {
        return (MouseGestureManager)ApplicationManager.getApplication().getComponent(MouseGestureManager.class);
    }
}

