/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.performance;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.internal.performance.LatenciometerKt;
import com.intellij.internal.performance.LatencyDistributionRecord;
import com.intellij.internal.performance.LatencyRecord;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J$\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u001d\u001a\u00020\u0006H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/internal/performance/TypingLatencyReportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "threadDumps", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "currentThreadDump", "", "nextThreadDumpButton", "Ljavax/swing/JButton;", "prevThreadDumpButton", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "createReportTree", "Lcom/intellij/ui/components/JBScrollPane;", "createThreadDumpBrowser", "formatLatency", "action", "latencyRecord", "Lcom/intellij/internal/performance/LatencyRecord;", "details", "formatReportAsText", "updateCurrentThreadDump", "", "ExportToFileAction", "intellij.platform.lang.impl"})
public final class TypingLatencyReportDialog
extends DialogWrapper {
    private int currentThreadDump;
    private ConsoleView consoleView;
    private JButton prevThreadDumpButton;
    private JButton nextThreadDumpButton;
    private final Project project;
    private final List<String> threadDumps;

    @NotNull
    protected JComponent createCenterPanel() {
        JBSplitter jBSplitter;
        JBScrollPane jbScrollPane = this.createReportTree();
        if (this.threadDumps.isEmpty()) {
            return (JComponent)jbScrollPane;
        }
        JBSplitter $receiver = jBSplitter = new JBSplitter(true);
        $receiver.setFirstComponent((JComponent)jbScrollPane);
        $receiver.setSecondComponent(this.createThreadDumpBrowser());
        return (JComponent)jBSplitter;
    }

    private final JBScrollPane createReportTree() {
        Iterable $receiver$iv;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Iterable iterable = $receiver$iv = (Iterable)LatenciometerKt.getLatencyMap().values();
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                LatencyDistributionRecord it = (LatencyDistributionRecord)a;
                Comparable comparable = (Comparable)((Object)it.getKey().getName());
                it = (LatencyDistributionRecord)b;
                Comparable comparable2 = comparable;
                String string = it.getKey().getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        for (LatencyDistributionRecord row2 : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)object)) {
            Iterable $receiver$iv2;
            DefaultMutableTreeNode rowNode = new DefaultMutableTreeNode(row2);
            root.add(rowNode);
            Iterable iterable2 = $receiver$iv2 = (Iterable)row2.getActionLatencyRecords().entrySet();
            Comparator comparator2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    Comparable comparable = Long.valueOf(((LatencyRecord)it.getValue()).getAverageLatency());
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    Long l = ((LatencyRecord)it.getValue()).getAverageLatency();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            };
            object = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2).iterator();
            while (object.hasNext()) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Map.Entry actionLatencyRecord;
                Map.Entry entry = actionLatencyRecord = (Map.Entry)object.next();
                DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
                DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode;
                DefaultMutableTreeNode defaultMutableTreeNode4 = rowNode;
                Pair pair = new Pair(entry.getKey(), entry.getValue());
                defaultMutableTreeNode2(pair);
                defaultMutableTreeNode4.add(defaultMutableTreeNode3);
            }
        }
        Tree reportList = new Tree((TreeModel)new DefaultTreeModel(root));
        reportList.setRootVisible(false);
        reportList.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(this){
            final /* synthetic */ TypingLatencyReportDialog this$0;

            public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
                if (value == null) {
                    return;
                }
                Object obj = ((DefaultMutableTreeNode)value).getUserObject();
                if (obj instanceof LatencyDistributionRecord) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)this.append(TypingLatencyReportDialog.access$formatLatency(this.this$0, ((LatencyDistributionRecord)obj).getKey().getName(), ((LatencyDistributionRecord)obj).getTotalLatency(), ((LatencyDistributionRecord)obj).getKey().getDetails())), (String)"append(formatLatency(obj\u2026atency, obj.key.details))");
                } else if (obj instanceof Pair) {
                    Pair pair = (Pair)obj;
                    this.append(TypingLatencyReportDialog.formatLatency$default(this.this$0, (String)pair.getFirst(), (LatencyRecord)pair.getSecond(), null, 4, null));
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        TreeUtil.expandAll((JTree)((JTree)reportList));
        return new JBScrollPane((Component)reportList);
    }

    private final String formatLatency(String action, LatencyRecord latencyRecord, String details) {
        String result2 = action + " - avg " + latencyRecord.getAverageLatency() + " ms, max " + latencyRecord.getMaxLatency() + " ms";
        if (details != null) {
            return result2 + ", " + details;
        }
        return result2;
    }

    static /* synthetic */ String formatLatency$default(TypingLatencyReportDialog typingLatencyReportDialog, String string, LatencyRecord latencyRecord, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return typingLatencyReportDialog.formatLatency(string, latencyRecord, string2);
    }

    private final JComponent createThreadDumpBrowser() {
        JButton jButton;
        TextConsoleBuilder builder2 = TextConsoleBuilderFactory.getInstance().createBuilder(this.project);
        builder2.filters(AnalyzeStacktraceUtil.EP_NAME.getExtensions((AreaInstance)this.project));
        TextConsoleBuilder textConsoleBuilder = builder2;
        Intrinsics.checkExpressionValueIsNotNull((Object)textConsoleBuilder, (String)"builder");
        ConsoleView consoleView = textConsoleBuilder.getConsole();
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleView, (String)"builder.console");
        this.consoleView = consoleView;
        Disposable disposable = this.getDisposable();
        ConsoleView consoleView2 = this.consoleView;
        if (consoleView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
        }
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)consoleView2));
        JBBox buttonsPanel = JBBox.createHorizontalBox();
        JButton jButton2 = new JButton("<<");
        TypingLatencyReportDialog typingLatencyReportDialog = this;
        JButton $receiver = jButton2;
        $receiver.addActionListener(new ActionListener(this){
            final /* synthetic */ TypingLatencyReportDialog this$0;
            {
                this.this$0 = typingLatencyReportDialog;
            }

            public final void actionPerformed(ActionEvent it) {
                TypingLatencyReportDialog typingLatencyReportDialog = this.this$0;
                int n = TypingLatencyReportDialog.access$getCurrentThreadDump$p(typingLatencyReportDialog);
                TypingLatencyReportDialog.access$setCurrentThreadDump$p(typingLatencyReportDialog, n + -1);
                TypingLatencyReportDialog.access$updateCurrentThreadDump(this.this$0);
            }
        });
        typingLatencyReportDialog.prevThreadDumpButton = jButton = jButton2;
        jButton2 = new JButton(">>");
        typingLatencyReportDialog = this;
        $receiver = jButton2;
        $receiver.addActionListener(new ActionListener(this){
            final /* synthetic */ TypingLatencyReportDialog this$0;
            {
                this.this$0 = typingLatencyReportDialog;
            }

            public final void actionPerformed(ActionEvent it) {
                TypingLatencyReportDialog typingLatencyReportDialog = this.this$0;
                int n = TypingLatencyReportDialog.access$getCurrentThreadDump$p(typingLatencyReportDialog);
                TypingLatencyReportDialog.access$setCurrentThreadDump$p(typingLatencyReportDialog, n + 1);
                TypingLatencyReportDialog.access$updateCurrentThreadDump(this.this$0);
            }
        });
        typingLatencyReportDialog.nextThreadDumpButton = jButton = jButton2;
        JButton jButton3 = this.prevThreadDumpButton;
        if (jButton3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prevThreadDumpButton");
        }
        buttonsPanel.add((Component)jButton3);
        buttonsPanel.add(Box.createHorizontalGlue());
        JButton jButton4 = this.nextThreadDumpButton;
        if (jButton4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextThreadDumpButton");
        }
        buttonsPanel.add((Component)jButton4);
        this.updateCurrentThreadDump();
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel();
        ConsoleView consoleView3 = this.consoleView;
        if (consoleView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
        }
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel.addToCenter((Component)consoleView3.getComponent()).addToBottom((Component)buttonsPanel);
        Intrinsics.checkExpressionValueIsNotNull((Object)borderLayoutPanel2, (String)"JBUI.Panels.simplePanel(\u2026addToBottom(buttonsPanel)");
        return (JComponent)borderLayoutPanel2;
    }

    private final void updateCurrentThreadDump() {
        ConsoleView consoleView = this.consoleView;
        if (consoleView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
        }
        consoleView.clear();
        ConsoleView consoleView2 = this.consoleView;
        if (consoleView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
        }
        consoleView2.print(this.threadDumps.get(this.currentThreadDump), ConsoleViewContentType.NORMAL_OUTPUT);
        ConsoleView consoleView3 = this.consoleView;
        if (consoleView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"consoleView");
        }
        consoleView3.scrollTo(0);
        JButton jButton = this.prevThreadDumpButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prevThreadDumpButton");
        }
        jButton.setEnabled(this.currentThreadDump > 0);
        JButton jButton2 = this.nextThreadDumpButton;
        if (jButton2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nextThreadDumpButton");
        }
        jButton2.setEnabled(this.currentThreadDump < this.threadDumps.size() - 1);
    }

    private final String formatReportAsText() {
        Object row22;
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        Object $receiver$iv = LatenciometerKt.getLatencyMap().values();
        Iterator iterator = $receiver$iv;
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                LatencyDistributionRecord it = (LatencyDistributionRecord)a;
                Comparable comparable = (Comparable)((Object)it.getKey().getName());
                it = (LatencyDistributionRecord)b;
                Comparable comparable2 = comparable;
                String string = it.getKey().getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        for (Object row22 : CollectionsKt.sortedWith((Iterable)((Object)iterator), (Comparator)object)) {
            $receiver$iv = $receiver;
            iterator = this.formatLatency(((LatencyDistributionRecord)row22).getKey().getName(), ((LatencyDistributionRecord)row22).getTotalLatency(), ((LatencyDistributionRecord)row22).getKey().getDetails());
            StringBuilder stringBuilder2 = ((StringBuilder)$receiver$iv).append((String)((Object)iterator));
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            $receiver$iv = $receiver;
            iterator = "Actions:";
            StringBuilder stringBuilder3 = ((StringBuilder)$receiver$iv).append((String)((Object)iterator));
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            Iterable $receiver$iv2 = ((LatencyDistributionRecord)row22).getActionLatencyRecords().entrySet();
            Object object2 = $receiver$iv2;
            Comparator comparator2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    Comparable comparable = Long.valueOf(((LatencyRecord)it.getValue()).getAverageLatency());
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    Long l = ((LatencyRecord)it.getValue()).getAverageLatency();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            };
            iterator = CollectionsKt.sortedWith((Iterable)object2, (Comparator)comparator2).iterator();
            while (iterator.hasNext()) {
                Map.Entry actionLatencyRecord = (Map.Entry)iterator.next();
                object = $receiver;
                object2 = "  " + TypingLatencyReportDialog.formatLatency$default(this, (String)actionLatencyRecord.getKey(), (LatencyRecord)actionLatencyRecord.getValue(), null, 4, null);
                StringBuilder stringBuilder4 = ((StringBuilder)object).append((String)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder4);
            }
        }
        StringsKt.appendln((StringBuilder)$receiver);
        row22 = this.threadDumps;
        if (!row22.isEmpty()) {
            row22 = $receiver;
            Iterator<String> iterator2 = "Thread dumps:";
            StringBuilder stringBuilder5 = ((StringBuilder)row22).append((String)((Object)iterator2));
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            for (String threadDump : this.threadDumps) {
                StringBuilder stringBuilder6 = $receiver;
                StringBuilder stringBuilder7 = stringBuilder6.append(threadDump);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder7);
                stringBuilder6 = $receiver;
                iterator = StringsKt.repeat((CharSequence)"-", (int)40);
                StringBuilder stringBuilder8 = stringBuilder6.append((String)((Object)iterator));
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder8, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder8);
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[2];
        actionArray[0] = new ExportToFileAction();
        Action action = this.getOKAction();
        Intrinsics.checkExpressionValueIsNotNull((Object)action, (String)"okAction");
        actionArray[1] = action;
        return actionArray;
    }

    public TypingLatencyReportDialog(@NotNull Project project, @NotNull List<String> threadDumps) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(threadDumps, (String)"threadDumps");
        super(project);
        this.project = project;
        this.threadDumps = threadDumps;
        this.init();
        this.setTitle("Typing Latency Report");
    }

    public /* synthetic */ TypingLatencyReportDialog(Project project, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(project, list2);
    }

    @NotNull
    public static final /* synthetic */ String access$formatLatency(TypingLatencyReportDialog $this, @NotNull String action, @NotNull LatencyRecord latencyRecord, @Nullable String details) {
        return $this.formatLatency(action, latencyRecord, details);
    }

    public static final /* synthetic */ int access$getCurrentThreadDump$p(TypingLatencyReportDialog $this) {
        return $this.currentThreadDump;
    }

    public static final /* synthetic */ void access$setCurrentThreadDump$p(TypingLatencyReportDialog $this, int n) {
        $this.currentThreadDump = n;
    }

    public static final /* synthetic */ void access$updateCurrentThreadDump(TypingLatencyReportDialog $this) {
        $this.updateCurrentThreadDump();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/internal/performance/TypingLatencyReportDialog$ExportToFileAction;", "Ljavax/swing/AbstractAction;", "(Lcom/intellij/internal/performance/TypingLatencyReportDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.platform.lang.impl"})
    private final class ExportToFileAction
    extends AbstractAction {
        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Export Typing Latency Report", "File name:", new String[]{"txt"});
            FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)TypingLatencyReportDialog.this.getContentPane());
            Intrinsics.checkExpressionValueIsNotNull((Object)fileSaverDialog, (String)"FileChooserFactory.getIn\u2026(descriptor, contentPane)");
            FileSaverDialog dialog2 = fileSaverDialog;
            VirtualFileWrapper virtualFileWrapper = dialog2.save(null, "typing-latency.txt");
            if (virtualFileWrapper == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileWrapper, (String)"dialog.save(null, \"typing-latency.txt\") ?: return");
            VirtualFileWrapper virtualFileWrapper2 = virtualFileWrapper;
            FileUtil.writeToFile((File)virtualFileWrapper2.getFile(), (String)TypingLatencyReportDialog.this.formatReportAsText());
        }

        public ExportToFileAction() {
            super("Export to File");
        }
    }
}

