/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.util.GotoLineNumberDialog;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class EditorGotoLineNumberDialog
extends GotoLineNumberDialog {
    private final Editor myEditor;

    public EditorGotoLineNumberDialog(Project project, Editor editor) {
        super(project);
        this.myEditor = editor;
        this.init();
    }

    protected void doOKAction() {
        GotoLineNumberDialog.Coordinates coordinates = this.getCoordinates();
        if (coordinates == null) {
            return;
        }
        LogicalPosition position = new LogicalPosition(coordinates.row, coordinates.column);
        this.myEditor.getCaretModel().removeSecondaryCarets();
        this.myEditor.getCaretModel().moveToLogicalPosition(position);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.myEditor.getSelectionModel().removeSelection();
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true);
        super.doOKAction();
    }

    @Override
    protected int getLine() {
        return this.myEditor.getCaretModel().getLogicalPosition().line;
    }

    @Override
    protected int getColumn() {
        return this.myEditor.getCaretModel().getLogicalPosition().column;
    }

    @Override
    protected int getOffset() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @Override
    protected int getMaxOffset() {
        return this.myEditor.getDocument().getTextLength();
    }

    @Override
    protected int coordinatesToOffset(@NotNull GotoLineNumberDialog.Coordinates coordinates) {
        if (coordinates == null) {
            EditorGotoLineNumberDialog.$$$reportNull$$$0(0);
        }
        LogicalPosition position = new LogicalPosition(coordinates.row, coordinates.column);
        return this.myEditor.logicalPositionToOffset(position);
    }

    @Override
    @NotNull
    protected GotoLineNumberDialog.Coordinates offsetToCoordinates(int offset) {
        LogicalPosition position = this.myEditor.offsetToLogicalPosition(offset);
        GotoLineNumberDialog.Coordinates coordinates = new GotoLineNumberDialog.Coordinates(position.line, position.column);
        if (coordinates == null) {
            EditorGotoLineNumberDialog.$$$reportNull$$$0(1);
        }
        return coordinates;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/EditorGotoLineNumberDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/EditorGotoLineNumberDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToCoordinates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "coordinatesToOffset";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

