/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class AddSpaceInsertHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> INSTANCE = new AddSpaceInsertHandler(false);
    public static final InsertHandler<LookupElement> INSTANCE_WITH_AUTO_POPUP = new AddSpaceInsertHandler(true);
    private final String myIgnoreOnChars;
    private final boolean myTriggerAutoPopup;

    public AddSpaceInsertHandler(boolean triggerAutoPopup) {
        this("", triggerAutoPopup);
    }

    public AddSpaceInsertHandler(String ignoreOnChars, boolean triggerAutoPopup) {
        this.myIgnoreOnChars = ignoreOnChars;
        this.myTriggerAutoPopup = triggerAutoPopup;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            AddSpaceInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            AddSpaceInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor = context.getEditor();
        char completionChar = context.getCompletionChar();
        if (completionChar == ' ' || StringUtil.containsChar((String)this.myIgnoreOnChars, (char)completionChar)) {
            return;
        }
        Project project = editor.getProject();
        if (project != null) {
            if (!AddSpaceInsertHandler.isCharAtSpace(editor)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            } else if (this.shouldOverwriteExistingSpace(editor)) {
                editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
            }
            if (this.myTriggerAutoPopup) {
                AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, null);
            }
        }
    }

    protected boolean shouldOverwriteExistingSpace(Editor editor) {
        return true;
    }

    private static boolean isCharAtSpace(Editor editor) {
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == ' ';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/AddSpaceInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

