/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopyFormat;

public class UpgradeFormatDialog
extends DialogWrapper {
    private final ButtonGroup formatGroup = new ButtonGroup();
    private final List<JRadioButton> formatButtons = new ArrayList<JRadioButton>();
    private JBLoadingPanel myLoadingPanel;
    protected File myPath;

    public UpgradeFormatDialog(Project project, File path, boolean canBeParent) {
        this(project, path, canBeParent, true);
    }

    protected UpgradeFormatDialog(Project project, File path, boolean canBeParent, boolean initHere) {
        super(project, canBeParent);
        this.myPath = path;
        this.setResizable(false);
        this.setTitle(SvnBundle.message("dialog.upgrade.wcopy.format.title", new Object[0]));
        if (initHere) {
            this.init();
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn.upgradeDialog";
    }

    public void setData(@NotNull WorkingCopyFormat selectedFormat) {
        if (selectedFormat == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(1);
        }
        for (JRadioButton button : this.formatButtons) {
            if (selectedFormat != UpgradeFormatDialog.getFormat(button)) continue;
            button.setSelected(true);
            break;
        }
    }

    public void setSupported(@NotNull Collection<WorkingCopyFormat> supported) {
        if (supported == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(2);
        }
        for (JRadioButton button : this.formatButtons) {
            button.setEnabled(supported.contains((Object)UpgradeFormatDialog.getFormat(button)));
        }
    }

    public void startLoading() {
        this.enableFormatButtons(false);
        this.getOKAction().setEnabled(false);
        this.myLoadingPanel.startLoading();
    }

    private void enableFormatButtons(boolean enabled) {
        for (JRadioButton button : this.formatButtons) {
            button.setEnabled(enabled);
        }
    }

    public void stopLoading() {
        this.getOKAction().setEnabled(true);
        this.myLoadingPanel.stopLoading();
    }

    protected String getTopMessage(String label) {
        return SvnBundle.message("label.configure." + label + ".label", ApplicationNamesInfo.getInstance().getFullProductName());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = JBUI.insets((int)2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 2;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        File adminPath = new File(this.myPath, SvnUtil.SVN_ADMIN_DIR_NAME);
        boolean adminPathIsDirectory = adminPath.isDirectory();
        String label = this.getMiddlePartOfResourceKey(adminPathIsDirectory);
        JLabel topLabel = new JLabel(this.getTopMessage(label));
        topLabel.setUI((LabelUI)new MultiLineLabelUI());
        panel.add((Component)topLabel, gb);
        ++gb.gridy;
        this.registerFormat(WorkingCopyFormat.ONE_DOT_SIX, label, panel, gb);
        this.registerFormat(WorkingCopyFormat.ONE_DOT_SEVEN, label, panel, gb);
        this.registerFormat(WorkingCopyFormat.ONE_DOT_EIGHT, label, panel, gb);
        JPanel auxiliaryPanel = this.getBottomAuxiliaryPanel();
        if (auxiliaryPanel != null) {
            panel.add((Component)auxiliaryPanel, gb);
            ++gb.gridy;
        }
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.myLoadingPanel.add((Component)panel, (Object)"Center");
        return this.myLoadingPanel;
    }

    private void registerFormat(@NotNull WorkingCopyFormat format, @NotNull String label, @NotNull JPanel panel, @NotNull GridBagConstraints gb) {
        if (format == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(3);
        }
        if (label == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(4);
        }
        if (panel == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(5);
        }
        if (gb == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(6);
        }
        JRadioButton button = new JRadioButton(SvnBundle.message("radio.configure." + label + ".auto." + UpgradeFormatDialog.getKey(format) + "format", new Object[0]));
        button.putClientProperty("format", (Object)format);
        panel.add((Component)button, gb);
        ++gb.gridy;
        this.formatGroup.add(button);
        this.formatButtons.add(button);
    }

    private static String getKey(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(7);
        }
        return String.format("%d%d", format.getVersion().major, format.getVersion().minor);
    }

    @Nullable
    protected JPanel getBottomAuxiliaryPanel() {
        return null;
    }

    protected String getMiddlePartOfResourceKey(boolean adminPathIsDirectory) {
        return !adminPathIsDirectory ? "create" : "upgrade";
    }

    protected boolean showHints() {
        return true;
    }

    @NotNull
    private static WorkingCopyFormat getFormat(@NotNull JRadioButton button) {
        Object format;
        if (button == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(8);
        }
        WorkingCopyFormat workingCopyFormat = (format = button.getClientProperty("format")) instanceof WorkingCopyFormat ? (WorkingCopyFormat)((Object)format) : WorkingCopyFormat.UNKNOWN;
        if (workingCopyFormat == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(9);
        }
        return workingCopyFormat;
    }

    @NotNull
    public WorkingCopyFormat getUpgradeMode() {
        WorkingCopyFormat result = WorkingCopyFormat.UNKNOWN;
        for (JRadioButton button : this.formatButtons) {
            if (!button.isSelected()) continue;
            result = UpgradeFormatDialog.getFormat(button);
            break;
        }
        WorkingCopyFormat workingCopyFormat = result;
        if (workingCopyFormat == null) {
            UpgradeFormatDialog.$$$reportNull$$$0(10);
        }
        return workingCopyFormat;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFormat";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supported";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gb";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpgradeMode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSupported";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerFormat";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

