/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.TestFrameworkConfigurator;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyCommandLineExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

public abstract class RubyAbstractRunner
implements RubyRunner {
    private static final Logger a;
    private static final Key<ThrowableRunnable<ExecutionException>> d;
    @NonNls
    private static final String c = "-X19";
    @NonNls
    private static final String b = "RM_INFO";
    @Nullable
    protected final Module myModule;
    @NotNull
    private final RubySdkSystemAccessor e;
    private static final long g;

    protected RubyAbstractRunner(@Nullable Module module, @NotNull RubySdkSystemAccessor systemAccessor) {
        if (systemAccessor == null) {
            RubyAbstractRunner.b(0);
        }
        this.myModule = module;
        this.e = systemAccessor;
    }

    @Override
    @NotNull
    public final RubySdkSystemAccessor getSystemAccessor() {
        RubySdkSystemAccessor rubySdkSystemAccessor = this.e;
        if (rubySdkSystemAccessor == null) {
            RubyAbstractRunner.b(1);
        }
        return rubySdkSystemAccessor;
    }

    private void a(@NotNull Sdk sdk, @NotNull PathMappingSettings pathMappingSettings, @NotNull Map<String, String> map) {
        TestFrameworkConfigurator[] testFrameworkConfiguratorArray;
        if (sdk == null) {
            RubyAbstractRunner.b(2);
        }
        if (pathMappingSettings == null) {
            RubyAbstractRunner.b(3);
        }
        if (map == null) {
            RubyAbstractRunner.b(4);
        }
        if ((testFrameworkConfiguratorArray = (TestFrameworkConfigurator[])TestFrameworkConfigurator.EP_NAME.getExtensions()).length > 0) {
            try {
                testFrameworkConfiguratorArray[0].configureTestFrameworkSupport(sdk, pathMappingSettings, map, this.myModule);
            }
            catch (ExecutionException executionException) {
                a.warn((Throwable)executionException);
            }
        }
    }

    @Override
    @NotNull
    public RubyCommandLine createCommandLine(@NotNull RubyRunnerExecutionContext context) {
        long l2 = g ^ 0x5CC35825132EL;
        if (context == null) {
            RubyAbstractRunner.b(5);
        }
        RubyCommandLine rubyCommandLine = new RubyCommandLine(this, context.isAskForSudo());
        rubyCommandLine.withPty(context.isAllocatePty());
        Sdk sdk = context.getRubySdk();
        PathMappingSettings pathMappingSettings = this.addDefaultMappings(context.getPathMappings());
        String string = context.getWorkingDirPath();
        String string2 = context.getExecutablePath();
        rubyCommandLine.setExePath(this.toSystemDependentName(string2, pathMappingSettings));
        if (string != null) {
            rubyCommandLine.withWorkDirectory(this.toSystemDependentName(string, pathMappingSettings));
        }
        if (JRubySdkType.isJRubyExecutable(string2)) {
            JRubySdkUtil.addJRubyClassPath(rubyCommandLine, RubyAbstractRunner.a(context.getAdditionalEnvs()));
        }
        if (JRubySdkUtil.isJRubySDK(sdk)) {
            JRubySdkUtil.specifyLanguageLevel(rubyCommandLine, sdk);
        } else if (RubySdkUtil.isRubinius(sdk) && RubySdkUtil.isRuby19(sdk)) {
            rubyCommandLine.addParameter(c);
        }
        rubyCommandLine.addParameters(context.getExecutableArguments());
        Map<String, String> map = RubyAbstractRunner.addRMEnvironment(context.getAdditionalEnvs());
        EnvironmentUtil.inlineParentOccurrences(map, this.getParentEnv());
        this.passParentEnv(context.isWithParentEnv(), rubyCommandLine);
        Map map2 = rubyCommandLine.getEnvironment();
        map2.putAll(map);
        if (!map2.containsKey("ANSICON")) {
            map2.put("ANSICON", "");
        }
        if (SystemInfo.isMac && !map2.containsKey("LANG")) {
            map2.put("LANG", Locale.getDefault().toString() + ".UTF-8");
        }
        if (sdk != null) {
            this.a(sdk, pathMappingSettings, map2);
            if (context.isPatchWithVersionManager()) {
                d.set((UserDataHolder)rubyCommandLine, () -> RubyVersionManagerHandler.patchCommandLine(this, rubyCommandLine, map2, map, sdk, pathMappingSettings));
            }
        }
        RubyCommandLine rubyCommandLine2 = context.preprocessCommandLine(rubyCommandLine);
        if (rubyCommandLine2 == null) {
            RubyAbstractRunner.b(6);
        }
        return rubyCommandLine2;
    }

    protected void passParentEnv(boolean passParentEnvs, @NotNull GeneralCommandLine cmdLine) {
        if (cmdLine == null) {
            RubyAbstractRunner.b(7);
        }
        cmdLine.withParentEnvironmentType(passParentEnvs ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
    }

    @NotNull
    public abstract String toSystemDependentName(@NotNull String var1, @NotNull PathMappingSettings var2);

    @Override
    @Nullable
    public ProcessOutput execute(@NotNull RubyCommandLineExecutionContext context) throws ExecutionException {
        if (context == null) {
            RubyAbstractRunner.b(8);
        }
        RubyCommandLine rubyCommandLine = context.getCommandLine();
        ExecutionMode executionMode = context.getExecutionMode();
        String string = context.getExecutionID();
        ProcessHandler processHandler = this.a(rubyCommandLine, null, string);
        CapturingProcessAdapter capturingProcessAdapter = new CapturingProcessAdapter();
        if (!executionMode.inBackGround()) {
            processHandler.addProcessListener((ProcessListener)capturingProcessAdapter);
        }
        for (ProcessListener processListener : executionMode.getProcessListeners()) {
            processHandler.addProcessListener(processListener);
        }
        this.applyLastPatchTo(processHandler).startNotify();
        ExecutionHelper.executeExternalProcess((Project)context.getProject(), (ProcessHandler)processHandler, (ExecutionMode)executionMode, (GeneralCommandLine)rubyCommandLine);
        if (executionMode.inBackGround()) {
            return null;
        }
        return capturingProcessAdapter.getOutput();
    }

    @NotNull
    public ProcessHandler applyLastPatchTo(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            RubyAbstractRunner.b(9);
        }
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            RubyAbstractRunner.b(10);
        }
        return processHandler2;
    }

    @Deprecated
    @NotNull
    protected ProcessHandler createProcessHandlerInner(@NotNull RubyCommandLine commandLine, @Nullable String runnerId, boolean allocatePty) throws ExecutionException {
        if (commandLine == null) {
            RubyAbstractRunner.b(11);
        }
        ProcessHandler processHandler = this.createProcessHandlerInner(commandLine.withPty(allocatePty), runnerId);
        if (processHandler == null) {
            RubyAbstractRunner.b(12);
        }
        return processHandler;
    }

    @NotNull
    protected abstract ProcessHandler createProcessHandlerInner(@NotNull RubyCommandLine var1, @Nullable String var2) throws ExecutionException;

    @NotNull
    protected ProcessHandler processProcessHandler(@NotNull ProcessHandler processHandler, @Nullable String executionID) {
        if (processHandler == null) {
            RubyAbstractRunner.b(13);
        }
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            RubyAbstractRunner.b(14);
        }
        return processHandler2;
    }

    @Override
    @NotNull
    public final ProcessHandler createProcessHandler(@NotNull RubyCommandLine commandLine, @Nullable String runnerId) throws ExecutionException {
        if (commandLine == null) {
            RubyAbstractRunner.b(15);
        }
        ProcessHandler processHandler = this.a(commandLine, runnerId, null);
        if (processHandler == null) {
            RubyAbstractRunner.b(16);
        }
        return processHandler;
    }

    @NotNull
    private static RubyCommandLine a(@NotNull RubyCommandLine rubyCommandLine) throws ExecutionException {
        ThrowableRunnable throwableRunnable;
        if (rubyCommandLine == null) {
            RubyAbstractRunner.b(17);
        }
        if ((throwableRunnable = (ThrowableRunnable)d.get((UserDataHolder)rubyCommandLine)) != null) {
            throwableRunnable.run();
        }
        RubyCommandLine rubyCommandLine2 = rubyCommandLine;
        if (rubyCommandLine2 == null) {
            RubyAbstractRunner.b(18);
        }
        return rubyCommandLine2;
    }

    @NotNull
    private ProcessHandler a(@NotNull RubyCommandLine rubyCommandLine, @Nullable String string, @Nullable String string2) throws ExecutionException {
        Application application;
        long l2 = g ^ 0x604B773A9FE9L;
        if (rubyCommandLine == null) {
            RubyAbstractRunner.b(19);
        }
        if (Registry.is((String)"ruby.execution.lock.control") && (application = ApplicationManager.getApplication()).isReadAccessAllowed() && !application.isUnitTestMode()) {
            a.warn("Ruby command should not be executed under lock. [Read lock: " + application.isReadAccessAllowed() + "; Write lock: " + application.isWriteAccessAllowed() + "; EDT: " + application.isDispatchThread() + "]", new Throwable());
        }
        ProcessHandler processHandler = this.processProcessHandler(this.createProcessHandlerInner(RubyAbstractRunner.a(rubyCommandLine), string), string2);
        if (processHandler == null) {
            RubyAbstractRunner.b(20);
        }
        return processHandler;
    }

    @Override
    @NotNull
    public Pair<PortForwarding, PortForwarding> getDebuggerForwardings() throws ExecutionException {
        Pair pair;
        long l2 = g ^ 0x300C965F4013L;
        try {
            int[] nArray = NetUtils.findAvailableSocketPorts((int)2);
            int[] nArray2 = this.findAvailableRemotePorts(nArray);
            pair = Pair.create((Object)PortForwarding.remoteToLocal("localhost", nArray2[0], nArray[0]), (Object)PortForwarding.localToRemote("localhost", nArray[1], nArray2[1]));
        }
        catch (IOException iOException) {
            throw new ExecutionException(RBundle.message((String)"ruby.debugger.cannot.find.free.port"));
        }
        if (pair == null) {
            RubyAbstractRunner.b(21);
        }
        return pair;
    }

    @NotNull
    protected abstract int[] findAvailableRemotePorts(@NotNull int[] var1) throws ExecutionException;

    @Nullable
    private static String a(@Nullable Map<String, String> map) {
        long l2 = g ^ 0x4376238D04AAL;
        return map == null ? null : map.get("CLASSPATH");
    }

    @NotNull
    public static Map<String, String> addRMEnvironment(@Nullable Map<String, String> environment) {
        long l2 = g ^ 0x9F84E1849E6L;
        HashMap hashMap = environment != null ? ContainerUtil.newHashMap(environment) : ContainerUtil.newHashMap();
        hashMap.put(b, ApplicationInfoEx.getInstanceEx().getBuild().asString());
        HashMap hashMap2 = hashMap;
        if (hashMap2 == null) {
            RubyAbstractRunner.b(22);
        }
        return hashMap2;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @Override
    @NotNull
    public final ProcessHandler createConsoleProcessHandler(@NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RubyAbstractRunner.b(23);
        }
        ProcessHandler processHandler = this.createConsoleProcessHandlerInner(RubyAbstractRunner.a(commandLine));
        if (processHandler == null) {
            RubyAbstractRunner.b(24);
        }
        return processHandler;
    }

    @NotNull
    protected abstract ProcessHandler createConsoleProcessHandlerInner(@NotNull RubyCommandLine var1) throws ExecutionException;

    static {
        g = la.a(-8036360723108729070L, 326806597410284333L, MethodHandles.lookup().lookupClass()).a(198889435933874L);
        long l2 = g ^ 0x2025FE8DEC4FL;
        a = Logger.getInstance(RubyAbstractRunner.class);
        d = Key.create((String)"ruby.version.manager.patch");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x7D5B69B29AD0L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemAccessor";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/RubyAbstractRunner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/RubyAbstractRunner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemAccessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyLastPatchTo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandlerInner";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processProcessHandler";
                break;
            }
            case 16: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "applyVersionManagerPatch";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerForwardings";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addRMEnvironment";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleProcessHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureTestFrameworkSupport";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "passParentEnv";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyLastPatchTo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandlerInner";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processProcessHandler";
                break;
            }
            case 15: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyVersionManagerPatch";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleProcessHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

