/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.MissingGemNotificationWithFix;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;

public class CreatePuppetModuleAction
extends CreateInDirectoryActionBase {
    public static final Pattern PUPPET_USER_NAME_PATTERN = Pattern.compile("\\w+");
    public static final Pattern PUPPET_MODULE_NAME_PATTERN = Pattern.compile("[a-z][a-z0-9_]*");
    public static final String GEM_NAME = "puppet";
    private static final Pattern PUPPET_FULL_MODULE_NAME_PATTERN = Pattern.compile(PUPPET_USER_NAME_PATTERN + "-" + PUPPET_MODULE_NAME_PATTERN);
    private static final String GEM_SCRIPT_NAME = "puppet";
    private static final Logger LOG = Logger.getInstance(CreatePuppetModuleAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        String newName;
        if (e == null) {
            CreatePuppetModuleAction.$$$reportNull$$$0(0);
        }
        if (!StringUtil.isEmpty((String)(newName = Messages.showInputDialog((Project)e.getProject(), (String)PuppetBundle.message((String)"puppet.create.module.text", (Object[])new Object[0]), (String)PuppetBundle.message((String)"puppet.create.module.title", (Object[])new Object[0]), (Icon)this.getTemplatePresentation().getIcon(), null, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return PUPPET_FULL_MODULE_NAME_PATTERN.matcher(inputString).matches();
            }

            public boolean canClose(String inputString) {
                return true;
            }
        })))) {
            CreatePuppetModuleAction.createModule(newName, e);
        }
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        VirtualFile rootDirectory = CreatePuppetModuleAction.getValidRootDirectory(dataContext);
        if (rootDirectory == null) {
            return false;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project != null) : "Should be checked by super-method";
        Sdk fileSdk = RModuleUtil.getInstance().findRubySdkForVirtualFile(project, rootDirectory);
        if (fileSdk == null) {
            return false;
        }
        PuppetEntity puppetEntity = PuppetProjectManager.getInstance((Project)project).findModuleOrEnvironmentForFile(rootDirectory);
        if (puppetEntity == null) {
            return true;
        }
        for (VirtualFile dependencyRoot : puppetEntity.getAllDependenciesRoots()) {
            if (!rootDirectory.equals(dependencyRoot)) continue;
            return true;
        }
        return false;
    }

    private static void createModule(@NotNull String name, AnActionEvent e) {
        if (name == null) {
            CreatePuppetModuleAction.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = e.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        VirtualFile rootDirectory = CreatePuppetModuleAction.getValidRootDirectory(e.getDataContext());
        if (rootDirectory == null || !rootDirectory.isValid()) {
            return;
        }
        Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)rootDirectory, (Project)project);
        if (fileModule == null || fileModule.isDisposed()) {
            return;
        }
        CreatePuppetModuleAction.createModule(fileModule, rootDirectory, name);
    }

    public static void createModule(final @NotNull Module fileModule, final @NotNull VirtualFile rootDirectory, final @NotNull String name) {
        if (fileModule == null) {
            CreatePuppetModuleAction.$$$reportNull$$$0(2);
        }
        if (rootDirectory == null) {
            CreatePuppetModuleAction.$$$reportNull$$$0(3);
        }
        if (name == null) {
            CreatePuppetModuleAction.$$$reportNull$$$0(4);
        }
        final Project project = fileModule.getProject();
        final Sdk fileSdk = RModuleUtil.getInstance().findRubySdkForModule(fileModule);
        if (fileSdk == null) {
            return;
        }
        MissingGemNotificationWithFix.checkGemExecPresenceOrInstall((Module)fileModule, (Sdk)fileSdk, (String)"puppet", success -> {
            if (name == null) {
                CreatePuppetModuleAction.$$$reportNull$$$0(6);
            }
            if (fileModule == null) {
                CreatePuppetModuleAction.$$$reportNull$$$0(7);
            }
            if (rootDirectory == null) {
                CreatePuppetModuleAction.$$$reportNull$$$0(8);
            }
            new Task.Backgroundable(project, PuppetBundle.message((String)"puppet.create.module.progress", (Object[])new Object[]{name}), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    try {
                        LOG.info("Creating puppet module " + name);
                        ProcessOutput output = ((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create((Sdk)fileSdk, (String)"puppet").withGemScriptName("puppet").withModule(fileModule)).withWorkingDir(rootDirectory)).withExecutionMode((ExecutionMode)new ExecutionModes.SameThreadMode(true))).withArguments(new String[]{"module", "generate", "--skip-interview", name})).executeScript();
                        if (output != null && output.getExitCode() != 0) {
                            String stdout;
                            String errorHeader = PuppetBundle.message((String)"puppet.external.script.error.header", (Object[])new Object[]{output.getExitCode()});
                            LOG.info(errorHeader);
                            String stderr = output.getStderr();
                            if (StringUtil.isNotEmpty((String)stderr)) {
                                LOG.info("STDERR: " + stderr);
                            }
                            if (StringUtil.isNotEmpty((String)(stdout = output.getStdout()))) {
                                LOG.info("STDOUT: " + stdout);
                            }
                            Notifications.Bus.notify((Notification)new Notification("PUPPET_ERROR", errorHeader, "<pre>" + stderr + "</pre>", NotificationType.ERROR));
                            return;
                        }
                    }
                    catch (ExecutionException e) {
                        LOG.error(e.getMessage());
                        return;
                    }
                    rootDirectory.refresh(false, false);
                    VirtualFile moduleDirectory = rootDirectory.findFileByRelativePath(name.substring(name.indexOf(45) + 1));
                    if (moduleDirectory == null) {
                        return;
                    }
                    VirtualFile moduleMetaFile = moduleDirectory.findFileByRelativePath("metadata.json");
                    if (moduleMetaFile != null) {
                        ApplicationManager.getApplication().invokeLater(() -> OpenFileAction.openFile((VirtualFile)moduleMetaFile, (Project)project), ModalityState.NON_MODAL);
                    }
                    VcsFileUtil.addFilesToVcsWithConfirmation((Project)project, (VirtualFile[])new VirtualFile[]{moduleDirectory});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/puppet/ide/actions/CreatePuppetModuleAction$2", "run"));
                }
            }.queue();
        });
    }

    @Nullable
    private static VirtualFile getValidRootDirectory(@NotNull DataContext dataContext) {
        VirtualFile rootDirectory;
        if (dataContext == null) {
            CreatePuppetModuleAction.$$$reportNull$$$0(5);
        }
        return (rootDirectory = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) == null || !rootDirectory.isDirectory() || !rootDirectory.isValid() ? null : rootDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileModule";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/ide/actions/CreatePuppetModuleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getValidRootDirectory";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createModule$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

