/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntrospectionScopes {
    @NotNull
    public static IntrospectionScope scopeOf(@NotNull Collection<Couple<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            IntrospectionScopes.$$$reportNull$$$0(0);
        }
        IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(IntrospectionScopes.pairsToMap(databasesAndSchemas));
        if (introspectionScope == null) {
            IntrospectionScopes.$$$reportNull$$$0(1);
        }
        return introspectionScope;
    }

    @NotNull
    private static MultiMap<String, String> pairsToMap(@NotNull Collection<Couple<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            IntrospectionScopes.$$$reportNull$$$0(2);
        }
        MultiMap result2 = MultiMap.create();
        for (Pair p2 : ContainerUtil.sorted(databasesAndSchemas, (a, b2) -> Comparing.compare((Comparable)((Comparable)a.second), (Comparable)((Comparable)b2.second)))) {
            result2.putValue(p2.first, p2.second);
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            IntrospectionScopes.$$$reportNull$$$0(3);
        }
        return multiMap;
    }

    @NotNull
    public static IntrospectionScope collapse(@NotNull MultiMap<String, String> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            IntrospectionScopes.$$$reportNull$$$0(4);
        }
        if (databasesAndSchemas.get((Object)"*").contains("*")) {
            IntrospectionScope introspectionScope = IntrospectionScope.ALL_SCOPE;
            if (introspectionScope == null) {
                IntrospectionScopes.$$$reportNull$$$0(5);
            }
            return introspectionScope;
        }
        for (String d2 : databasesAndSchemas.keySet()) {
            if (!databasesAndSchemas.get((Object)d2).contains("*")) continue;
            Collection modifiable = databasesAndSchemas.getModifiable((Object)d2);
            modifiable.clear();
            modifiable.add("*");
        }
        IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(databasesAndSchemas);
        if (introspectionScope == null) {
            IntrospectionScopes.$$$reportNull$$$0(6);
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull MultiMap<String, String> databasesAndSchemas) {
        Set databases;
        if (databasesAndSchemas == null) {
            IntrospectionScopes.$$$reportNull$$$0(7);
        }
        if ((databases = databasesAndSchemas.keySet()).size() == 1) {
            String database = (String)databases.iterator().next();
            Collection schemas2 = databasesAndSchemas.get((Object)database);
            IntrospectionScope introspectionScope = schemas2.contains("*") ? IntrospectionScope.scopeOf(database, "*") : IntrospectionScope.scopeOf(database, schemas2);
            if (introspectionScope == null) {
                IntrospectionScopes.$$$reportNull$$$0(8);
            }
            return introspectionScope;
        }
        ImmutableMap.Builder b2 = ImmutableMap.builder();
        Iterator iterator = databases.iterator();
        while (iterator.hasNext()) {
            String database;
            Collection schemas3 = databasesAndSchemas.get((Object)(database = (String)iterator.next()));
            b2.put((Object)database, (Object)(schemas3.size() > 1 && schemas3.contains("*") ? ImmutableSet.of((Object)"*") : ImmutableSet.copyOf((Collection)schemas3)));
        }
        IntrospectionScope introspectionScope = IntrospectionScope.scopeOf((ImmutableMap<String, ImmutableSet<String>>)b2.build());
        if (introspectionScope == null) {
            IntrospectionScopes.$$$reportNull$$$0(9);
        }
        return introspectionScope;
    }

    @NotNull
    @Contract(pure=true)
    public static IntrospectionScope importScope(@Nullable String string) {
        if (StringUtil.isEmpty((String)string)) {
            IntrospectionScope introspectionScope = IntrospectionScope.EMPTY_SCOPE;
            if (introspectionScope == null) {
                IntrospectionScopes.$$$reportNull$$$0(10);
            }
            return introspectionScope;
        }
        if (string.equals("@") || string.equals("@:@")) {
            IntrospectionScope introspectionScope = IntrospectionScope.CURRENT_SCOPE;
            if (introspectionScope == null) {
                IntrospectionScopes.$$$reportNull$$$0(11);
            }
            return introspectionScope;
        }
        if (string.equals("*") || string.equals("*:*")) {
            IntrospectionScope introspectionScope = IntrospectionScope.ALL_SCOPE;
            if (introspectionScope == null) {
                IntrospectionScopes.$$$reportNull$$$0(12);
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = IntrospectionScope.importState(string);
        if (introspectionScope == null) {
            IntrospectionScopes.$$$reportNull$$$0(13);
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope fromSchemaPattern(@Nullable String schemaPattern) {
        if (StringUtil.isEmpty((String)schemaPattern)) {
            IntrospectionScope introspectionScope = IntrospectionScope.EMPTY_SCOPE;
            if (introspectionScope == null) {
                IntrospectionScopes.$$$reportNull$$$0(14);
            }
            return introspectionScope;
        }
        String[] strings = IntrospectionScopes.splitSchemaPattern(schemaPattern);
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)strings.length);
        for (String string : strings) {
            if ("*".equals(string)) {
                IntrospectionScope introspectionScope = IntrospectionScope.ALL_SCOPE;
                if (introspectionScope == null) {
                    IntrospectionScopes.$$$reportNull$$$0(15);
                }
                return introspectionScope;
            }
            List split = StringUtil.split((String)string, (String)".");
            if (split.size() == 1) {
                split.add(string.startsWith(".") ? 0 : 1, "");
            }
            if (split.size() != 2) continue;
            list.add(Couple.of(split.get(0), split.get(1)));
        }
        IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(list);
        if (introspectionScope == null) {
            IntrospectionScopes.$$$reportNull$$$0(16);
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope invertIf(@NotNull IntrospectionScope scope, boolean invert) {
        if (scope == null) {
            IntrospectionScopes.$$$reportNull$$$0(17);
        }
        if (!invert) {
            IntrospectionScope introspectionScope = scope;
            if (introspectionScope == null) {
                IntrospectionScopes.$$$reportNull$$$0(18);
            }
            return introspectionScope;
        }
        if (scope.isEmpty()) {
            IntrospectionScope introspectionScope = IntrospectionScope.EMPTY_SCOPE;
            if (introspectionScope == null) {
                IntrospectionScopes.$$$reportNull$$$0(19);
            }
            return introspectionScope;
        }
        if (scope == IntrospectionScope.ALL_SCOPE) {
            IntrospectionScope introspectionScope = IntrospectionScope.ALL_SCOPE;
            if (introspectionScope == null) {
                IntrospectionScopes.$$$reportNull$$$0(20);
            }
            return introspectionScope;
        }
        Set<String> all = scope.allSchemas();
        if (all.size() != 1 || !all.contains("*")) {
            IntrospectionScope introspectionScope = scope;
            if (introspectionScope == null) {
                IntrospectionScopes.$$$reportNull$$$0(21);
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = IntrospectionScope.scopeOf("*", (Collection<String>)ImmutableSet.copyOf(scope.databases()));
        if (introspectionScope == null) {
            IntrospectionScopes.$$$reportNull$$$0(22);
        }
        return introspectionScope;
    }

    @NotNull
    public static String[] splitSchemaPattern(@NotNull String schemaPattern) {
        String[] stringArray;
        if (schemaPattern == null) {
            IntrospectionScopes.$$$reportNull$$$0(23);
        }
        if (StringUtil.isEmptyOrSpaces((String)schemaPattern)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = schemaPattern.split("[\\s,]+");
        }
        String[] strings = stringArray;
        for (int i2 = 0; i2 < strings.length; ++i2) {
            strings[i2] = strings[i2].replaceAll("&nbsp;", " ").replaceAll("&amp;", "&");
        }
        if (strings == null) {
            IntrospectionScopes.$$$reportNull$$$0(24);
        }
        return strings;
    }

    public static IntrospectionScope union(IntrospectionScope s1, IntrospectionScope s2) {
        MultiMap map = MultiMap.createLinkedSet();
        for (String db : s1.databases()) {
            map.getModifiable((Object)db).addAll(s1.schemas(db));
        }
        boolean added = false;
        for (String db : s2.databases()) {
            added |= !map.containsKey((Object)db);
            added |= map.getModifiable((Object)db).addAll(s2.schemas(db));
        }
        return added ? IntrospectionScopes.scopeOf((MultiMap<String, String>)map) : s1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databasesAndSchemas";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/IntrospectionScopes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/IntrospectionScopes";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "scopeOf";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "pairsToMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collapse";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "importScope";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fromSchemaPattern";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "invertIf";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "splitSchemaPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scopeOf";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "pairsToMap";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collapse";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invertIf";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "splitSchemaPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

