/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;

public class HsqlDomains
extends DomainRegistry {
    private static final int MAX_VARCHAR = 8000;
    private static final int MAX_FRACTION = 6;
    private static final int MAX_CHAR = 255;

    public HsqlDomains() {
        this.add(new Number2Domain("numeric", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true));
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true));
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, 8000L, -1L, true));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new BinaryDomain("varbinary", ConversionPoint.VARBINARY, 8000L, TextDomain.Length.mandatory(8000L)));
        this.add(new BooleanDomain("bit", ConversionPoint.BOOLEAN));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add(new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 6, -1, true));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, -1, true));
        this.add(new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("longvarchar", ConversionPoint.TEXT, Integer.MAX_VALUE, -1L, true));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 255L, 1L, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, 255L, 1L, true));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 32767L, TextDomain.Length.mandatory(32767L)));
        this.add(new TextDomain("character varying", ConversionPoint.VARCHAR, 32767L, -1L, true));
    }
}

