/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.fix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RefactoringQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringFactory;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RenameFix
extends InspectionJSFix
implements RefactoringQuickFix {
    private final String m_targetName;

    public RenameFix() {
        this.m_targetName = null;
    }

    public RenameFix(String targetName) {
        this.m_targetName = targetName;
    }

    @NotNull
    public String getName() {
        if (this.m_targetName == null) {
            String string = InspectionJSBundle.message("rename.fix", new Object[0]);
            if (string == null) {
                RenameFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("rename.to.fix", this.m_targetName);
        if (string == null) {
            RenameFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = InspectionJSBundle.message("rename.fix", new Object[0]);
        if (string == null) {
            RenameFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor2) {
        if (this.m_targetName == null) {
            this.doFix(descriptor2.getPsiElement());
        } else {
            PsiElement elementToRename = descriptor2.getPsiElement().getParent();
            RefactoringFactory.getInstance((Project)project).createRename(elementToRename, this.m_targetName).run();
        }
    }

    @NotNull
    public RefactoringActionHandler getHandler() {
        RefactoringActionHandler refactoringActionHandler = RefactoringActionHandlerFactory.getInstance().createRenameHandler();
        if (refactoringActionHandler == null) {
            RenameFix.$$$reportNull$$$0(3);
        }
        return refactoringActionHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/fix/RenameFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

