/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSStringConcatenationToES6TemplateQuickFix;
import com.intellij.lang.javascript.intentions.ES6ConvertToTemplateStringHelper;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSStringConcatenationToES6TemplateHelper;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSStringConcatenationToES6TemplateInspection
extends JSInspection
implements ES6CoolRefactoring {
    public static final Key<Set<PsiElement>> KEY = Key.create((String)"JavaScript.String.Concat.To.Template.String");

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSStringConcatenationToES6TemplateInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSStringConcatenationToES6TemplateInspection.$$$reportNull$$$0(1);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)node)) {
                    return;
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)node, JSStringTemplateExpression.class) != null) {
                    return;
                }
                HashSet<JSExpression> data = (HashSet<JSExpression>)session.getUserData(KEY);
                if (data == null) {
                    data = new HashSet<JSExpression>();
                    session.putUserData(KEY, data);
                }
                if (data.contains(node)) {
                    return;
                }
                List<JSExpression> list = JSStringConcatenationToES6TemplateHelper.findExpressionsList((PsiElement)node);
                if (list == null) {
                    return;
                }
                Collections.reverse(list);
                boolean found = false;
                for (JSExpression expression : list) {
                    if (data.contains(expression)) {
                        return;
                    }
                    if (!found) {
                        ES6ConvertToTemplateStringHelper helper = new ES6ConvertToTemplateStringHelper(expression);
                        helper.process();
                        if (helper.isValid()) {
                            found = true;
                            holder.registerProblem((PsiElement)expression, JSBundle.message((String)"js.replace.string.concatenation.with.es6.template.inspection.name", (Object[])new Object[0]), new LocalQuickFix[]{new JSStringConcatenationToES6TemplateQuickFix((JSExpression)node)});
                        }
                    }
                    data.add(expression);
                }
            }
        };
        if (jSElementVisitor == null) {
            JSStringConcatenationToES6TemplateInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSStringConcatenationToES6TemplateInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

