/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageUtil {
    public static final List<Language> LANGUAGES_WITH_JAVA_SCRIPT_FORMATTER_SETTINGS = Arrays.asList(new Language[]{JavaScriptSupportLoader.ECMA_SCRIPT_6, JavaScriptSupportLoader.GWT_DIALECT});
    private static final NotNullLazyValue<Collection<FileType>> FILE_TYPES_COMPILABLE_TO_JAVASCRIPT = new NotNullLazyValue<Collection<FileType>>(){

        @NotNull
        protected Collection<FileType> compute() {
            HashSet<FileType> fileTypes = new HashSet<FileType>();
            for (FileType type : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
                Language language;
                if (type == ActionScriptFileType.INSTANCE || !(type instanceof LanguageFileType) || !(language = ((LanguageFileType)type).getLanguage()).isKindOf((Language)JavascriptLanguage.INSTANCE)) continue;
                fileTypes.add(type);
            }
            if (fileTypes.isEmpty()) {
                Logger.getInstance(JavaScriptFileType.class).error("No file types compilable to JavaScript");
            }
            fileTypes.addAll(TypeScriptUtil.TYPESCRIPT_FILE_TYPES);
            fileTypes.addAll(DialectDetector.JAVASCRIPT_FILE_TYPES);
            Collection<FileType> collection = Collections.unmodifiableCollection(fileTypes);
            if (collection == null) {
                1.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLanguageUtil$1", "compute"));
        }
    };

    @NotNull
    public static Language getLanguageDialect(PsiElement element) {
        Language language = JSLanguageUtil.getLanguageDialect(element, element.getTextOffset());
        if (language == null) {
            JSLanguageUtil.$$$reportNull$$$0(0);
        }
        return language;
    }

    @NotNull
    public static Language getLanguageDialect(PsiElement element, int startOffset) {
        PsiFile psiFile = element instanceof PsiFile ? (PsiFile)element : element.getContainingFile();
        Language dialect = psiFile.getLanguage();
        if (dialect == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            Language language = dialect;
            if (language == null) {
                JSLanguageUtil.$$$reportNull$$$0(1);
            }
            return language;
        }
        if (!(dialect instanceof JSLanguageDialect) && dialect.isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            Language language = dialect;
            if (language == null) {
                JSLanguageUtil.$$$reportNull$$$0(2);
            }
            return language;
        }
        dialect = DialectDetector.languageOfElement((PsiElement)psiFile);
        if (!(dialect instanceof JSLanguageDialect)) {
            dialect = JSLanguageUtil.getLanguage(psiFile, startOffset);
        }
        if (!(dialect instanceof JSLanguageDialect) || LANGUAGES_WITH_JAVA_SCRIPT_FORMATTER_SETTINGS.contains(dialect)) {
            dialect = JavascriptLanguage.INSTANCE;
        }
        Language language = dialect;
        if (language == null) {
            JSLanguageUtil.$$$reportNull$$$0(3);
        }
        return language;
    }

    @Nullable
    public static Language getLanguage(PsiFile file2, int offset) {
        PsiElement at = file2.findElementAt(offset);
        if (at == null && offset == file2.getTextLength()) {
            at = file2.findElementAt(offset - 1);
        }
        return JSLanguageUtil.getLanguage(at);
    }

    @Nullable
    public static Language getLanguage(@Nullable PsiElement element) {
        PsiLanguageInjectionHost host;
        Language language;
        Language language2 = language = element != null ? element.getParent().getLanguage() : null;
        if (language != null && (host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLanguageInjectionHost.class, (boolean)false)) != null) {
            final Ref injectedLanguageRef = new Ref();
            InjectedLanguageManager.getInstance((Project)host.getProject()).enumerateEx((PsiElement)host, element.getContainingFile(), false, (PsiLanguageInjectionHost.InjectedPsiVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

                @Override
                protected void process(JSFile file2) {
                    injectedLanguageRef.set((Object)file2.getLanguage());
                }
            });
            if (!injectedLanguageRef.isNull()) {
                language = (Language)injectedLanguageRef.get();
            }
        }
        return language;
    }

    @NotNull
    public static Language getLanguageForParser(@NotNull PsiElement psi) {
        Language language;
        if (psi == null) {
            JSLanguageUtil.$$$reportNull$$$0(4);
        }
        if (!((language = psi.getLanguage()) instanceof JSLanguageDialect)) {
            JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(psi);
            if (dialect == null) {
                PsiFile file2 = psi.getContainingFile();
                VirtualFile virtualFile = file2.getVirtualFile();
                if (virtualFile == null) {
                    virtualFile = (VirtualFile)IndexingDataKeys.VIRTUAL_FILE.get((UserDataHolder)file2);
                }
                if (virtualFile == null) {
                    virtualFile = file2.getViewProvider().getVirtualFile();
                }
                dialect = DialectDetector.getLanguageDialect(virtualFile, psi.getProject());
            }
            if (dialect != null) {
                JSLanguageDialect jSLanguageDialect = dialect;
                if (jSLanguageDialect == null) {
                    JSLanguageUtil.$$$reportNull$$$0(5);
                }
                return jSLanguageDialect;
            }
        }
        Language language2 = language;
        if (language2 == null) {
            JSLanguageUtil.$$$reportNull$$$0(6);
        }
        return language2;
    }

    @NotNull
    public static Collection<FileType> getFileTypesCompilableToJavaScript() {
        Collection collection = (Collection)FILE_TYPES_COMPILABLE_TO_JAVASCRIPT.getValue();
        if (collection == null) {
            JSLanguageUtil.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSLanguageUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageDialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSLanguageUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageForParser";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesCompilableToJavaScript";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForParser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

