/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.codeInsight;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.codeInsight.HttpRequestDiffAction;
import com.intellij.ws.http.request.psi.HttpDifferenceFile;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestElementTypes;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestDiffLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @Nullable
    public String getName() {
        return RestClientBundle.message("http.request.diff.line.marker.provider", new Object[0]);
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestDiffLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!HttpRequestPsiUtils.isOfType(element, HttpRequestElementTypes.DIFFERENCE_SIGN)) {
            return null;
        }
        List<HttpDifferenceFile> diffFiles = HttpRequestDiffLineMarkerProvider.getDiffFiles(element);
        if (diffFiles.size() > 1) {
            HttpDifferenceFile diffFile = (HttpDifferenceFile)PsiTreeUtil.getParentOfType((PsiElement)element, HttpDifferenceFile.class);
            HttpFilePath filePath = diffFile != null ? diffFile.getFilePath() : null;
            return filePath != null ? new HttpRequestLineMarkerInfo(diffFile, element) : null;
        }
        return null;
    }

    @NotNull
    private static List<HttpDifferenceFile> getDiffFiles(@NotNull PsiElement element) {
        HttpRequest request;
        if (element == null) {
            HttpRequestDiffLineMarkerProvider.$$$reportNull$$$0(1);
        }
        List<HttpDifferenceFile> list = (request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)element, HttpRequest.class)) != null ? request.getDifferenceFileList() : ContainerUtil.emptyList();
        if (list == null) {
            HttpRequestDiffLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            HttpRequestDiffLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            HttpRequestDiffLineMarkerProvider.$$$reportNull$$$0(4);
        }
    }

    private static ActionGroup computePopup(@NotNull HttpDifferenceFile fileHolder) {
        if (fileHolder == null) {
            HttpRequestDiffLineMarkerProvider.$$$reportNull$$$0(5);
        }
        DefaultActionGroup result = new DefaultActionGroup();
        List<HttpDifferenceFile> files = HttpRequestDiffLineMarkerProvider.getDiffFiles((PsiElement)fileHolder);
        if (files.size() < 2) {
            return result;
        }
        HttpFilePath filePath = fileHolder.getFilePath();
        if (filePath != null) {
            files.stream().filter(file -> {
                if (fileHolder == null) {
                    HttpRequestDiffLineMarkerProvider.$$$reportNull$$$0(6);
                }
                return file != fileHolder;
            }).map(file -> file.getFilePath()).filter(Objects::nonNull).forEach(secondFilePath -> result.addAction((AnAction)new HttpRequestDiffAction(filePath, (HttpFilePath)secondFilePath)));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/codeInsight/HttpRequestDiffLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/codeInsight/HttpRequestDiffLineMarkerProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDiffFiles";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computePopup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computePopup$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HttpRequestLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final HttpDifferenceFile myFileHolder;

        HttpRequestLineMarkerInfo(@NotNull HttpDifferenceFile fileHolder, @NotNull PsiElement element) {
            if (fileHolder == null) {
                HttpRequestLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (element == null) {
                HttpRequestLineMarkerInfo.$$$reportNull$$$0(1);
            }
            super(element, element.getTextRange(), AllIcons.Actions.Diff, 11, e -> RestClientBundle.message("http.request.diff.compare.with", new Object[0]), null, GutterIconRenderer.Alignment.CENTER);
            this.myFileHolder = fileHolder;
        }

        @NotNull
        public GutterIconRenderer createGutterRenderer() {
            LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement> lineMarkerGutterIconRenderer = new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }

                public boolean isNavigateAction() {
                    return false;
                }

                @Nullable
                public ActionGroup getPopupMenuActions() {
                    return HttpRequestDiffLineMarkerProvider.computePopup(myFileHolder);
                }
            };
            if (lineMarkerGutterIconRenderer == null) {
                HttpRequestLineMarkerInfo.$$$reportNull$$$0(2);
            }
            return lineMarkerGutterIconRenderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/http/request/codeInsight/HttpRequestDiffLineMarkerProvider$HttpRequestLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/http/request/codeInsight/HttpRequestDiffLineMarkerProvider$HttpRequestLineMarkerInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createGutterRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

