/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.application;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.actions.RemoveLocallyFileOrDirectoryAction;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextAdapter;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsStorageSupportingDeletionComponent;
import com.intellij.cvsSupport2.application.DeletedCVSDirectoryStorage;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

class DeleteHandler {
    private final Collection<String> myDeletedFiles = new HashSet<String>();
    private final Collection<VirtualFile> myDeletedFilesParents = new HashSet<VirtualFile>();
    private final Project myProject;
    private final CvsStorageSupportingDeletionComponent myCvsStorageComponent;
    private final Collection<File> myFilesToDeleteEntry = new ArrayList<File>();

    DeleteHandler(Project project, CvsStorageSupportingDeletionComponent cvsStorageComponent) {
        this.myProject = project;
        this.myCvsStorageComponent = cvsStorageComponent;
    }

    public void execute() {
        if (CvsVcs2.getInstance(this.myProject).getRemoveConfirmation().getValue() != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            if (!this.myCvsStorageComponent.getIsActive()) {
                return;
            }
            this.removeFiles();
        }
        for (VirtualFile myDeletedFilesParent : this.myDeletedFilesParents) {
            myDeletedFilesParent.refresh(true, true);
        }
    }

    private void removeFiles() {
        for (File file : this.myFilesToDeleteEntry) {
            if (file.exists()) continue;
            CvsUtil.removeEntryFor(file);
        }
        if (this.myDeletedFiles.isEmpty()) {
            return;
        }
        for (String s : this.myDeletedFiles) {
            FileUtil.delete((File)new File(s));
        }
        CvsContextAdapter context = new CvsContextAdapter(){

            @Override
            public Project getProject() {
                return DeleteHandler.this.myProject;
            }

            @Override
            public Collection<String> getDeletedFileNames() {
                return DeleteHandler.this.myDeletedFiles;
            }
        };
        RemoveLocallyFileOrDirectoryAction.createAutomaticallyAction().setAutoSave(false).actionPerformed(context);
    }

    private void collectAllDeletedFilesFrom(VirtualFile directory) {
        VirtualFile[] children = directory.getChildren();
        if (children == null) {
            return;
        }
        for (VirtualFile child : children) {
            if (!child.isDirectory() && CvsUtil.fileIsUnderCvs(child)) {
                this.addFile(child);
                continue;
            }
            if (DeletedCVSDirectoryStorage.isAdminDir(child)) continue;
            this.collectAllDeletedFilesFrom(child);
        }
    }

    public void addDeletedRoot(VirtualFile file) {
        this.myDeletedFilesParents.add(file.getParent());
        if (file.isDirectory()) {
            this.collectAllDeletedFilesFrom(file);
        } else if (CvsUtil.fileIsUnderCvs(file) && !CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(file.getParent()).isOffline()) {
            this.addFile(file);
        }
    }

    public void removeDeletedRoot(VirtualFile file) {
        this.myDeletedFilesParents.remove(file.getParent());
        this.myDeletedFiles.remove(file.getPath());
        this.myFilesToDeleteEntry.remove(CvsVfsUtil.getFileFor(file));
    }

    private void addFile(VirtualFile file) {
        VirtualFile adminDirectoryForFile = file.getParent().findChild("CVS");
        if (adminDirectoryForFile != null && CvsUtil.fileIsUnderCvs(file)) {
            if (CvsUtil.fileExistsInCvs(file)) {
                this.myDeletedFiles.add(file.getPath());
            } else {
                this.myFilesToDeleteEntry.add(CvsVfsUtil.getFileFor(file));
            }
        }
    }
}

