/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGraphToggleAction
extends ToggleAction {
    private final Graph2D myGraph;

    public AbstractGraphToggleAction(Icon icon) {
        this(null, icon);
    }

    public AbstractGraphToggleAction(Graph2D graph, Icon icon) {
        super(null, null, icon);
        this.myGraph = graph;
    }

    @Nullable
    protected Graph2D getGraph(AnActionEvent e) {
        if (this.myGraph != null) {
            return this.myGraph;
        }
        return (Graph2D)e.getDataContext().getData(GraphViewUtil.GRAPH_KEY);
    }

    @Nullable
    protected GraphBuilder getBuilder(AnActionEvent e) {
        return (GraphBuilder)((Object)e.getDataContext().getData(GraphBuilder.GRAPH_BUILDER_KEY));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        Graph2D graph = this.getGraph(e);
        Project project = AbstractGraphToggleAction.getEventProject((AnActionEvent)e);
        if (graph != null && project != null) {
            super.update(e);
            presentation.setText(this.getText(graph));
        }
        presentation.setEnabled(graph != null && project != null && this.isEnabled(graph, project, e));
    }

    protected boolean isEnabled(Graph2D graph, Project project, AnActionEvent event) {
        return true;
    }

    public final boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(1);
        }
        Project project = AbstractGraphToggleAction.getEventProject((AnActionEvent)e);
        Graph2D graph = this.getGraph(e);
        return graph != null && project != null && this.isSelected(graph, project, e);
    }

    public final void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            AbstractGraphToggleAction.$$$reportNull$$$0(2);
        }
        Graph2D graph = this.getGraph(e);
        Project project = AbstractGraphToggleAction.getEventProject((AnActionEvent)e);
        if (graph != null && project != null) {
            this.setSelected(graph, state, project, e);
        }
    }

    protected abstract boolean isSelected(Graph2D var1, Project var2, AnActionEvent var3);

    protected abstract void setSelected(Graph2D var1, boolean var2, Project var3, AnActionEvent var4);

    protected abstract String getText(@NotNull Graph2D var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/AbstractGraphToggleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

