/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.rearranger;

import com.intellij.lang.css.rearranger.CssArrangementEntry;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CssArrangementVisitor
extends CssElementVisitor {
    private final Collection<TextRange> myRanges;
    private final List<CssArrangementEntry> myTopLevelEntries;
    @NotNull
    private final Stack<CssArrangementEntry> myStack;
    private final boolean mySortByName;

    CssArrangementVisitor(@NotNull Collection<TextRange> ranges, boolean sortByName) {
        if (ranges == null) {
            CssArrangementVisitor.$$$reportNull$$$0(0);
        }
        this.myTopLevelEntries = new SmartList();
        this.myStack = new Stack();
        this.myRanges = ranges;
        this.mySortByName = sortByName;
    }

    public void visitCssStylesheet(@NotNull CssStylesheet stylesheet) {
        if (stylesheet == null) {
            CssArrangementVisitor.$$$reportNull$$$0(1);
        }
        this.visitCssRulesetList(stylesheet.getRulesetList());
    }

    public void visitCssRulesetList(CssRulesetList rulesetList) {
        for (CssRuleset ruleset : rulesetList.getRulesets(true)) {
            this.visitCssRuleset(ruleset);
        }
    }

    public void visitCssMedia(@NotNull CssMedia media) {
        if (media == null) {
            CssArrangementVisitor.$$$reportNull$$$0(2);
        }
        for (CssRuleset ruleset : media.getRulesets()) {
            this.visitCssRuleset(ruleset);
        }
    }

    public void visitAtRule(@NotNull CssAtRule atRule) {
        if (atRule == null) {
            CssArrangementVisitor.$$$reportNull$$$0(3);
        }
        if (atRule instanceof CssMedia) {
            this.visitCssMedia((CssMedia)atRule);
        }
    }

    public void visitCssRuleset(@NotNull CssRuleset ruleset) {
        CssBlock block;
        if (ruleset == null) {
            CssArrangementVisitor.$$$reportNull$$$0(4);
        }
        if ((block = ruleset.getBlock()) != null) {
            this.visitCssBlock(block);
        }
    }

    public void visitCssBlock(@NotNull CssBlock block) {
        if (block == null) {
            CssArrangementVisitor.$$$reportNull$$$0(5);
        }
        if (!CssArrangementVisitor.isWithinBounds(block.getTextRange(), this.myRanges)) {
            return;
        }
        CssArrangementEntry entry = this.createNewEntry(block.getTextRange(), null);
        this.myStack.push((Object)entry);
        try {
            block.acceptChildren((PsiElementVisitor)this);
        }
        finally {
            this.myStack.pop();
        }
    }

    public void visitCssDeclaration(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            CssArrangementVisitor.$$$reportNull$$$0(6);
        }
        this.createNewEntry(declaration.getTextRange(), declaration.getPropertyName());
    }

    @NotNull
    private CssArrangementEntry createNewEntry(@NotNull TextRange range, @Nullable String propertyName) {
        if (range == null) {
            CssArrangementVisitor.$$$reportNull$$$0(7);
        }
        CssArrangementEntry currentEntry = this.getCurrent();
        CssArrangementEntry entry = new CssArrangementEntry(propertyName, (ArrangementEntry)currentEntry, range, this.mySortByName);
        if (currentEntry == null) {
            this.myTopLevelEntries.add(entry);
        } else {
            currentEntry.addChild((ArrangementEntry)entry);
        }
        CssArrangementEntry cssArrangementEntry = entry;
        if (cssArrangementEntry == null) {
            CssArrangementVisitor.$$$reportNull$$$0(8);
        }
        return cssArrangementEntry;
    }

    @Nullable
    private CssArrangementEntry getCurrent() {
        return this.myStack.isEmpty() ? null : (CssArrangementEntry)((Object)this.myStack.peek());
    }

    List<CssArrangementEntry> getTopLevelEntries() {
        return this.myTopLevelEntries;
    }

    private static boolean isWithinBounds(@NotNull TextRange range, @NotNull Collection<TextRange> ranges) {
        if (range == null) {
            CssArrangementVisitor.$$$reportNull$$$0(9);
        }
        if (ranges == null) {
            CssArrangementVisitor.$$$reportNull$$$0(10);
        }
        return ContainerUtil.or(ranges, r -> {
            if (range == null) {
                CssArrangementVisitor.$$$reportNull$$$0(11);
            }
            return r.intersects(range);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "media";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atRule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleset";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/rearranger/CssArrangementVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/rearranger/CssArrangementVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitCssStylesheet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitCssMedia";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitAtRule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitCssRuleset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitCssBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitCssDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewEntry";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isWithinBounds";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isWithinBounds$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

