/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy.entry;

import java.lang.reflect.Constructor;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.jetty.policy.PolicyContext;
import org.eclipse.jetty.policy.PolicyException;
import org.eclipse.jetty.policy.entry.AbstractEntry;

public class PermissionEntry
extends AbstractEntry {
    private String klass;
    private String name;
    private String actions;
    private String signers;
    private Certificate[] signerArray;

    public Permission toPermission() throws PolicyException {
        try {
            Class<?> clazz = Class.forName(this.klass);
            if (this.signerArray != null && !PermissionEntry.validate(this.signerArray, (Certificate[])clazz.getSigners())) {
                throw new PolicyException("Unvalidated Permissions: " + this.klass + "/" + this.name);
            }
            Permission permission = null;
            if (this.name == null && this.actions == null) {
                permission = (Permission)clazz.newInstance();
            } else if (this.name != null && this.actions == null) {
                Constructor<?> c = clazz.getConstructor(String.class);
                permission = (Permission)c.newInstance(this.name);
            } else if (this.name != null && this.actions != null) {
                Constructor<?> c = clazz.getConstructor(String.class, String.class);
                permission = (Permission)c.newInstance(this.name, this.actions);
            }
            return permission;
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }

    public void expand(PolicyContext context) throws PolicyException {
        if (this.name != null) {
            this.name = context.evaluate(this.name).trim();
        }
        if (this.actions != null) {
            this.actions = context.evaluate(this.actions).trim();
        }
        if (this.signers != null) {
            this.signerArray = PermissionEntry.resolveCertificates(context.getKeystore(), this.signers);
        }
        this.setExpanded(true);
    }

    private static boolean validate(Certificate[] permCerts, Certificate[] classCerts) {
        if (classCerts == null) {
            return false;
        }
        for (int i = 0; i < permCerts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < classCerts.length; ++j) {
                if (!permCerts[i].equals(classCerts[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static Certificate[] resolveCertificates(KeyStore keyStore, String signers) throws PolicyException {
        if (keyStore == null) {
            Certificate[] certs = null;
            return certs;
        }
        HashSet<Certificate> certificateSet = new HashSet<Certificate>();
        StringTokenizer strTok = new StringTokenizer(signers, ",");
        int i = 0;
        while (strTok.hasMoreTokens()) {
            try {
                Certificate certificate = keyStore.getCertificate(strTok.nextToken().trim());
                if (certificate != null) {
                    certificateSet.add(certificate);
                }
            }
            catch (KeyStoreException kse) {
                throw new PolicyException(kse);
            }
            ++i;
        }
        return certificateSet.toArray(new Certificate[certificateSet.size()]);
    }

    public String getKlass() {
        return this.klass;
    }

    public void setKlass(String klass) {
        this.klass = klass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getActions() {
        return this.actions;
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public String getSigners() {
        return this.signers;
    }

    public void setSigners(String signers) {
        this.signers = signers;
    }
}

