// -*- c++ -*-
//
// Software License for MTL
// 
// Copyright (c) 2001-2005 The Trustees of Indiana University. All rights reserved.
// Copyright (c) 1998-2001 University of Notre Dame. All rights reserved.
// Authors: Andrew Lumsdaine, Jeremy G. Siek, Lie-Quan Lee
// 
// This file is part of the Matrix Template Library
// 
// See also license.mtl.txt in the distribution.
// $Id: geequ.cc,v 1.2 2000/08/28 15:22:59 jsiek Exp $
//


#include "mtl/mtl2lapack.h"
#include "mtl/dense1D.h"
#include "mtl/utils.h"


/*
  Sample Output

  3x3
  [
  [2,4,8],
  [2,8,16],
  [2,16,32]
  ]
  Row scale factors:
  [0.125,0.0625,0.03125,]
  Column scale factors:
  [4,2,1,]
  Scaled A:
  3x3
  [
  [1,1,1],
  [0.5,1,1],
  [0.25,1,1]
  ]
  
  */

int
main()
{
  const int N = 3;
  using namespace mtl;
  //begin
  double da [] = { 2, 2, 2, 4, 8, 16, 8, 16, 32 };
  mtl2lapack::lapack_matrix<double,external>::type A(da, N, N);
  double rowcond, colcond;
  double amax;
  dense1D<double> rowsca(N), colsca(N);
  int info;
  //end
  print_all_matrix(A);

  // Compute and print the scale factors that will
  //   equilibrate A

  //begin
  info = mtl2lapack::geequ(A, rowsca, colsca, rowcond, colcond, amax); 

  if (info > N) {
    std::cout << "Column " << info - N << " of A is exactly zero." << std::endl;
    return 0;
  } else if (info > 0)
    std::cout << "Row " << info << " of A is exactly zero." << std::endl;
  //end
  std::cout << "Row scale factors:" << std::endl;
  print_vector(rowsca);

  std::cout << "Column scale factors:" << std::endl;
  print_vector(colsca);

  // Use the scale factors to equilibrate A and print
  //   the equilibrated A.

  for (int i = 0; i < N; ++i)
    for (int j = 0; j < N; ++j)
      A(i,j) *= rowsca[i] * colsca[j];

  std::cout << "Scaled A:" << std::endl;
  print_all_matrix(A);

  return 0;
}
