/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro.tool;

import java.awt.Color;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;
import net.bluecow.spectro.tool.Tool;
import net.bluecow.spectro.tool.ToolboxPanel;

public class ToolButton
extends JRadioButton {
    private final Tool tool;

    public ToolButton(Tool tool, String iconName, ButtonGroup group) {
        super(ToolButton.loadIcon(iconName));
        this.tool = tool;
        group.add(this);
    }

    private static Icon loadIcon(String name) {
        URL resourceUrl = ToolboxPanel.class.getResource("/icons/" + name + ".png");
        if (resourceUrl == null) {
            throw new RuntimeException("Missing icon resource: " + name);
        }
        return new ImageIcon(resourceUrl);
    }

    public Tool getTool() {
        return this.tool;
    }

    protected void paintComponent(Graphics g) {
        if (this.isSelected()) {
            g.setColor(Color.RED);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.getIcon().paintIcon(this, g, this.getWidth() / 2 - this.getIcon().getIconWidth() / 2, this.getHeight() / 2 - this.getIcon().getIconHeight() / 2);
    }
}

