/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import net.bluecow.spectro.ClipPanel;

public class PositionReadout {
    private final ClipPanel cp;
    private final JLabel label = new JLabel();
    private final MouseHandler mouseHandler = new MouseHandler();

    public PositionReadout(ClipPanel cp) {
        this.cp = cp;
        cp.addMouseMotionListener(this.mouseHandler);
        cp.addMouseListener(this.mouseHandler);
        this.mouseHandler.mouseExited(null);
    }

    private static String toNoteName(double freq) {
        int semitones = (int)(48.0 + 12.0 * PositionReadout.log2(freq / 440.0));
        String[] notes = new String[]{"A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#"};
        String note = notes[semitones % 12];
        String octave = String.valueOf(semitones / 12);
        return note + octave;
    }

    private static double log2(double a) {
        return Math.log(a) / Math.log(2.0);
    }

    public JLabel getLabel() {
        return this.label;
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }

        public void mouseMoved(MouseEvent e) {
            double rate = PositionReadout.this.cp.getClip().getSamplingRate();
            double fSamples = PositionReadout.this.cp.getClip().getFrameFreqSamples();
            double tSamples = PositionReadout.this.cp.getClip().getFrameTimeSamples();
            Point p = PositionReadout.this.cp.toClipCoords(e.getPoint());
            double freq = rate / 2.0 / fSamples * p.getY();
            PositionReadout.this.label.setText(String.format("0:%06.03fs %6.0fHz (%s)", p.getX() * tSamples / rate, freq, PositionReadout.toNoteName(freq)));
            PositionReadout.this.label.setEnabled(true);
        }

        public void mouseExited(MouseEvent e) {
            PositionReadout.this.label.setText("(No current position)");
            PositionReadout.this.label.setEnabled(false);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

