/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckFloatFFT {
    private AccuracyCheckFloatFFT() {
    }

    public static void checkAccuracyComplexFFT_1D(int n, int n2) {
        System.out.println("Checking accuracy of 1D complex FFT...");
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            int n4 = (int)Math.pow(2.0, n3);
            FloatFFT_1D floatFFT_1D = new FloatFFT_1D(n4);
            float f = 0.0f;
            float[] fArray = new float[2 * n4];
            IOUtils.fillMatrix_1D(2 * n4, fArray);
            float[] fArray2 = new float[2 * n4];
            IOUtils.fillMatrix_1D(2 * n4, fArray2);
            floatFFT_1D.complexForward(fArray);
            floatFFT_1D.complexInverse(fArray, true);
            for (int j = 0; j < 2 * n4; ++j) {
                float f2 = Math.abs(fArray2[j] - fArray[j]);
                f = Math.max(f, f2);
            }
            if ((double)f > 1.0E-5) {
                System.err.println("\tsize = 2^" + n3 + ";\terror = " + f);
            } else {
                System.out.println("\tsize = 2^" + n3 + ";\terror = " + f);
            }
            fArray = null;
            fArray2 = null;
            floatFFT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyComplexFFT_2D(int n, int n2) {
        float f;
        int n3;
        Object object;
        Object object2;
        float f2;
        FloatFFT_2D floatFFT_2D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 2D complex FFT (float[] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatFFT_2D = new FloatFFT_2D(n4, n4);
            f2 = 0.0f;
            object2 = new float[2 * n4 * n4];
            IOUtils.fillMatrix_2D(n4, 2 * n4, object2);
            object = new float[2 * n4 * n4];
            IOUtils.fillMatrix_2D(n4, 2 * n4, object);
            floatFFT_2D.complexForward((float[])object2);
            floatFFT_2D.complexInverse((float[])object2, true);
            for (n3 = 0; n3 < 2 * n4 * n4; ++n3) {
                f = Math.abs(object[n3] - object2[n3]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D complex FFT (float[][] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatFFT_2D = new FloatFFT_2D(n4, n4);
            f2 = 0.0f;
            object2 = new float[n4][2 * n4];
            IOUtils.fillMatrix_2D(n4, 2 * n4, (float[][])object2);
            object = new float[n4][2 * n4];
            IOUtils.fillMatrix_2D(n4, 2 * n4, (float[][])object);
            floatFFT_2D.complexForward((float[][])object2);
            floatFFT_2D.complexInverse((float[][])object2, true);
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < 2 * n4; ++i) {
                    f = Math.abs((float)(object[n3][i] - object2[n3][i]));
                    f2 = Math.max(f2, f);
                }
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyComplexFFT_3D(int n, int n2) {
        float f;
        int n3;
        Object object;
        Object object2;
        float f2;
        FloatFFT_3D floatFFT_3D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 3D complex FFT (float[] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatFFT_3D = new FloatFFT_3D(n4, n4, n4);
            f2 = 0.0f;
            object2 = new float[2 * n4 * n4 * n4];
            IOUtils.fillMatrix_3D(n4, n4, 2 * n4, object2);
            object = new float[2 * n4 * n4 * n4];
            IOUtils.fillMatrix_3D(n4, n4, 2 * n4, object);
            floatFFT_3D.complexForward((float[])object2);
            floatFFT_3D.complexInverse((float[])object2, true);
            for (n3 = 0; n3 < 2 * n4 * n4 * n4; ++n3) {
                f = Math.abs(object[n3] - object2[n3]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D complex FFT (float[][][] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatFFT_3D = new FloatFFT_3D(n4, n4, n4);
            f2 = 0.0f;
            object2 = new float[n4][n4][2 * n4];
            IOUtils.fillMatrix_3D(n4, n4, 2 * n4, (float[][][])object2);
            object = new float[n4][n4][2 * n4];
            IOUtils.fillMatrix_3D(n4, n4, 2 * n4, (float[][][])object);
            floatFFT_3D.complexForward((float[][][])object2);
            floatFFT_3D.complexInverse((float[][][])object2, true);
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < 2 * n4; ++j) {
                        f = Math.abs((float)(object[n3][i][j] - object2[n3][i][j]));
                        f2 = Math.max(f2, f);
                    }
                }
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_1D(int n, int n2) {
        float f;
        int n3;
        float[] fArray;
        float[] fArray2;
        float f2;
        FloatFFT_1D floatFFT_1D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 1D real FFT...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatFFT_1D = new FloatFFT_1D(n4);
            f2 = 0.0f;
            fArray2 = new float[n4];
            IOUtils.fillMatrix_1D(n4, fArray2);
            fArray = new float[n4];
            IOUtils.fillMatrix_1D(n4, fArray);
            floatFFT_1D.realForward(fArray);
            floatFFT_1D.realInverse(fArray, true);
            for (n3 = 0; n3 < n4; ++n3) {
                f = Math.abs(fArray[n3] - fArray2[n3]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n5 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + ";\terror = " + f2);
            }
            fArray2 = null;
            fArray = null;
            floatFFT_1D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of on 1D real forward full FFT...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatFFT_1D = new FloatFFT_1D(n4);
            f2 = 0.0f;
            fArray2 = new float[2 * n4];
            IOUtils.fillMatrix_1D(n4, fArray2);
            fArray = new float[2 * n4];
            IOUtils.fillMatrix_1D(n4, fArray);
            floatFFT_1D.realForwardFull(fArray);
            floatFFT_1D.complexInverse(fArray, true);
            for (n3 = 0; n3 < n4; ++n3) {
                f = Math.abs(fArray[2 * n3] - fArray2[n3]);
                f2 = Math.max(f2, f);
                f = Math.abs(fArray[2 * n3 + 1]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n5 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + ";\terror = " + f2);
            }
            fArray2 = null;
            fArray = null;
            floatFFT_1D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 1D real inverse full FFT...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            floatFFT_1D = new FloatFFT_1D(n4);
            f2 = 0.0f;
            fArray2 = new float[2 * n4];
            IOUtils.fillMatrix_1D(n4, fArray2);
            fArray = new float[2 * n4];
            IOUtils.fillMatrix_1D(n4, fArray);
            floatFFT_1D.realInverseFull(fArray, true);
            floatFFT_1D.complexForward(fArray);
            for (n3 = 0; n3 < n4; ++n3) {
                f = Math.abs(fArray[2 * n3] - fArray2[n3]);
                f2 = Math.max(f2, f);
                f = Math.abs(fArray[2 * n3 + 1]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n5 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n5 + ";\terror = " + f2);
            }
            fArray2 = null;
            fArray = null;
            floatFFT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_2D(int n, int n2) {
        int n3;
        float f;
        int n4;
        Object object;
        Object object2;
        float f2;
        FloatFFT_2D floatFFT_2D;
        int n5;
        int n6;
        int n7;
        System.out.println("Checking accuracy of 2D real FFT (float[] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            floatFFT_2D = new FloatFFT_2D(n5, n5);
            f2 = 0.0f;
            object2 = new float[n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object2);
            object = new float[n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object);
            floatFFT_2D.realForward((float[])object);
            floatFFT_2D.realInverse((float[])object, true);
            for (n4 = 0; n4 < n5 * n5; ++n4) {
                f = Math.abs(object[n4] - object2[n4]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real FFT (float[][] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            floatFFT_2D = new FloatFFT_2D(n5, n5);
            f2 = 0.0f;
            object2 = new float[n5][n5];
            IOUtils.fillMatrix_2D(n5, n5, (float[][])object2);
            object = new float[n5][n5];
            IOUtils.fillMatrix_2D(n5, n5, (float[][])object);
            floatFFT_2D.realForward((float[][])object);
            floatFFT_2D.realInverse((float[][])object, true);
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    f = Math.abs((float)(object[n4][n3] - object2[n4][n3]));
                    f2 = Math.max(f2, f);
                }
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (float[] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            floatFFT_2D = new FloatFFT_2D(n5, n5);
            f2 = 0.0f;
            object2 = new float[2 * n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object2);
            object = new float[2 * n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object);
            floatFFT_2D.realForwardFull((float[])object);
            floatFFT_2D.complexInverse((float[])object, true);
            for (n4 = 0; n4 < n5 * n5; ++n4) {
                f = Math.abs(object[2 * n4] - object2[n4]);
                f2 = Math.max(f2, f);
                f = Math.abs(object[2 * n4 + 1]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (float[][] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            floatFFT_2D = new FloatFFT_2D(n5, n5);
            f2 = 0.0f;
            object2 = new float[n5][n5];
            IOUtils.fillMatrix_2D(n5, n5, (float[][])object2);
            object = new float[n5][2 * n5];
            IOUtils.fillMatrix_2D(n5, n5, (float[][])object);
            floatFFT_2D.realForwardFull((float[][])object);
            floatFFT_2D.complexInverse((float[][])object, true);
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    f = Math.abs((float)(object[n4][2 * n3] - object2[n4][n3]));
                    f2 = Math.max(f2, f);
                    f = Math.abs((float)object[n4][2 * n3 + 1]);
                    f2 = Math.max(f2, f);
                }
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (float[] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            floatFFT_2D = new FloatFFT_2D(n5, n5);
            f2 = 0.0f;
            object2 = new float[2 * n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object2);
            object = new float[2 * n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object);
            floatFFT_2D.realInverseFull((float[])object, true);
            floatFFT_2D.complexForward((float[])object);
            for (n4 = 0; n4 < n5 * n5; ++n4) {
                f = Math.abs(object[2 * n4] - object2[n4]);
                f2 = Math.max(f2, f);
                f = Math.abs(object[2 * n4 + 1]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (float[][] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            floatFFT_2D = new FloatFFT_2D(n5, n5);
            f2 = 0.0f;
            object2 = new float[n5][n5];
            IOUtils.fillMatrix_2D(n5, n5, (float[][])object2);
            object = new float[n5][2 * n5];
            IOUtils.fillMatrix_2D(n5, n5, (float[][])object);
            floatFFT_2D.realInverseFull((float[][])object, true);
            floatFFT_2D.complexForward((float[][])object);
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    f = Math.abs((float)(object[n4][2 * n3] - object2[n4][n3]));
                    f2 = Math.max(f2, f);
                    f = Math.abs((float)object[n4][2 * n3 + 1]);
                    f2 = Math.max(f2, f);
                }
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_3D(int n, int n2) {
        int n3;
        int n4;
        float f;
        int n5;
        Object object;
        Object object2;
        float f2;
        FloatFFT_3D floatFFT_3D;
        int n6;
        int n7;
        int n8;
        System.out.println("Checking accuracy of 3D real FFT (float[] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            floatFFT_3D = new FloatFFT_3D(n6, n6, n6);
            f2 = 0.0f;
            object2 = new float[n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object2);
            object = new float[n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object);
            floatFFT_3D.realForward((float[])object);
            floatFFT_3D.realInverse((float[])object, true);
            for (n5 = 0; n5 < n6 * n6 * n6; ++n5) {
                f = Math.abs(object[n5] - object2[n5]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real FFT (float[][][] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            floatFFT_3D = new FloatFFT_3D(n6, n6, n6);
            f2 = 0.0f;
            object2 = new float[n6][n6][n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (float[][][])object2);
            object = new float[n6][n6][n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (float[][][])object);
            floatFFT_3D.realForward((float[][][])object);
            floatFFT_3D.realInverse((float[][][])object, true);
            for (n5 = 0; n5 < n6; ++n5) {
                for (n4 = 0; n4 < n6; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        f = Math.abs((float)(object[n5][n4][n3] - object2[n5][n4][n3]));
                        f2 = Math.max(f2, f);
                    }
                }
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (float[] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            floatFFT_3D = new FloatFFT_3D(n6, n6, n6);
            f2 = 0.0f;
            object2 = new float[2 * n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object2);
            object = new float[2 * n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object);
            floatFFT_3D.realForwardFull((float[])object);
            floatFFT_3D.complexInverse((float[])object, true);
            for (n5 = 0; n5 < n6 * n6 * n6; ++n5) {
                f = Math.abs(object[2 * n5] - object2[n5]);
                f2 = Math.max(f2, f);
                f = Math.abs(object[2 * n5 + 1]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (float[][][] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            floatFFT_3D = new FloatFFT_3D(n6, n6, n6);
            f2 = 0.0f;
            object2 = new float[n6][n6][2 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (float[][][])object2);
            object = new float[n6][n6][2 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (float[][][])object);
            floatFFT_3D.realForwardFull((float[][][])object);
            floatFFT_3D.complexInverse((float[][][])object, true);
            for (n5 = 0; n5 < n6; ++n5) {
                for (n4 = 0; n4 < n6; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        f = Math.abs((float)(object[n5][n4][2 * n3] - object2[n5][n4][n3]));
                        f2 = Math.max(f2, f);
                        f = Math.abs((float)object[n5][n4][2 * n3 + 1]);
                        f2 = Math.max(f2, f);
                    }
                }
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (float[] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            floatFFT_3D = new FloatFFT_3D(n6, n6, n6);
            f2 = 0.0f;
            object2 = new float[2 * n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object2);
            object = new float[2 * n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object);
            floatFFT_3D.realInverseFull((float[])object, true);
            floatFFT_3D.complexForward((float[])object);
            for (n5 = 0; n5 < n6 * n6 * n6; ++n5) {
                f = Math.abs(object[2 * n5] - object2[n5]);
                f2 = Math.max(f2, f);
                f = Math.abs(object[2 * n5 + 1]);
                f2 = Math.max(f2, f);
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (float[][][] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            floatFFT_3D = new FloatFFT_3D(n6, n6, n6);
            f2 = 0.0f;
            object2 = new float[n6][n6][2 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (float[][][])object2);
            object = new float[n6][n6][2 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (float[][][])object);
            floatFFT_3D.realInverseFull((float[][][])object, true);
            floatFFT_3D.complexForward((float[][][])object);
            for (n5 = 0; n5 < n6; ++n5) {
                for (n4 = 0; n4 < n6; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        f = Math.abs((float)(object[n5][n4][2 * n3] - object2[n5][n4][n3]));
                        f2 = Math.max(f2, f);
                        f = Math.abs((float)object[n5][n4][2 * n3 + 1]);
                        f2 = Math.max(f2, f);
                    }
                }
            }
            if ((double)f2 > 1.0E-5) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + f2);
            }
            object2 = null;
            object = null;
            floatFFT_3D = null;
            System.gc();
        }
    }

    public static void main(String[] stringArray) {
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_1D(0, 21);
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_1D(0, 21);
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_2D(1, 11);
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_2D(1, 11);
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_3D(1, 7);
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_3D(1, 7);
        System.exit(0);
    }
}

