/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.sablecc.sablecc.AcceptStates;
import org.sablecc.sablecc.ConstructNFA;
import org.sablecc.sablecc.DFA;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.NFA;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.Transitions;
import org.sablecc.sablecc.analysis.AnalysisAdapter;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.Start;

public class GenLexer
extends AnalysisAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    private AcceptStates[] acceptStatesArray;
    private Transitions transitions;

    public GenLexer(ResolveIds ids) {
        this.ids = ids;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("lexer.txt")));
        }
        catch (IOException e) {
            throw new RuntimeException("unable to open lexer.txt.");
        }
        this.pkgDir = new File(ids.pkgDir, "lexer");
        String string = this.pkgName = ids.pkgName.equals("") ? "lexer" : ids.pkgName + ".lexer";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    @Override
    public void caseStart(Start tree) {
        int numStates = Math.max(1, this.ids.stateList.size());
        this.acceptStatesArray = new AcceptStates[numStates];
        String[] names = new String[numStates];
        if (this.ids.stateList.size() == 0) {
            names[0] = "INITIAL";
        } else {
            Iterator iter = this.ids.stateList.iterator();
            for (int i = 0; i < numStates; ++i) {
                names[i] = (String)iter.next();
            }
        }
        for (int i = 0; i < numStates; ++i) {
            System.out.println(" State: " + names[i]);
            System.out.println(" - Constructing NFA.");
            ConstructNFA nfaConstructor = new ConstructNFA(this.ids, names[i]);
            tree.apply(nfaConstructor);
            System.out.println();
            NFA nfa = (NFA)nfaConstructor.getOut(tree);
            nfaConstructor = null;
            System.out.println(" - Constructing DFA.");
            DFA dfa = new DFA(nfa);
            System.out.println();
            System.out.println(" - resolving ACCEPT states.");
            this.acceptStatesArray[i] = new AcceptStates(dfa, this.ids, names[i]);
            tree.apply(this.acceptStatesArray[i]);
        }
        this.transitions = new Transitions();
        tree.apply(this.transitions);
        this.createLexerException();
        this.createIPushbackReader();
        this.createLexer();
    }

    private void createLexerException() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "LexerException.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "LexerException.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "LexerException", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node"});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "LexerException.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createIPushbackReader() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "IPushbackReader.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "IPushbackReader.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "IPushbackReader", new String[]{this.pkgName});
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "IPushbackReader.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createLexer() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Lexer.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Lexer.java").getAbsolutePath());
        }
        try {
            Vector innerArray;
            boolean fixed;
            Node node;
            String name;
            String startState = "INITIAL";
            if (this.ids.stateList.size() > 0) {
                startState = (String)this.ids.stateList.getFirst();
            }
            this.macros.apply(file, "LexerHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node", startState});
            ListIterator i = this.ids.tokenList.listIterator();
            while (i.hasNext()) {
                name = (String)i.next();
                node = (Node)this.ids.tokens.get(name);
                fixed = (Boolean)this.ids.fixedTokens.get(node);
                if (fixed) {
                    this.macros.apply(file, "LexerFixedToken", new String[]{"" + i.previousIndex(), name});
                } else {
                    this.macros.apply(file, "LexerVariableToken", new String[]{"" + i.previousIndex(), name});
                }
                Map map = (Map)this.transitions.tokenStates.get(node);
                if (map.size() > 0) {
                    this.macros.apply(file, "TokenSwitchHeader", null);
                    for (Map.Entry entry : map.entrySet()) {
                        this.macros.apply(file, "TokenCase", new String[]{this.ids.stateList.indexOf((String)entry.getKey()) + "", (String)entry.getValue()});
                    }
                    this.macros.apply(file, "TokenSwitchTail", null);
                }
                this.macros.apply(file, "LexerTokenTail", null);
            }
            this.macros.apply(file, "LexerBody1");
            i = this.ids.tokenList.listIterator();
            while (i.hasNext()) {
                name = (String)i.next();
                node = (Node)this.ids.tokens.get(name);
                fixed = (Boolean)this.ids.fixedTokens.get(node);
                if (fixed) {
                    this.macros.apply(file, "LexerNewFixedToken", new String[]{"" + i.previousIndex(), name});
                    continue;
                }
                this.macros.apply(file, "LexerNewVariableToken", new String[]{"" + i.previousIndex(), name});
            }
            this.macros.apply(file, "LexerBody2");
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.pkgDir, "lexer.dat"))));
            out.writeInt(this.acceptStatesArray.length);
            for (int accSt = 0; accSt < this.acceptStatesArray.length; ++accSt) {
                DFA dfa = this.acceptStatesArray[accSt].dfa;
                file.write("        { // " + this.acceptStatesArray[accSt].stateName + System.getProperty("line.separator"));
                Vector<Vector> outerArray = new Vector<Vector>();
                for (int i2 = 0; i2 < dfa.states.size(); ++i2) {
                    innerArray = new Vector();
                    DFA.State state = (DFA.State)dfa.states.elementAt(i2);
                    file.write("            {");
                    for (int j = 0; j < state.transitions.size(); ++j) {
                        DFA.Transition transition = (DFA.Transition)state.transitions.elementAt(j);
                        file.write("{" + transition.interval().start + ", " + transition.interval().end + ", " + transition.destination + "}, ");
                        innerArray.addElement(new int[]{transition.interval().start, transition.interval().end, transition.destination});
                    }
                    file.write("}," + System.getProperty("line.separator"));
                    outerArray.addElement(innerArray);
                }
                file.write("        }" + System.getProperty("line.separator"));
                out.writeInt(outerArray.size());
                Enumeration e = outerArray.elements();
                while (e.hasMoreElements()) {
                    innerArray = (Vector)e.nextElement();
                    out.writeInt(innerArray.size());
                    Enumeration n = innerArray.elements();
                    while (n.hasMoreElements()) {
                        int[] array = (int[])n.nextElement();
                        for (int i3 = 0; i3 < 3; ++i3) {
                            out.writeInt(array[i3]);
                        }
                    }
                }
            }
            this.macros.apply(file, "LexerAcceptHeader");
            int stateNumber = this.acceptStatesArray.length;
            Vector<Vector> outerArray = new Vector<Vector>();
            for (int i4 = 0; i4 < stateNumber; ++i4) {
                DFA dfa = this.acceptStatesArray[i4].dfa;
                innerArray = new Vector();
                file.write("        // " + this.acceptStatesArray[i4].stateName + System.getProperty("line.separator"));
                file.write("        {");
                for (int j = 0; j < dfa.states.size(); ++j) {
                    DFA.State state = (DFA.State)dfa.states.elementAt(j);
                    file.write(state.accept + ", ");
                    innerArray.addElement(new Integer(state.accept));
                }
                file.write("}," + System.getProperty("line.separator"));
                outerArray.addElement(innerArray);
            }
            out.writeInt(outerArray.size());
            Enumeration e = outerArray.elements();
            while (e.hasMoreElements()) {
                Vector innerArray2 = (Vector)e.nextElement();
                out.writeInt(innerArray2.size());
                Enumeration n = innerArray2.elements();
                while (n.hasMoreElements()) {
                    Integer i5 = (Integer)n.nextElement();
                    out.writeInt(i5);
                }
            }
            out.close();
            file.write(System.getProperty("line.separator"));
            this.macros.apply(file, "LexerAcceptTail");
            this.macros.apply(file, "LexerStateHeader");
            if (this.ids.stateList.size() > 0) {
                ListIterator i6 = this.ids.stateList.listIterator();
                while (i6.hasNext()) {
                    String s = (String)i6.next();
                    this.macros.apply(file, "LexerStateBody", new String[]{s, "" + i6.previousIndex()});
                }
            } else {
                this.macros.apply(file, "LexerStateBody", new String[]{"INITIAL", "0"});
            }
            this.macros.apply(file, "LexerStateTail");
            this.macros.apply(file, "LexerTail");
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Lexer.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

