/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.references.CssIdentifierReference;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.css.resolve.UrlReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xml.util.AnchorReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssInvalidElementInspection
extends CssBaseInspection {
    private static boolean isValueForMatchingElement(PsiElement element) {
        CssDeclaration declaration = CssUtil.getDeclaration(element);
        if (declaration != null) {
            PsiElement child = declaration.getFirstChild();
            return child != element && CssInvalidElementInspection.isMatchingElement(child);
        }
        return false;
    }

    private static boolean isMatchingElement(PsiElement element) {
        if (element instanceof PsiErrorElement) {
            return false;
        }
        if (element instanceof OuterLanguageElement) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof CssDeclaration && parent.getFirstChild() == element) {
            return ((CssDeclaration)parent).getDescriptor() == null;
        }
        return false;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.invalid.element", (Object[])new Object[0]);
        if (string == null) {
            CssInvalidElementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidElementInspection.$$$reportNull$$$0(1);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssString(CssString _string) {
                CssInvalidElementInspection.processElement((PsiElement)_string, holder);
            }

            public void visitElement(PsiElement token) {
                if (token instanceof CssTokenImpl) {
                    if (!CssBaseInspection.isSuitableElement(token)) {
                        return;
                    }
                    if (CssUtil.getDeclaration(token) == null || CssElementTypes.CSS_URL == ((CssTokenImpl)token).getElementType()) {
                        CssInvalidElementInspection.processElement(token, holder);
                    }
                }
            }
        };
        if (cssElementVisitor == null) {
            CssInvalidElementInspection.$$$reportNull$$$0(2);
        }
        return cssElementVisitor;
    }

    private static void processElement(@NotNull PsiElement element, ProblemsHolder holder) {
        PsiElement psiElement;
        if (element == null) {
            CssInvalidElementInspection.$$$reportNull$$$0(3);
        }
        if (!element.isValid()) {
            return;
        }
        if (element.getNextSibling() instanceof PsiErrorElement && (psiElement = PsiTreeUtil.prevLeaf((PsiElement)element)) != null && PsiTreeUtil.getChildOfType((PsiElement)psiElement, OuterLanguageElement.class) != null) {
            return;
        }
        String text = element.getText();
        if (text != null && CssPropertyUtil.isVendorSpecificElement(text)) {
            return;
        }
        if ((!CssInvalidElementInspection.isMatchingElement(element) && !CssInvalidElementInspection.isValueForMatchingElement(element) || element instanceof CssString && PsiTreeUtil.getParentOfType((PsiElement)element, CssFunction.class) != null) && element.isValid()) {
            PsiReference[] references;
            for (PsiReference reference : references = element.getReferences()) {
                boolean unresolved;
                if (reference instanceof FileReferenceOwner || reference instanceof UrlReference || reference instanceof AnchorReference || reference instanceof CssIdentifierReference || reference.isSoft() || !reference.getElement().isValid()) continue;
                if (reference instanceof PsiPolyVariantReference) {
                    unresolved = ((PsiPolyVariantReference)reference).multiResolve(false).length == 0;
                } else {
                    boolean bl = unresolved = reference.resolve() == null;
                }
                if (!unresolved) continue;
                String errorMessage = null;
                if (reference instanceof CssReference) {
                    errorMessage = ((CssReference)reference).getUnresolvedMessagePattern();
                } else if (reference instanceof EmptyResolveMessageProvider && !reference.isSoft()) {
                    errorMessage = ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference);
                }
                if (StringUtil.isEmpty((String)errorMessage)) continue;
                holder.registerProblem(reference, errorMessage, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssInvalidElementInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssInvalidElementInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

