/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.codeinsight;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.psi.StylusVariableDeclaration;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinInvocationImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusVariableDeclarationImpl;
import org.jetbrains.plugins.stylus.psi.impl.StylusVariableImpl;

public class StylusRenameInputValidator
implements RenameInputValidator {
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("[@$]?([_A-Za-z][_A-Za-z0-9]*)(-[_A-Za-z][_A-Za-z0-9]*)*");
    private static final Pattern MIXIN_NAME_PATTERN = Pattern.compile("[.#]?([_A-Za-z][_A-Za-z0-9]*)(-[_A-Za-z][_A-Za-z0-9]*)*");

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        ElementPattern elementPattern = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(StylusVariableDeclarationImpl.class), PlatformPatterns.psiElement(StylusVariableImpl.class), PlatformPatterns.psiElement(StylusMixinImpl.class), PlatformPatterns.psiElement(StylusMixinInvocationImpl.class)});
        if (elementPattern == null) {
            StylusRenameInputValidator.$$$reportNull$$$0(0);
        }
        return elementPattern;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (newName == null) {
            StylusRenameInputValidator.$$$reportNull$$$0(1);
        }
        if (element == null) {
            StylusRenameInputValidator.$$$reportNull$$$0(2);
        }
        if (context == null) {
            StylusRenameInputValidator.$$$reportNull$$$0(3);
        }
        if (element instanceof StylusVariableDeclaration || element instanceof StylusVariableImpl) {
            return VARIABLE_NAME_PATTERN.matcher(newName).matches();
        }
        return MIXIN_NAME_PATTERN.matcher(newName).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/stylus/codeinsight/StylusRenameInputValidator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/stylus/codeinsight/StylusRenameInputValidator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInputValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

