/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.lexer;

import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.lexer.PuppetLexerKeywords;
import com.intellij.lang.puppet.settings.PuppetProjectConfiguration;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Queue;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class PuppetLexerBase
implements FlexLexer,
PuppetTokenTypes {
    public static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-z][\\-a-zA-Z0-9_]*");
    private final AtomicNotNullLazyValue<PuppetLanguage.Version> myPuppetVersion = new AtomicNotNullLazyValue<PuppetLanguage.Version>(){

        @NotNull
        protected PuppetLanguage.Version compute() {
            if (PuppetLexerBase.this.myProject == null) {
                PuppetLanguage.Version version = PuppetLanguage.Version.PUPPET_4;
                if (version == null) {
                    1.$$$reportNull$$$0(0);
                }
                return version;
            }
            PuppetLanguage.Version version = PuppetProjectConfiguration.getInstance(PuppetLexerBase.this.myProject).getLanguageVersion();
            if (version == null) {
                1.$$$reportNull$$$0(1);
            }
            return version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/puppet/lexer/PuppetLexerBase$1", "compute"));
        }
    };
    private static final TokenSet PRE_FQN_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CLASS, DEFINE, FUNCTION});
    private final Project myProject;
    protected final Stack<Integer> stack = new Stack();
    protected final Queue<HeredocInfo> myHeredocQueue = new Queue(1);
    private boolean myIsLookLikeIncompleteHeredocOpenerLine = false;
    private final Map<String, IElementType> myKeywordsMap;

    public PuppetLexerBase() {
        this(null);
    }

    public PuppetLexerBase(Project project) {
        this.myProject = project;
        this.myKeywordsMap = PuppetLexerKeywords.getKeywordsMap(project);
    }

    protected void pushStateAndBegin(int state) {
        this.pushState();
        this.myYyBegin(state);
    }

    protected void pushState() {
        this.stack.push(this.yystate());
    }

    protected void popState() {
        if (!this.stack.empty()) {
            this.myYyBegin(this.stack.pop());
        } else {
            this.myYyBegin(0);
        }
    }

    protected void myYyBegin(int state) {
        if (state == 0 && !this.isSafeToInit()) {
            this.yybegin(8);
        } else if (state == 8 && this.isSafeToInit()) {
            this.yybegin(0);
        } else {
            this.yybegin(state);
        }
    }

    private void refreshState() {
        this.myYyBegin(this.yystate());
    }

    protected void setLookLikeIncompleteHeredocOpenerLine(boolean newValue) {
        this.myIsLookLikeIncompleteHeredocOpenerLine = newValue;
        this.refreshState();
    }

    private boolean isSafeToInit() {
        return this.stack.empty() && this.myHeredocQueue.isEmpty() && !this.myIsLookLikeIncompleteHeredocOpenerLine;
    }

    public void clearOnReset() {
        this.stack.clear();
        this.myHeredocQueue.clear();
        this.myIsLookLikeIncompleteHeredocOpenerLine = false;
    }

    protected PuppetLanguage.Version getLanguageVersion() {
        return (PuppetLanguage.Version)((Object)this.myPuppetVersion.getValue());
    }

    protected boolean isPuppet3() {
        return this.getLanguageVersion() == PuppetLanguage.Version.PUPPET_3;
    }

    protected IElementType proxyLiteralToken(IElementType tokenType) {
        this.myYyBegin(4);
        return tokenType;
    }

    protected IElementType getNameOrKeywordToken() {
        IElementType elementType = this.myKeywordsMap.get(this.yytext().toString());
        if (elementType == null) {
            return this.proxyLiteralToken(NAME);
        }
        if (PRE_FQN_TOKENS.contains(elementType)) {
            this.myYyBegin(14);
        } else {
            this.myYyBegin(16);
        }
        return elementType;
    }

    protected IElementType lexLBrack() {
        if (this.isPuppet3()) {
            return LBRACK;
        }
        return this.getTokenStart() == 0 || Character.isWhitespace(this.yycharat(-1)) ? LISTSTART : LBRACK;
    }

    protected boolean isCurrentHeredocCloser() {
        return this.yytext().toString().trim().endsWith(((HeredocInfo)this.myHeredocQueue.peekFirst()).myEndTag);
    }

    protected void pushback() {
        this.yypushback(this.yylength());
    }

    public abstract int yylength();

    public abstract void yypushback(int var1);

    public abstract CharSequence yytext();

    public abstract int getTokenStart();

    public abstract char yycharat(int var1);

    public abstract void setTokenEnd(int var1);

    protected static class HeredocInfo {
        final String myEndTag;
        final boolean myInterpolationAllowed;

        public HeredocInfo(String endTag, boolean isInterpolationAllowed) {
            this.myEndTag = endTag;
            this.myInterpolationAllowed = isInterpolationAllowed;
        }
    }
}

