/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.ruby;

import com.intellij.lang.puppet.ide.navigation.plugins.PuppetExtFunctionInfo;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.PuppetRubyPluginsIndex;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

final class RubyTypeIndexer
implements DataIndexer<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo, FileContent> {
    private static final Pattern RUBY_ADD_TYPE_PATTERN = Pattern.compile("newtype\\s*\\((?:\"|'|:)([^ ,)\"]+)(?:\"|')?(?:\\)|,)");
    private static final Pattern RUBY_TYPE_PARAM_PATTERN = Pattern.compile("new(?:param|property)\\s*\\((?:\"|'|:)([^ ,)\"]+)(?:\"|')?(?:\\)|,)");
    private static final Pattern RUBY_ENSURABLE_PATTERN = Pattern.compile("ensurable");
    private static final String ENSURE_PARAM_NAME = "ensure";

    RubyTypeIndexer() {
    }

    @NotNull
    public Map<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            RubyTypeIndexer.$$$reportNull$$$0(0);
        }
        HashMap<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo> result = new HashMap<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo>();
        CharSequence fileContents = inputData.getContentAsText();
        Matcher typeMatcher = RUBY_ADD_TYPE_PATTERN.matcher(fileContents);
        while (typeMatcher.find()) {
            String typeName = typeMatcher.group(1);
            if (!inputData.getFileName().equals(typeName + ".rb")) continue;
            ArrayList<PuppetExtFunctionInfo.PuppetExtParamInfo> paramInfos = new ArrayList<PuppetExtFunctionInfo.PuppetExtParamInfo>();
            Matcher paramsMatcher = RUBY_TYPE_PARAM_PATTERN.matcher(fileContents.subSequence(typeMatcher.start(), fileContents.length()));
            while (paramsMatcher.find()) {
                String paramName = paramsMatcher.group(1);
                int paramOffset = paramsMatcher.start(1);
                paramInfos.add(new PuppetExtFunctionInfo.PuppetExtParamInfo(typeMatcher.start() + paramOffset, paramName, null));
            }
            Matcher ensurableMatcher = RUBY_ENSURABLE_PATTERN.matcher(fileContents.subSequence(typeMatcher.start(), fileContents.length()));
            if (ensurableMatcher.find()) {
                int offset = ensurableMatcher.start();
                paramInfos.add(new PuppetExtFunctionInfo.PuppetExtParamInfo(typeMatcher.start() + offset, ENSURE_PARAM_NAME, null));
            }
            int typeNameOffset = typeMatcher.start(1);
            result.put(new PuppetRubyPluginsIndex.EntryKey(PuppetRubyPluginsIndex.SymbolType.TYPE, typeName.toLowerCase(Locale.US)), new PuppetExtFunctionInfo(inputData.getFile().getUrl(), typeNameOffset, paramInfos));
        }
        HashMap<PuppetRubyPluginsIndex.EntryKey, PuppetExtFunctionInfo> hashMap = result;
        if (hashMap == null) {
            RubyTypeIndexer.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/RubyTypeIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/RubyTypeIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

