/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.rails;

import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Shape;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.mongoid.associations.MongoAssociationFactory;
import org.jetbrains.plugins.ruby.rails.associations.AssociationType;

public class RailsUmlRelationship
extends DiagramRelationshipInfoAdapter {
    private static final Color ERROR_LABEL_COLOR = new JBColor(new Color(244, 47, 51), new Color(244, 47, 51));
    private static final Color OK_LABEL_COLOR = JBColor.foreground();
    private final Association myAssociation;
    private final Association myReverseAssociation;
    private Shape myEndArrow = NONE;
    private Shape myStartArrow = NONE;
    private DiagramLineType myLineType;
    private String myFromLabel;
    private String myToLabel;
    private Color myFromLabelColor;

    public RailsUmlRelationship(Association association, Association reverseAssociation) {
        super((String)(association == null ? (reverseAssociation == null ? null : reverseAssociation.getName()) : association.getName()));
        this.myAssociation = association;
        this.myReverseAssociation = reverseAssociation;
        this.initializeRelationArrows();
        this.initializeArrowLabels();
    }

    @Nullable
    public Association getAssociation() {
        return this.myAssociation;
    }

    @Nullable
    public Association getReverseAssociation() {
        return this.myReverseAssociation;
    }

    public DiagramLineType getLineType() {
        return this.myLineType;
    }

    public String getFromLabel() {
        return this.myFromLabel;
    }

    public String getToLabel() {
        return this.myToLabel;
    }

    public Color getLabelColor() {
        return OK_LABEL_COLOR;
    }

    public Color getFromLabelColor() {
        return this.myFromLabelColor;
    }

    public Color getToLabelColor() {
        return OK_LABEL_COLOR;
    }

    public AssociationType getAssociationType() {
        return this.myAssociation != null ? this.myAssociation.getType() : AssociationType.UNDEFINED;
    }

    public boolean isInvalid() {
        if (this.myAssociation == null) {
            return false;
        }
        return this.myAssociation.getType() != AssociationType.BELONGS_TO && this.myReverseAssociation == null && this.myAssociation.getThroughModels().isEmpty();
    }

    public AssociationType getReverseAssociationType() {
        return this.myReverseAssociation.getType();
    }

    public Shape getStartArrow() {
        return this.myStartArrow;
    }

    public Shape getEndArrow() {
        return this.myEndArrow;
    }

    private void initializeRelationArrows() {
        this.setLineType();
        if (this.myReverseAssociation != null) {
            switch (this.getReverseAssociationType()) {
                case BELONGS_TO: {
                    this.myEndArrow = DIAMOND;
                    break;
                }
                case HAS_AND_BELONGS_TO_MANY: 
                case HAS_MANY: 
                case HAS_ONE: 
                case UNDEFINED: {
                    this.myEndArrow = NONE;
                    break;
                }
                case EMBEDS_ONE: {
                    this.myEndArrow = STANDARD;
                }
                case EMBEDDED_IN: {
                    this.myStartArrow = NONE;
                }
                case EMBEDS_MANY: {
                    this.myEndArrow = STANDARD;
                }
            }
        }
        switch (this.getAssociationType()) {
            case BELONGS_TO: {
                this.myStartArrow = this.myReverseAssociation == null ? STANDARD : DIAMOND;
                break;
            }
            case HAS_AND_BELONGS_TO_MANY: 
            case HAS_MANY: 
            case HAS_ONE: {
                this.myStartArrow = NONE;
                break;
            }
            case UNDEFINED: {
                this.myStartArrow = WHITE_DELTA;
                break;
            }
            case EMBEDS_ONE: {
                this.myStartArrow = NONE;
            }
            case EMBEDDED_IN: {
                this.myStartArrow = STANDARD;
            }
            case EMBEDS_MANY: {
                this.myStartArrow = NONE;
            }
        }
    }

    private void setLineType() {
        this.myLineType = this.myAssociation != null && this.myAssociation.getFactory() instanceof MongoAssociationFactory ? DiagramLineType.DASHED : DiagramLineType.SOLID;
    }

    private void initializeArrowLabels() {
        AssociationType type = this.getAssociationType();
        String to = type.getType();
        if (this.myReverseAssociation != null || this.isInvalid()) {
            String from;
            if (this.isInvalid()) {
                from = "?";
                this.myFromLabelColor = ERROR_LABEL_COLOR;
            } else {
                from = this.myReverseAssociation.getType().getType();
            }
            this.myFromLabel = from;
            this.myToLabel = to;
        } else {
            this.myToLabel = to;
        }
        if (this.myFromLabelColor == null) {
            this.myFromLabelColor = OK_LABEL_COLOR;
        }
    }
}

