/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.gradienteditor.ui.basic;

import com.michaelbaranov.microba.common.BoundedTableModel;
import com.michaelbaranov.microba.gradient.GradientBar;
import com.michaelbaranov.microba.gradienteditor.GradientEditor;
import com.michaelbaranov.microba.gradienteditor.ui.GradientEditorLayout;
import com.michaelbaranov.microba.gradienteditor.ui.GradientEditorUI;
import com.michaelbaranov.microba.marker.MarkerBar;
import com.michaelbaranov.microba.marker.MarkerMutationModel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ComponentUI;

public class BasicGradientEditorUI
extends GradientEditorUI {
    protected GradientBar gradientBar;
    protected MarkerBar colorBar;
    protected MarkerBar alphaBar;
    private GradientEditor gradient;
    private GradientEditorListener editorListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicGradientEditorUI();
    }

    public void installUI(JComponent component) {
        this.gradient = (GradientEditor)component;
        this.editorListener = new GradientEditorListener();
        this.createAndConfigureSubcomponents();
        this.installSubcomponents();
        this.installListeners();
        this.gradient.revalidate();
    }

    public void uninstallUI(JComponent component) {
        this.uninstallSubcomponents();
        this.uninstallListeners();
    }

    protected void installSubcomponents() {
        this.gradient.setLayout(new GradientEditorLayout(this.colorBar, this.gradientBar));
        this.gradient.add(this.colorBar);
        this.gradient.add(this.gradientBar);
    }

    protected void uninstallSubcomponents() {
        this.gradient.setLayout(new FlowLayout());
        this.gradient.remove(this.colorBar);
        this.gradient.remove(this.gradientBar);
    }

    private void installListeners() {
        this.gradient.addPropertyChangeListener(this.editorListener);
    }

    private void uninstallListeners() {
        this.gradient.removePropertyChangeListener(this.editorListener);
    }

    private void createAndConfigureSubcomponents() {
        this.gradientBar = new GradientBar(this.gradient.getDataModel());
        this.gradientBar.setOrientation(this.gradient.getOrientation());
        this.gradientBar.setColorPositionColumn(this.gradient.getColorPositionColumn());
        this.gradientBar.setColorColumn(this.gradient.getColorColumn());
        this.colorBar = new MarkerBar(this.gradient.getDataModel(), this.gradient.getColorSelectionModel());
        this.colorBar.setOrientation(this.gradient.getOrientation());
        this.colorBar.setMutationModel(this.gradient.getColorMutationModel());
        this.colorBar.setPositionColumn(this.gradient.getColorPositionColumn());
        this.colorBar.setColorColumn(this.gradient.getColorColumn());
        this.alphaBar = new MarkerBar(this.gradient.getDataModel(), this.gradient.getColorSelectionModel());
        this.alphaBar.setOrientation(this.gradient.getOrientation());
        this.alphaBar.setMutationModel(this.gradient.getColorMutationModel());
        this.alphaBar.setPositionColumn(this.gradient.getColorPositionColumn());
        this.alphaBar.setColorColumn(this.gradient.getColorColumn());
    }

    public Dimension getMinimumSize(JComponent c) {
        GradientBar gradient = (GradientBar)c;
        Dimension minimumSize = this.gradientBar.getMinimumSize();
        Dimension minimumSize2 = this.colorBar.getMinimumSize();
        if (gradient.getOrientation() == 0) {
            return new Dimension(Math.max(minimumSize.width, minimumSize2.width), minimumSize.height + minimumSize2.height);
        }
        return new Dimension(minimumSize.width + minimumSize2.width, Math.max(minimumSize.height, minimumSize2.height));
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension preferredSize = this.gradientBar.getPreferredSize();
        Dimension preferredSize2 = this.colorBar.getPreferredSize();
        if (this.gradient.getOrientation() == 0) {
            return new Dimension(Math.max(preferredSize.width, preferredSize2.width), preferredSize.height + preferredSize2.height);
        }
        return new Dimension(preferredSize.width + preferredSize2.width, Math.max(preferredSize.height, preferredSize2.height));
    }

    class GradientEditorListener
    implements PropertyChangeListener {
        GradientEditorListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("dataModel".equals(evt.getPropertyName())) {
                BasicGradientEditorUI.this.gradientBar.setDataModel((BoundedTableModel)evt.getNewValue());
                BasicGradientEditorUI.this.colorBar.setDataModel((BoundedTableModel)evt.getNewValue());
            }
            if ("colorSelectionModel".equals(evt.getPropertyName())) {
                BasicGradientEditorUI.this.colorBar.setSelectionModel((ListSelectionModel)evt.getNewValue());
            }
            if ("colorMutationModel".equals(evt.getPropertyName())) {
                BasicGradientEditorUI.this.colorBar.setMutationModel((MarkerMutationModel)evt.getNewValue());
            }
            if ("colorPositionColumn".equals(evt.getPropertyName())) {
                BasicGradientEditorUI.this.colorBar.setPositionColumn((Integer)evt.getNewValue());
                BasicGradientEditorUI.this.gradientBar.setColorPositionColumn((Integer)evt.getNewValue());
            }
            if ("colorColumn".equals(evt.getPropertyName())) {
                BasicGradientEditorUI.this.gradientBar.setColorColumn((Integer)evt.getNewValue());
                BasicGradientEditorUI.this.colorBar.setColorColumn((Integer)evt.getNewValue());
            }
            if ("orientation".equals(evt.getPropertyName())) {
                BasicGradientEditorUI.this.colorBar.setOrientation((Integer)evt.getNewValue());
                BasicGradientEditorUI.this.gradientBar.setOrientation((Integer)evt.getNewValue());
            }
            if ("enabled".equals(evt.getPropertyName())) {
                BasicGradientEditorUI.this.colorBar.setEnabled((Boolean)evt.getNewValue());
                BasicGradientEditorUI.this.gradientBar.setEnabled((Boolean)evt.getNewValue());
            }
        }
    }
}

